/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.data.jpa.FilterGenerator;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class FilterGeneratorCollectionsCoersionTest
extends KRADTestCase {
    @Test
    public void testBooleanCollectionMatch() throws Exception {
        BooleanParent parent = new BooleanParent();
        parent = (BooleanParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        parent.setChildren(this.getBoolChildrenMatchList(parent));
        parent = (BooleanParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        BooleanParent persistedParent = (BooleanParent)this.getDataObjectService().find(BooleanParent.class, (Object)parent.getId());
        Assert.assertTrue((String)"No parent class found.", (persistedParent != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"There should be 2 child items in the collection.", (long)2L, (long)persistedParent.getChildren().size());
        Assert.assertEquals((String)"First child item value is incorrect", (Object)Boolean.TRUE, (Object)persistedParent.getChildren().get(0).getBoolProp());
        Assert.assertEquals((String)"Second child item value is incorrect", (Object)Boolean.TRUE, (Object)persistedParent.getChildren().get(1).getBoolProp());
        this.getDataObjectService().delete((Object)parent);
        this.getDataObjectService().flush(BooleanParent.class);
    }

    @Test
    public void testBooleanCollectionNoMatch() throws Exception {
        BooleanParent parent = new BooleanParent();
        parent = (BooleanParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        parent.setChildren(this.getBoolChildrenNoMatchList(parent));
        parent = (BooleanParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        BooleanParent persistedParent = (BooleanParent)this.getDataObjectService().find(BooleanParent.class, (Object)parent.getId());
        Assert.assertNotNull((String)"Parent class should not be null.", (Object)persistedParent);
        Assert.assertTrue((String)"Collection of child items should be empty.", (persistedParent.getChildren().size() < 1 ? 1 : 0) != 0);
        this.getDataObjectService().delete((Object)parent);
        this.getDataObjectService().flush(BooleanParent.class);
    }

    @Test
    public void testIntegerCollectionMatch() {
        IntegerParent parent = new IntegerParent();
        parent = (IntegerParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        parent.setChildren(this.getIntChildMatchList(parent));
        parent = (IntegerParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        IntegerParent persistedParent = (IntegerParent)this.getDataObjectService().find(IntegerParent.class, (Object)parent.getId());
        Assert.assertTrue((String)"The parent class should not be null.", (persistedParent != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"There should be two child items in the collection.", (long)2L, (long)persistedParent.getChildren().size());
        Assert.assertEquals((String)"First child item value is incorrect", (long)35L, (long)persistedParent.getChildren().get(0).getIntegerProp());
        Assert.assertEquals((String)"Second child item value is incorrect", (long)35L, (long)persistedParent.getChildren().get(1).getIntegerProp());
        this.getDataObjectService().delete((Object)parent);
        this.getDataObjectService().flush(IntegerParent.class);
    }

    @Test
    public void testIntegerCollectionNoMatch() {
        IntegerParent parent = new IntegerParent();
        parent = (IntegerParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        parent.setChildren(this.getIntChildNoMatchList(parent));
        parent = (IntegerParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        IntegerParent persistedParent = (IntegerParent)this.getDataObjectService().find(IntegerParent.class, (Object)parent.getId());
        Assert.assertNotNull((String)"Parent class should not be null.", (Object)persistedParent);
        Assert.assertTrue((String)"Collection of child items should be empty.", (persistedParent.getChildren().size() < 1 ? 1 : 0) != 0);
        this.getDataObjectService().delete((Object)parent);
        this.getDataObjectService().flush(IntegerParent.class);
    }

    @Test
    public void testCharCollectionMatch() {
        CharParent parent = new CharParent();
        parent = (CharParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        parent.setChildren(this.getCharChildMatchList(parent));
        parent = (CharParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        CharParent persistedParent = (CharParent)this.getDataObjectService().find(CharParent.class, (Object)parent.getId());
        Assert.assertTrue((String)"The parent class should not be null.", (persistedParent != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"There should be two child items in the collection.", (long)2L, (long)persistedParent.getChildren().size());
        Assert.assertEquals((String)"First child item value is incorrect", (long)107L, (long)persistedParent.getChildren().get(0).getCharProp());
        Assert.assertEquals((String)"Second child item value is incorrect", (long)107L, (long)persistedParent.getChildren().get(1).getCharProp());
        this.getDataObjectService().delete((Object)parent);
        this.getDataObjectService().flush(IntegerParent.class);
    }

    @Test
    public void testCharCollectionNoMatch() {
        CharParent parent = new CharParent();
        parent = (CharParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        parent.setChildren(this.getCharChildNoMatchList(parent));
        parent = (CharParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        CharParent persistedParent = (CharParent)this.getDataObjectService().find(CharParent.class, (Object)parent.getId());
        Assert.assertNotNull((String)"Parent class should not be null.", (Object)persistedParent);
        Assert.assertTrue((String)"Collection of child items should be empty.", (persistedParent.getChildren().size() < 1 ? 1 : 0) != 0);
        this.getDataObjectService().delete((Object)parent);
        this.getDataObjectService().flush(CharParent.class);
    }

    @Test
    public void testShortCollectionMatch() {
        ShortParent parent = new ShortParent();
        parent = (ShortParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        parent.setChildren(this.getShortChildMatchList(parent));
        parent = (ShortParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        ShortParent persistedParent = (ShortParent)this.getDataObjectService().find(ShortParent.class, (Object)parent.getId());
        Assert.assertTrue((String)"The parent class should not be null.", (persistedParent != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"There should be two child items in the collection.", (long)2L, (long)persistedParent.getChildren().size());
        Assert.assertEquals((String)"First child item value is incorrect", (long)255L, (long)persistedParent.getChildren().get(0).getShortProp());
        Assert.assertEquals((String)"Second child item value is incorrect", (long)255L, (long)persistedParent.getChildren().get(1).getShortProp());
        this.getDataObjectService().delete((Object)parent);
        this.getDataObjectService().flush(ShortParent.class);
    }

    @Test
    public void testShortCollectionNoMatch() {
        ShortParent parent = new ShortParent();
        parent = (ShortParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        parent.setChildren(this.getShortChildNoMatchList(parent));
        parent = (ShortParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        ShortParent persistedParent = (ShortParent)this.getDataObjectService().find(ShortParent.class, (Object)parent.getId());
        Assert.assertNotNull((String)"Parent class should not be null.", (Object)persistedParent);
        Assert.assertTrue((String)"Collection of child items should be empty.", (persistedParent.getChildren().size() < 1 ? 1 : 0) != 0);
        this.getDataObjectService().delete((Object)parent);
        this.getDataObjectService().flush(ShortParent.class);
    }

    @Test
    public void testLongCollectionMatch() {
        LongParent parent = new LongParent();
        parent = (LongParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        parent.setChildren(this.getLongChildMatchList(parent));
        parent = (LongParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        LongParent persistedParent = (LongParent)this.getDataObjectService().find(LongParent.class, (Object)parent.getId());
        Assert.assertTrue((String)"The parent class should not be null.", (persistedParent != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"There should be two child items in the collection.", (long)2L, (long)persistedParent.getChildren().size());
        Assert.assertEquals((String)"First child item value is incorrect", (long)10L, (long)persistedParent.getChildren().get(0).getLongProp());
        Assert.assertEquals((String)"Second child item value is incorrect", (long)10L, (long)persistedParent.getChildren().get(1).getLongProp());
        this.getDataObjectService().delete((Object)parent);
        this.getDataObjectService().flush(LongParent.class);
    }

    @Test
    public void testLongCollectionNoMatch() {
        LongParent parent = new LongParent();
        parent = (LongParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        parent.setChildren(this.getLongChildNoMatchList(parent));
        parent = (LongParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        LongParent persistedParent = (LongParent)this.getDataObjectService().find(LongParent.class, (Object)parent.getId());
        Assert.assertNotNull((String)"Parent class should not be null.", (Object)persistedParent);
        Assert.assertTrue((String)"Collection of child items should be empty.", (persistedParent.getChildren().size() < 1 ? 1 : 0) != 0);
        this.getDataObjectService().delete((Object)parent);
        this.getDataObjectService().flush(LongParent.class);
    }

    @Test
    public void testFloatCollectionMatch() {
        FloatParent parent = new FloatParent();
        parent = (FloatParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        parent.setChildren(this.getFloatChildMatchList(parent));
        parent = (FloatParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        FloatParent persistedParent = (FloatParent)this.getDataObjectService().find(FloatParent.class, (Object)parent.getId());
        Assert.assertTrue((String)"The parent class should not be null.", (persistedParent != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"There should be two child items in the collection.", (long)2L, (long)persistedParent.getChildren().size());
        Assert.assertEquals((String)"First child item value is incorrect", (double)3.14f, (double)persistedParent.getChildren().get(0).getFloatProp(), (double)0.0);
        Assert.assertEquals((String)"Second child item value is incorrect", (double)3.14f, (double)persistedParent.getChildren().get(1).getFloatProp(), (double)0.0);
        this.getDataObjectService().delete((Object)parent);
        this.getDataObjectService().flush(FloatParent.class);
    }

    @Test
    public void testFloatCollectionNoMatch() {
        FloatParent parent = new FloatParent();
        parent = (FloatParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        parent.setChildren(this.getFloatChildNoMatchList(parent));
        parent = (FloatParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        FloatParent persistedParent = (FloatParent)this.getDataObjectService().find(FloatParent.class, (Object)parent.getId());
        Assert.assertNotNull((String)"Parent class should not be null.", (Object)persistedParent);
        Assert.assertTrue((String)"Collection of child items should be empty.", (persistedParent.getChildren().size() < 1 ? 1 : 0) != 0);
        this.getDataObjectService().delete((Object)parent);
        this.getDataObjectService().flush(FloatParent.class);
    }

    @Test
    public void testDoubleCollectionMatch() {
        DoubleParent parent = new DoubleParent();
        parent = (DoubleParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        parent.setChildren(this.getDoubleChildMatchList(parent));
        parent = (DoubleParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        DoubleParent persistedParent = (DoubleParent)this.getDataObjectService().find(DoubleParent.class, (Object)parent.getId());
        Assert.assertTrue((String)"The parent class should not be null.", (persistedParent != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"There should be two child items in the collection.", (long)2L, (long)persistedParent.getChildren().size());
        Assert.assertEquals((String)"First child item value is incorrect", (double)6.28, (double)persistedParent.getChildren().get(0).getDoubleProp(), (double)0.0);
        Assert.assertEquals((String)"Second child item value is incorrect", (double)6.28, (double)persistedParent.getChildren().get(1).getDoubleProp(), (double)0.0);
        this.getDataObjectService().delete((Object)parent);
        this.getDataObjectService().flush(DoubleParent.class);
    }

    @Test
    public void testDoubleCollectionNoMatch() {
        DoubleParent parent = new DoubleParent();
        parent = (DoubleParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        parent.setChildren(this.getDoubleChildNoMatchList(parent));
        parent = (DoubleParent)this.getDataObjectService().save((Object)parent, new PersistenceOption[0]);
        DoubleParent persistedParent = (DoubleParent)this.getDataObjectService().find(DoubleParent.class, (Object)parent.getId());
        Assert.assertNotNull((String)"Parent class should not be null.", (Object)persistedParent);
        Assert.assertTrue((String)"Collection of child items should be empty.", (persistedParent.getChildren().size() < 1 ? 1 : 0) != 0);
        this.getDataObjectService().delete((Object)parent);
        this.getDataObjectService().flush(DoubleParent.class);
    }

    private List<BooleanChild> getBoolChildrenNoMatchList(BooleanParent parent) {
        ArrayList<BooleanChild> theChildren = new ArrayList<BooleanChild>();
        for (int c = 0; c < 4; ++c) {
            theChildren.add(this.createBoolChild(parent.getId(), Boolean.FALSE));
        }
        return theChildren;
    }

    private List<BooleanChild> getBoolChildrenMatchList(BooleanParent parent) {
        ArrayList<BooleanChild> theChildren = new ArrayList<BooleanChild>();
        theChildren.add(this.createBoolChild(parent.getId(), Boolean.FALSE));
        theChildren.add(this.createBoolChild(parent.getId(), Boolean.TRUE));
        theChildren.add(this.createBoolChild(parent.getId(), Boolean.FALSE));
        theChildren.add(this.createBoolChild(parent.getId(), Boolean.TRUE));
        return theChildren;
    }

    private List<IntegerChild> getIntChildMatchList(IntegerParent parent) {
        ArrayList<IntegerChild> theChildren = new ArrayList<IntegerChild>();
        theChildren.add(this.createIntChild(parent.getId(), 1234));
        theChildren.add(this.createIntChild(parent.getId(), 35));
        theChildren.add(this.createIntChild(parent.getId(), -6789));
        theChildren.add(this.createIntChild(parent.getId(), 35));
        return theChildren;
    }

    private List<IntegerChild> getIntChildNoMatchList(IntegerParent parent) {
        ArrayList<IntegerChild> theChildren = new ArrayList<IntegerChild>();
        theChildren.add(this.createIntChild(parent.getId(), 1234));
        theChildren.add(this.createIntChild(parent.getId(), 6789));
        theChildren.add(this.createIntChild(parent.getId(), -1234));
        theChildren.add(this.createIntChild(parent.getId(), -6789));
        return theChildren;
    }

    private List<CharChild> getCharChildMatchList(CharParent parent) {
        ArrayList<CharChild> theChildren = new ArrayList<CharChild>();
        theChildren.add(this.createCharChild(parent.getId(), 'k'));
        theChildren.add(this.createCharChild(parent.getId(), 'b'));
        theChildren.add(this.createCharChild(parent.getId(), 'k'));
        theChildren.add(this.createCharChild(parent.getId(), 'c'));
        return theChildren;
    }

    private List<CharChild> getCharChildNoMatchList(CharParent parent) {
        ArrayList<CharChild> theChildren = new ArrayList<CharChild>();
        theChildren.add(this.createCharChild(parent.getId(), 'a'));
        theChildren.add(this.createCharChild(parent.getId(), 'b'));
        theChildren.add(this.createCharChild(parent.getId(), 'c'));
        theChildren.add(this.createCharChild(parent.getId(), 'd'));
        return theChildren;
    }

    private List<ShortChild> getShortChildMatchList(ShortParent parent) {
        ArrayList<ShortChild> theChildren = new ArrayList<ShortChild>();
        theChildren.add(this.createShortChild(parent.getId(), (short)1024));
        theChildren.add(this.createShortChild(parent.getId(), (short)255));
        theChildren.add(this.createShortChild(parent.getId(), (short)-512));
        theChildren.add(this.createShortChild(parent.getId(), (short)255));
        return theChildren;
    }

    private List<ShortChild> getShortChildNoMatchList(ShortParent parent) {
        ArrayList<ShortChild> theChildren = new ArrayList<ShortChild>();
        theChildren.add(this.createShortChild(parent.getId(), (short)1024));
        theChildren.add(this.createShortChild(parent.getId(), (short)2056));
        theChildren.add(this.createShortChild(parent.getId(), (short)128));
        theChildren.add(this.createShortChild(parent.getId(), (short)-512));
        return theChildren;
    }

    private List<LongChild> getLongChildMatchList(LongParent parent) {
        ArrayList<LongChild> theChildren = new ArrayList<LongChild>();
        theChildren.add(this.createLongChild(parent.getId(), 10L));
        theChildren.add(this.createLongChild(parent.getId(), 20L));
        theChildren.add(this.createLongChild(parent.getId(), 30L));
        theChildren.add(this.createLongChild(parent.getId(), 10L));
        return theChildren;
    }

    private List<LongChild> getLongChildNoMatchList(LongParent parent) {
        ArrayList<LongChild> theChildren = new ArrayList<LongChild>();
        theChildren.add(this.createLongChild(parent.getId(), 20L));
        theChildren.add(this.createLongChild(parent.getId(), 30L));
        theChildren.add(this.createLongChild(parent.getId(), 40L));
        theChildren.add(this.createLongChild(parent.getId(), 50L));
        return theChildren;
    }

    private List<FloatChild> getFloatChildMatchList(FloatParent parent) {
        ArrayList<FloatChild> theChildren = new ArrayList<FloatChild>();
        theChildren.add(this.createFloatChild(parent.getId(), 3.14f));
        theChildren.add(this.createFloatChild(parent.getId(), 6.28f));
        theChildren.add(this.createFloatChild(parent.getId(), 1.732f));
        theChildren.add(this.createFloatChild(parent.getId(), 3.14f));
        return theChildren;
    }

    private List<FloatChild> getFloatChildNoMatchList(FloatParent parent) {
        ArrayList<FloatChild> theChildren = new ArrayList<FloatChild>();
        theChildren.add(this.createFloatChild(parent.getId(), 6.28f));
        theChildren.add(this.createFloatChild(parent.getId(), 1.732f));
        theChildren.add(this.createFloatChild(parent.getId(), 1.618f));
        theChildren.add(this.createFloatChild(parent.getId(), 42.0001f));
        return theChildren;
    }

    private List<DoubleChild> getDoubleChildMatchList(DoubleParent parent) {
        ArrayList<DoubleChild> theChildren = new ArrayList<DoubleChild>();
        theChildren.add(this.createDoubleChild(parent.getId(), 3.14));
        theChildren.add(this.createDoubleChild(parent.getId(), 6.28));
        theChildren.add(this.createDoubleChild(parent.getId(), 1.732));
        theChildren.add(this.createDoubleChild(parent.getId(), 6.28));
        return theChildren;
    }

    private List<DoubleChild> getDoubleChildNoMatchList(DoubleParent parent) {
        ArrayList<DoubleChild> theChildren = new ArrayList<DoubleChild>();
        theChildren.add(this.createDoubleChild(parent.getId(), 1.732));
        theChildren.add(this.createDoubleChild(parent.getId(), 3.14));
        theChildren.add(this.createDoubleChild(parent.getId(), 1.732));
        theChildren.add(this.createDoubleChild(parent.getId(), 42.0001));
        return theChildren;
    }

    private BooleanChild createBoolChild(String parentId, boolean boolVal) {
        BooleanChild child = new BooleanChild();
        child.setBoolProp(boolVal);
        child.setParentKey(parentId);
        return child;
    }

    private IntegerChild createIntChild(String parentId, int intVal) {
        IntegerChild child = new IntegerChild();
        child.setParentKey(parentId);
        child.setIntegerProp(intVal);
        return child;
    }

    private CharChild createCharChild(String parentId, char charVal) {
        CharChild child = new CharChild();
        child.setParentKey(parentId);
        child.setCharProp(charVal);
        return child;
    }

    private ShortChild createShortChild(String parentId, short shortVal) {
        ShortChild child = new ShortChild();
        child.setParentKey(parentId);
        child.setShortProp(shortVal);
        return child;
    }

    private LongChild createLongChild(String parentId, long longVal) {
        LongChild child = new LongChild();
        child.setParentKey(parentId);
        child.setLongProp(longVal);
        return child;
    }

    private FloatChild createFloatChild(String parentId, float floatVal) {
        FloatChild child = new FloatChild();
        child.setParentKey(parentId);
        child.setFloatProp(floatVal);
        return child;
    }

    private DoubleChild createDoubleChild(String parentId, double doubleVal) {
        DoubleChild child = new DoubleChild();
        child.setParentKey(parentId);
        child.setDoubleProp(doubleVal);
        return child;
    }

    private DataObjectService getDataObjectService() {
        return KRADServiceLocator.getDataObjectService();
    }

    @Entity
    @Table(name="KRTST_COLL_CHLD_T")
    private static class DoubleChild {
        @Id
        @Column(name="PK_PROP")
        @GeneratedValue(generator="KRTST_GENERATED_PK_S")
        @PortableSequenceGenerator(name="KRTST_GENERATED_PK_S")
        private String id;
        @Column(name="PRNT_KEY")
        private String parentKey;
        @Column(name="DOUBLE_PROP")
        private double doubleProp;
        @ManyToOne
        @JoinColumn(name="PK_PROP", insertable=false, updatable=false)
        DoubleParent parent;

        private DoubleChild() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getParentKey() {
            return this.parentKey;
        }

        public void setParentKey(String parentKey) {
            this.parentKey = parentKey;
        }

        public double getDoubleProp() {
            return this.doubleProp;
        }

        public void setDoubleProp(double doubleProp) {
            this.doubleProp = doubleProp;
        }

        public DoubleParent getParent() {
            return this.parent;
        }

        public void setParent(DoubleParent parent) {
            this.parent = parent;
        }
    }

    @Entity
    @Table(name="KRTST_COLL_PRNT_T")
    private static class DoubleParent {
        @Id
        @Column(name="PK_PROP")
        @GeneratedValue(generator="KRTST_GENERATED_PK_S")
        @PortableSequenceGenerator(name="KRTST_GENERATED_PK_S")
        private String id;
        @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
        @JoinColumn(name="PRNT_KEY", referencedColumnName="PK_PROP")
        @FilterGenerator(attributeName="doubleProp", attributeValue="6.28")
        private List<DoubleChild> children;

        private DoubleParent() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public List<DoubleChild> getChildren() {
            return this.children;
        }

        public void setChildren(List<DoubleChild> children) {
            this.children = children;
        }
    }

    @Entity
    @Table(name="KRTST_COLL_CHLD_T")
    private static class FloatChild {
        @Id
        @Column(name="PK_PROP")
        @GeneratedValue(generator="KRTST_GENERATED_PK_S")
        @PortableSequenceGenerator(name="KRTST_GENERATED_PK_S")
        private String id;
        @Column(name="PRNT_KEY")
        private String parentKey;
        @Column(name="FLOAT_PROP")
        private float floatProp;
        @ManyToOne
        @JoinColumn(name="PK_PROP", insertable=false, updatable=false)
        FloatParent parent;

        private FloatChild() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getParentKey() {
            return this.parentKey;
        }

        public void setParentKey(String parentKey) {
            this.parentKey = parentKey;
        }

        public float getFloatProp() {
            return this.floatProp;
        }

        public void setFloatProp(float floatProp) {
            this.floatProp = floatProp;
        }

        public FloatParent getParent() {
            return this.parent;
        }

        public void setParent(FloatParent parent) {
            this.parent = parent;
        }
    }

    @Entity
    @Table(name="KRTST_COLL_PRNT_T")
    private static class FloatParent {
        @Id
        @Column(name="PK_PROP")
        @GeneratedValue(generator="KRTST_GENERATED_PK_S")
        @PortableSequenceGenerator(name="KRTST_GENERATED_PK_S")
        private String id;
        @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
        @JoinColumn(name="PRNT_KEY", referencedColumnName="PK_PROP")
        @FilterGenerator(attributeName="floatProp", attributeValue="3.14")
        private List<FloatChild> children;

        private FloatParent() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public List<FloatChild> getChildren() {
            return this.children;
        }

        public void setChildren(List<FloatChild> children) {
            this.children = children;
        }
    }

    @Entity
    @Table(name="KRTST_COLL_CHLD_T")
    private static class ShortChild {
        @Id
        @Column(name="PK_PROP")
        @GeneratedValue(generator="KRTST_GENERATED_PK_S")
        @PortableSequenceGenerator(name="KRTST_GENERATED_PK_S")
        private String id;
        @Column(name="PRNT_KEY")
        private String parentKey;
        @Column(name="SHORT_PROP")
        private short shortProp;
        @ManyToOne
        @JoinColumn(name="PK_PROP", insertable=false, updatable=false)
        ShortParent parent;

        private ShortChild() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getParentKey() {
            return this.parentKey;
        }

        public void setParentKey(String parentKey) {
            this.parentKey = parentKey;
        }

        public long getShortProp() {
            return this.shortProp;
        }

        public void setShortProp(short shortProp) {
            this.shortProp = shortProp;
        }

        public ShortParent getParent() {
            return this.parent;
        }

        public void setParent(ShortParent parent) {
            this.parent = parent;
        }
    }

    @Entity
    @Table(name="KRTST_COLL_PRNT_T")
    private static class ShortParent {
        @Id
        @Column(name="PK_PROP")
        @GeneratedValue(generator="KRTST_GENERATED_PK_S")
        @PortableSequenceGenerator(name="KRTST_GENERATED_PK_S")
        private String id;
        @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
        @JoinColumn(name="PRNT_KEY", referencedColumnName="PK_PROP")
        @FilterGenerator(attributeName="shortProp", attributeValue="255")
        private List<ShortChild> children;

        private ShortParent() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public List<ShortChild> getChildren() {
            return this.children;
        }

        public void setChildren(List<ShortChild> children) {
            this.children = children;
        }
    }

    @Entity
    @Table(name="KRTST_COLL_CHLD_T")
    private static class LongChild {
        @Id
        @Column(name="PK_PROP")
        @GeneratedValue(generator="KRTST_GENERATED_PK_S")
        @PortableSequenceGenerator(name="KRTST_GENERATED_PK_S")
        private String id;
        @Column(name="PRNT_KEY")
        private String parentKey;
        @Column(name="LONG_PROP")
        private long longProp;
        @ManyToOne
        @JoinColumn(name="PK_PROP", insertable=false, updatable=false)
        LongParent parent;

        private LongChild() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getParentKey() {
            return this.parentKey;
        }

        public void setParentKey(String parentKey) {
            this.parentKey = parentKey;
        }

        public long getLongProp() {
            return this.longProp;
        }

        public void setLongProp(long longProp) {
            this.longProp = longProp;
        }

        public LongParent getParent() {
            return this.parent;
        }

        public void setParent(LongParent parent) {
            this.parent = parent;
        }
    }

    @Entity
    @Table(name="KRTST_COLL_PRNT_T")
    private static class LongParent {
        @Id
        @Column(name="PK_PROP")
        @GeneratedValue(generator="KRTST_GENERATED_PK_S")
        @PortableSequenceGenerator(name="KRTST_GENERATED_PK_S")
        private String id;
        @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
        @JoinColumn(name="PRNT_KEY", referencedColumnName="PK_PROP")
        @FilterGenerator(attributeName="longProp", attributeValue="10")
        private List<LongChild> children;

        private LongParent() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public List<LongChild> getChildren() {
            return this.children;
        }

        public void setChildren(List<LongChild> children) {
            this.children = children;
        }
    }

    @Entity
    @Table(name="KRTST_COLL_CHLD_T")
    private static class CharChild {
        @Id
        @Column(name="PK_PROP")
        @GeneratedValue(generator="KRTST_GENERATED_PK_S")
        @PortableSequenceGenerator(name="KRTST_GENERATED_PK_S")
        private String id;
        @Column(name="PRNT_KEY")
        private String parentKey;
        @Column(name="CHAR_PROP")
        private char charProp;
        @ManyToOne
        @JoinColumn(name="PK_PROP", insertable=false, updatable=false)
        CharParent parent;

        private CharChild() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getParentKey() {
            return this.parentKey;
        }

        public void setParentKey(String parentKey) {
            this.parentKey = parentKey;
        }

        public char getCharProp() {
            return this.charProp;
        }

        public void setCharProp(char charProp) {
            this.charProp = charProp;
        }

        public CharParent getParent() {
            return this.parent;
        }

        public void setParent(CharParent parent) {
            this.parent = parent;
        }
    }

    @Entity
    @Table(name="KRTST_COLL_PRNT_T")
    private static class CharParent {
        @Id
        @Column(name="PK_PROP")
        @GeneratedValue(generator="KRTST_GENERATED_PK_S")
        @PortableSequenceGenerator(name="KRTST_GENERATED_PK_S")
        private String id;
        @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
        @JoinColumn(name="PRNT_KEY", referencedColumnName="PK_PROP")
        @FilterGenerator(attributeName="charProp", attributeValue="k")
        private List<CharChild> children;

        private CharParent() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public List<CharChild> getChildren() {
            return this.children;
        }

        public void setChildren(List<CharChild> children) {
            this.children = children;
        }
    }

    @Entity
    @Table(name="KRTST_COLL_CHLD_T")
    private static class IntegerChild {
        @Id
        @Column(name="PK_PROP")
        @GeneratedValue(generator="KRTST_GENERATED_PK_S")
        @PortableSequenceGenerator(name="KRTST_GENERATED_PK_S")
        private String id;
        @Column(name="PRNT_KEY")
        private String parentKey;
        @Column(name="INT_PROP")
        private int integerProp;
        @ManyToOne
        @JoinColumn(name="PK_PROP", insertable=false, updatable=false)
        IntegerParent parent;

        private IntegerChild() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getParentKey() {
            return this.parentKey;
        }

        public void setParentKey(String parentKey) {
            this.parentKey = parentKey;
        }

        public int getIntegerProp() {
            return this.integerProp;
        }

        public void setIntegerProp(int integerProp) {
            this.integerProp = integerProp;
        }

        public IntegerParent getParent() {
            return this.parent;
        }

        public void setParent(IntegerParent parent) {
            this.parent = parent;
        }
    }

    @Entity
    @Table(name="KRTST_COLL_PRNT_T")
    private static class IntegerParent {
        @Id
        @Column(name="PK_PROP")
        @GeneratedValue(generator="KRTST_GENERATED_PK_S")
        @PortableSequenceGenerator(name="KRTST_GENERATED_PK_S")
        private String id;
        @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
        @JoinColumn(name="PRNT_KEY", referencedColumnName="PK_PROP")
        @FilterGenerator(attributeName="integerProp", attributeValue="35")
        private List<IntegerChild> children;

        private IntegerParent() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public List<IntegerChild> getChildren() {
            return this.children;
        }

        public void setChildren(List<IntegerChild> children) {
            this.children = children;
        }
    }

    @Entity
    @Table(name="KRTST_COLL_CHLD_T")
    private static class BooleanChild {
        @Id
        @Column(name="PK_PROP")
        @GeneratedValue(generator="KRTST_GENERATED_PK_S")
        @PortableSequenceGenerator(name="KRTST_GENERATED_PK_S")
        private String id;
        @Column(name="PRNT_KEY")
        private String parentKey;
        @Column(name="BOOL_PROP")
        @Convert(converter=BooleanYNConverter.class)
        private boolean boolProp;
        @ManyToOne
        @JoinColumn(name="PK_PROP", insertable=false, updatable=false)
        BooleanParent parent;

        private BooleanChild() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getParentKey() {
            return this.parentKey;
        }

        public void setParentKey(String parentKey) {
            this.parentKey = parentKey;
        }

        public boolean getBoolProp() {
            return this.boolProp;
        }

        public void setBoolProp(boolean boolProp) {
            this.boolProp = boolProp;
        }

        public BooleanParent getParent() {
            return this.parent;
        }

        public void setParent(BooleanParent parent) {
            this.parent = parent;
        }
    }

    @Entity
    @Table(name="KRTST_COLL_PRNT_T")
    private static class BooleanParent {
        @Id
        @Column(name="PK_PROP")
        @GeneratedValue(generator="KRTST_GENERATED_PK_S")
        @PortableSequenceGenerator(name="KRTST_GENERATED_PK_S")
        private String id;
        @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
        @JoinColumn(name="PRNT_KEY", referencedColumnName="PK_PROP")
        @FilterGenerator(attributeName="boolProp", attributeValue="true")
        private List<BooleanChild> children;

        private BooleanParent() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public List<BooleanChild> getChildren() {
            return this.children;
        }

        public void setChildren(List<BooleanChild> children) {
            this.children = children;
        }
    }
}

