/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.platform;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.test.KRADTestCase;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class MaxValueIncrementerFactoryBeanIntegrationTest
extends KRADTestCase {
    private static final String TEST_INCREMENTER = "testIncrementer";
    private static final String INVALID_TEST_INCREMENTER = "invalidTestIncrementer";
    private ConfigurableApplicationContext context;

    @Override
    public void setUpInternal() throws Exception {
        super.setUpInternal();
        this.context = new ClassPathXmlApplicationContext("MaxValueIncrementerFactoryBeanTest.xml", ((Object)((Object)this)).getClass());
    }

    @Override
    public void tearDown() throws Exception {
        if (this.context != null) {
            this.context.close();
        }
        super.tearDown();
    }

    @Test
    public void testGetIncrementer_nextValues() {
        DataFieldMaxValueIncrementer incrementer = (DataFieldMaxValueIncrementer)this.context.getBean(TEST_INCREMENTER);
        Assert.assertNotNull((Object)incrementer);
        int nextIntValue = incrementer.nextIntValue();
        Assert.assertTrue((String)"nextIntValue should be greater than 0", (nextIntValue > 0 ? 1 : 0) != 0);
        int nextNextIntValue = incrementer.nextIntValue();
        Assert.assertEquals((String)"Next value should be one higher", (long)(nextIntValue + 1), (long)nextNextIntValue);
        long nextLongValue = incrementer.nextLongValue();
        Assert.assertEquals((long)(nextNextIntValue + 1), (long)nextLongValue);
        String nextStringValue = incrementer.nextStringValue();
        Assert.assertEquals((long)(nextLongValue + 1L), (long)Long.parseLong(nextStringValue));
    }

    @Test
    public void testGetIncrementer_CaseInsensitive() {
        DataFieldMaxValueIncrementer incrementer = (DataFieldMaxValueIncrementer)this.context.getBean(TEST_INCREMENTER);
        Assert.assertNotNull((Object)incrementer);
        int nextIntValue = incrementer.nextIntValue();
        Assert.assertTrue((String)"nextIntValue should be greater than 0", (nextIntValue > 0 ? 1 : 0) != 0);
    }

    @Test(expected=DataAccessException.class)
    public void testGetIncrementer_BadSequence() {
        DataFieldMaxValueIncrementer incrementer = (DataFieldMaxValueIncrementer)this.context.getBean(INVALID_TEST_INCREMENTER);
        Assert.assertNotNull((Object)incrementer);
        incrementer.nextLongValue();
    }
}

