/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.document.AccountRequestDocument;
import org.kuali.rice.krad.test.document.AccountRequestDocumentWithCyclicalReference;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class DictionaryValidationServiceTest
extends KRADTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    public void tearDown() throws Exception {
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    @Test
    public void testRecursiveValidation() throws Exception {
        AccountRequestDocument travelDocument = (AccountRequestDocument)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountRequest");
        travelDocument.getDocumentHeader().setDocumentDescription("test document");
        travelDocument.setReason1("reason1");
        travelDocument.setReason2("reason2");
        travelDocument.setRequester("requester");
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        KRADServiceLocatorWeb.getDictionaryValidationService().validateDocumentAndUpdatableReferencesRecursively((Document)travelDocument, 0, true);
        MessageMap errorMap = GlobalVariables.getMessageMap();
        int recursiveZeroMessageMapSize = errorMap.getNumberOfPropertiesWithErrors();
        Assert.assertEquals((String)"Number of errors found is incorrect", (long)2L, (long)recursiveZeroMessageMapSize);
    }

    @Test
    public void testRecursiveValidationMultiple() throws Exception {
        AccountRequestDocument travelDocument = (AccountRequestDocument)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountRequest");
        travelDocument.getDocumentHeader().setDocumentDescription("test document");
        travelDocument.setReason1("reason1");
        travelDocument.setReason2("reason2");
        travelDocument.setRequester("requester");
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        KRADServiceLocatorWeb.getDictionaryValidationService().validateDocumentAndUpdatableReferencesRecursively((Document)travelDocument, 0, true);
        MessageMap errorMap = GlobalVariables.getMessageMap();
        int recursiveZeroMessageMapSize = errorMap.getNumberOfPropertiesWithErrors();
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        KRADServiceLocatorWeb.getDictionaryValidationService().validateDocumentAndUpdatableReferencesRecursively((Document)travelDocument, 5, true);
        MessageMap errorMap2 = GlobalVariables.getMessageMap();
        int recursiveFiveMessageMapSize = errorMap2.getNumberOfPropertiesWithErrors();
        Assert.assertEquals((String)"We should get the same number of errors no matter how deeply we recursively validate for this document", (long)recursiveZeroMessageMapSize, (long)recursiveFiveMessageMapSize);
    }

    @Test
    public void testRecursiveValidationParentChildLoop() throws Exception {
        AccountRequestDocumentWithCyclicalReference doc1 = (AccountRequestDocumentWithCyclicalReference)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountRequest3");
        doc1.getDocumentHeader().setDocumentDescription("test document 1");
        doc1.setReason1("reason1");
        doc1.setReason2("reason2");
        doc1.setRequester("requester");
        AccountRequestDocumentWithCyclicalReference doc2 = (AccountRequestDocumentWithCyclicalReference)KRADServiceLocatorWeb.getDocumentService().getNewDocument("AccountRequest3");
        doc2.getDocumentHeader().setDocumentDescription("test document 2");
        doc2.setReason1("reason1a");
        doc2.setReason2("reason2a");
        doc2.setRequester("requester2");
        doc2.setParent(doc1);
        doc1.setChild(doc2);
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        KRADServiceLocatorWeb.getDictionaryValidationService().validateDocumentAndUpdatableReferencesRecursively((Document)doc1, 5, true);
        MessageMap errorMap = GlobalVariables.getMessageMap();
        int recursiveFiveMessageMapSize = errorMap.getNumberOfPropertiesWithErrors();
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        KRADServiceLocatorWeb.getDictionaryValidationService().validateDocumentAndUpdatableReferencesRecursively((Document)doc1, 10, true);
        MessageMap errorMap2 = GlobalVariables.getMessageMap();
        int recursiveTenMessageMapSize = errorMap2.getNumberOfPropertiesWithErrors();
        Assert.assertEquals((String)"We should get the same number of errors no matter how deeply we recursively validate for this document", (long)recursiveFiveMessageMapSize, (long)recursiveTenMessageMapSize);
    }
}

