/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.bo.TravelAccountUseRate;
import org.kuali.rice.krad.service.InactivateableFromToService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.data.PerTestUnitTestData;
import org.kuali.rice.test.data.UnitTestData;
import org.kuali.rice.test.data.UnitTestFile;
import org.kuali.rice.test.data.UnitTestSql;

@PerTestUnitTestData(value={@UnitTestData(order={UnitTestData.Type.SQL_STATEMENTS, UnitTestData.Type.SQL_FILES}, sqlStatements={@UnitTestSql(value="delete from trv_acct_use_rt_t")}, sqlFiles={@UnitTestFile(filename="classpath:testAccountUseRate.sql", delimiter=";")})}, tearDown={@UnitTestData(sqlStatements={@UnitTestSql(value="delete from trv_acct_use_rt_t")})})
@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class InactivateableFromToServiceTest
extends KRADTestCase {
    protected <T> Collection<T> findCollectionBySearchUnbounded(Class<T> clazz, Map<String, String> formProps) {
        return KRADServiceLocatorWeb.getLookupService().findCollectionBySearchUnbounded(clazz, formProps);
    }

    protected InactivateableFromToService getInactivateableFromToService() {
        return KRADServiceLocator.getInactivateableFromToService();
    }

    @Test
    public void testFindMatchingActive() throws Exception {
        InactivateableFromToService inactivateableFromToService = this.getInactivateableFromToService();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("activeAsOfDate", "04/01/2010");
        fieldValues.put("number", "a2");
        List results = inactivateableFromToService.findMatchingActive(TravelAccountUseRate.class, fieldValues);
        Assert.assertEquals((long)2L, (long)results.size());
        TravelAccountUseRate useRate = (TravelAccountUseRate)results.get(0);
        Assert.assertTrue((String)"Incorrect active records returned, do not match expected ids", ("2".equals(useRate.getId()) || "3".equals(useRate.getId()) ? 1 : 0) != 0);
        useRate = (TravelAccountUseRate)results.get(1);
        Assert.assertTrue((String)"Incorrect active records returned, do not match expected ids", ("2".equals(useRate.getId()) || "3".equals(useRate.getId()) ? 1 : 0) != 0);
        fieldValues = new HashMap();
        fieldValues.put("activeAsOfDate", "04/01/2010");
        fieldValues.put("number", "a1");
        results = inactivateableFromToService.findMatchingActive(TravelAccountUseRate.class, fieldValues);
        Assert.assertEquals((long)1L, (long)results.size());
        useRate = (TravelAccountUseRate)results.get(0);
        Assert.assertTrue((String)"Incorrect active record returned, does not match expected id", (boolean)"1".equals(useRate.getId()));
        fieldValues = new HashMap();
        fieldValues.put("activeAsOfDate", "01/01/2010 01:31 PM");
        fieldValues.put("number", "b1");
        results = inactivateableFromToService.findMatchingActive(TravelAccountUseRate.class, fieldValues);
        Assert.assertEquals((long)1L, (long)results.size());
        useRate = (TravelAccountUseRate)results.get(0);
        Assert.assertTrue((String)"Incorrect active record returned, does not match expected id", (boolean)"9".equals(useRate.getId()));
    }

    @Test
    public void testFindMatchingActive_inactive() throws Exception {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("active", "N");
        fieldValues.put("activeAsOfDate", "04/01/2010");
        fieldValues.put("number", "a2");
        List results = (List)this.findCollectionBySearchUnbounded(TravelAccountUseRate.class, fieldValues);
        Assert.assertEquals((long)1L, (long)results.size());
        TravelAccountUseRate useRate = (TravelAccountUseRate)results.get(0);
        Assert.assertTrue((String)"Incorrect inactive record returned, does not match expected id", (boolean)"4".equals(useRate.getId()));
        fieldValues = new HashMap();
        fieldValues.put("active", "N");
        fieldValues.put("activeAsOfDate", "07/01/2010");
        fieldValues.put("number", "a3");
        results = (List)this.findCollectionBySearchUnbounded(TravelAccountUseRate.class, fieldValues);
        Assert.assertEquals((long)1L, (long)results.size());
        useRate = (TravelAccountUseRate)results.get(0);
        Assert.assertTrue((String)"Incorrect inactive record returned, does not match expected id", (boolean)"5".equals(useRate.getId()));
    }

    @Test
    public void testFindMatchingActive_nullBeginDate() throws Exception {
        InactivateableFromToService inactivateableFromToService = this.getInactivateableFromToService();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("activeAsOfDate", "04/01/2010");
        fieldValues.put("number", "a4");
        List results = inactivateableFromToService.findMatchingActive(TravelAccountUseRate.class, fieldValues);
        Assert.assertEquals((long)1L, (long)results.size());
        TravelAccountUseRate useRate = (TravelAccountUseRate)results.get(0);
        Assert.assertTrue((String)"Incorrect inactive record returned, does not match expected id", (boolean)"6".equals(useRate.getId()));
        fieldValues = new HashMap();
        fieldValues.put("active", "N");
        fieldValues.put("activeAsOfDate", "04/01/2010");
        fieldValues.put("number", "a4");
        results = (List)this.findCollectionBySearchUnbounded(TravelAccountUseRate.class, fieldValues);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void testFindMatchingActive_nullEndDate() throws Exception {
        InactivateableFromToService inactivateableFromToService = this.getInactivateableFromToService();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("activeAsOfDate", "04/01/2030");
        fieldValues.put("number", "a5");
        List results = inactivateableFromToService.findMatchingActive(TravelAccountUseRate.class, fieldValues);
        Assert.assertEquals((long)1L, (long)results.size());
        TravelAccountUseRate useRate = (TravelAccountUseRate)results.get(0);
        Assert.assertTrue((String)"Incorrect active record returned, does not match expected id", (boolean)"7".equals(useRate.getId()));
    }

    @Test
    public void testFindMatchingActive_nullBeginEndDate() throws Exception {
        InactivateableFromToService inactivateableFromToService = this.getInactivateableFromToService();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("activeAsOfDate", "04/01/2010");
        fieldValues.put("number", "a6");
        List results = inactivateableFromToService.findMatchingActive(TravelAccountUseRate.class, fieldValues);
        Assert.assertEquals((long)1L, (long)results.size());
        TravelAccountUseRate useRate = (TravelAccountUseRate)results.get(0);
        Assert.assertTrue((String)"Incorrect active record returned, does not match expected id", (boolean)"8".equals(useRate.getId()));
    }

    @Test
    public void testFilterOutNonActive() throws Exception {
        InactivateableFromToService inactivateableFromToService = this.getInactivateableFromToService();
        ArrayList<TravelAccountUseRate> filterList = new ArrayList<TravelAccountUseRate>();
        filterList.add(this.constructUseRate("1", "a1", "01/01/2010", "01/01/2011"));
        filterList.add(this.constructUseRate("2", "a1", "01/01/2012", "01/01/2013"));
        filterList.add(this.constructUseRate("3", "a2", "01/01/2009", "01/01/2010"));
        filterList.add(this.constructUseRate("4", "a3", "01/01/2010", "05/16/2010"));
        filterList.add(this.constructUseRate("5", "a4", null, "01/01/2011"));
        Date activeAsOfDate = CoreApiServiceLocator.getDateTimeService().convertToSqlDate("06/01/2010");
        List accessibleList = inactivateableFromToService.filterOutNonActive(filterList, (java.util.Date)activeAsOfDate);
        Assert.assertEquals((long)2L, (long)accessibleList.size());
        TravelAccountUseRate useRate = (TravelAccountUseRate)accessibleList.get(0);
        Assert.assertTrue((String)"Incorrect active records returned, do not match expected ids", ("1".equals(useRate.getId()) || "5".equals(useRate.getId()) ? 1 : 0) != 0);
        useRate = (TravelAccountUseRate)accessibleList.get(1);
        Assert.assertTrue((String)"Incorrect active records returned, do not match expected ids", ("1".equals(useRate.getId()) || "5".equals(useRate.getId()) ? 1 : 0) != 0);
    }

    @Test
    public void testFindMatchingCurrent() throws Exception {
        InactivateableFromToService inactivateableFromToService = this.getInactivateableFromToService();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("activeAsOfDate", "06/01/2010");
        fieldValues.put("number", "a2");
        List results = inactivateableFromToService.findMatchingCurrent(TravelAccountUseRate.class, fieldValues);
        Assert.assertEquals((long)1L, (long)results.size());
        TravelAccountUseRate result = (TravelAccountUseRate)results.get(0);
        Assert.assertEquals((String)"Incorrect current record returned, does not match expected id", (Object)"3", (Object)result.getId());
        fieldValues = new HashMap();
        fieldValues.put("activeAsOfDate", "02/01/2010");
        fieldValues.put("number", "a2");
        results = inactivateableFromToService.findMatchingCurrent(TravelAccountUseRate.class, fieldValues);
        Assert.assertEquals((long)1L, (long)results.size());
        result = (TravelAccountUseRate)results.get(0);
        Assert.assertEquals((String)"Incorrect current record returned, does not match expected id", (Object)"2", (Object)result.getId());
    }

    @Test
    public void testFindMatchingNonCurrent() throws Exception {
        InactivateableFromToService inactivateableFromToService = this.getInactivateableFromToService();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("activeAsOfDate", "04/01/2010");
        fieldValues.put("number", "a2");
        List results = inactivateableFromToService.findMatchingActive(TravelAccountUseRate.class, fieldValues);
        Assert.assertEquals((long)2L, (long)results.size());
        TravelAccountUseRate useRate = (TravelAccountUseRate)results.get(0);
        Assert.assertTrue((String)"Incorrect active records returned, do not match expected ids", ("2".equals(useRate.getId()) || "3".equals(useRate.getId()) ? 1 : 0) != 0);
        useRate = (TravelAccountUseRate)results.get(1);
        Assert.assertTrue((String)"Incorrect active records returned, do not match expected ids", ("2".equals(useRate.getId()) || "3".equals(useRate.getId()) ? 1 : 0) != 0);
        List nonCurrent = inactivateableFromToService.filterOutNonCurrent(results, (java.util.Date)CoreApiServiceLocator.getDateTimeService().convertToSqlDate("04/01/2010"));
        fieldValues.put("active", "true");
        fieldValues.put("current", "true");
        Collection<TravelAccountUseRate> nonCurrentLookup = this.findCollectionBySearchUnbounded(TravelAccountUseRate.class, fieldValues);
        Assert.assertEquals((long)nonCurrent.size(), (long)nonCurrentLookup.size());
        ArrayList<TravelAccountUseRate> nonCurrentLookupList = new ArrayList<TravelAccountUseRate>(nonCurrentLookup);
        for (int i = 0; i < nonCurrent.size(); ++i) {
            TravelAccountUseRate expected = (TravelAccountUseRate)nonCurrent.get(i);
            TravelAccountUseRate actual = (TravelAccountUseRate)nonCurrentLookupList.get(i);
            Assert.assertEquals((Object)expected.getId(), (Object)actual.getId());
            Assert.assertEquals((Object)expected.getRate(), (Object)actual.getRate());
            Assert.assertEquals((Object)expected.getActiveFromDate(), (Object)actual.getActiveFromDate());
            Assert.assertEquals((Object)expected.getActiveToDate(), (Object)actual.getActiveToDate());
        }
    }

    @Test
    public void testFilterOutNonCurrent() throws Exception {
        InactivateableFromToService inactivateableFromToService = this.getInactivateableFromToService();
        ArrayList<TravelAccountUseRate> filterList = new ArrayList<TravelAccountUseRate>();
        filterList.add(this.constructUseRate("1", "a1", "01/01/2010", "01/01/2011"));
        filterList.add(this.constructUseRate("2", "a1", "01/16/2010", "01/01/2011"));
        filterList.add(this.constructUseRate("3", "a1", "01/01/2012", "01/01/2013"));
        filterList.add(this.constructUseRate("4", "a2", "01/01/2009", "01/01/2010"));
        filterList.add(this.constructUseRate("5", "a3", "01/01/2010", "05/16/2011"));
        filterList.add(this.constructUseRate("6", "a3", "06/01/2010", "05/16/2011"));
        Date activeAsOfDate = CoreApiServiceLocator.getDateTimeService().convertToSqlDate("06/10/2010");
        List accessibleList = inactivateableFromToService.filterOutNonCurrent(filterList, (java.util.Date)activeAsOfDate);
        Assert.assertEquals((long)2L, (long)accessibleList.size());
        TravelAccountUseRate useRate = (TravelAccountUseRate)accessibleList.get(0);
        Assert.assertTrue((String)"Incorrect curren records returned, do not match expected ids", ("2".equals(useRate.getId()) || "6".equals(useRate.getId()) ? 1 : 0) != 0);
        useRate = (TravelAccountUseRate)accessibleList.get(1);
        Assert.assertTrue((String)"Incorrect curren records returned, do not match expected ids", ("2".equals(useRate.getId()) || "6".equals(useRate.getId()) ? 1 : 0) != 0);
    }

    protected TravelAccountUseRate constructUseRate(String id, String number, String fromDate, String toDate) throws Exception {
        TravelAccountUseRate useRate = new TravelAccountUseRate();
        DateTimeService dateTimeService = CoreApiServiceLocator.getDateTimeService();
        useRate.setId(id);
        useRate.setNumber(number);
        if (fromDate != null) {
            useRate.setActiveFromDate(new Timestamp(dateTimeService.convertToSqlDate(fromDate).getTime()));
        }
        if (toDate != null) {
            useRate.setActiveToDate(new Timestamp(dateTimeService.convertToSqlDate(toDate).getTime()));
        }
        return useRate;
    }
}

