/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.travel.dataobject;

import edu.sampleu.travel.dataobject.TravelAuthorizationDocument;
import edu.sampleu.travel.dataobject.TravelDestination;
import edu.sampleu.travel.dataobject.TravelExpenseItem;
import edu.sampleu.travel.options.ExpenseType;
import edu.sampleu.travel.options.PostalCountryCode;
import edu.sampleu.travel.options.PostalStateCode;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK_CLEAR_DB)
public class TravelExpenseItemTest
extends KRADTestCase {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static String DOCUMENT_NUMBER;
    private static final String DOCUMENT_DESCRIPTION = "Test Travel Authorization Document";
    private static final String CELL_PHONE_NUMBER = "555-555-5555";
    private static String TRAVEL_DESTINATION_ID;
    private static final String TRAVEL_COMPANY_NAME = "Zorba's Travel";
    private static final String DESTINATION_NAME;
    private static final String COUNTRY_CODE;
    private static final String STATE_CODE;
    private static final String EXPENSE_TYPE;
    private static final String EXPENSE_DESCRIPTION;
    private static final String EXPENSE_DATE = "2010-01-01";
    private static final BigDecimal EXPENSE_AMOUNT;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        GlobalVariables.setUserSession((UserSession)new UserSession("admin"));
        TravelDestination newTravelDestination = new TravelDestination();
        newTravelDestination.setTravelDestinationName(DESTINATION_NAME);
        newTravelDestination.setCountryCd(COUNTRY_CODE);
        newTravelDestination.setStateCd(STATE_CODE);
        TRAVEL_DESTINATION_ID = ((TravelDestination)KRADServiceLocator.getDataObjectService().save((Object)newTravelDestination, new PersistenceOption[]{PersistenceOption.FLUSH})).getTravelDestinationId();
        Document newDocument = KRADServiceLocatorWeb.getDocumentService().getNewDocument(TravelAuthorizationDocument.class);
        newDocument.getDocumentHeader().setDocumentDescription(DOCUMENT_DESCRIPTION);
        TravelAuthorizationDocument newTravelAuthorizationDocument = (TravelAuthorizationDocument)newDocument;
        newTravelAuthorizationDocument.setCellPhoneNumber(CELL_PHONE_NUMBER);
        newTravelAuthorizationDocument.setTripDestinationId(TRAVEL_DESTINATION_ID);
        DOCUMENT_NUMBER = KRADServiceLocatorWeb.getDocumentService().saveDocument((Document)newTravelAuthorizationDocument).getDocumentNumber();
    }

    @Override
    public void tearDown() throws Exception {
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    @Test
    public void testTravelExpenseItem() throws Exception {
        Assert.assertTrue((String)(TravelExpenseItem.class.getName() + " is not mapped in JPA"), (boolean)KRADServiceLocator.getDataObjectService().supports(TravelExpenseItem.class));
        String id = this.createTravelExpenseItem();
        TravelExpenseItem travelExpenseItem = (TravelExpenseItem)KRADServiceLocator.getDataObjectService().find(TravelExpenseItem.class, (Object)id);
        Assert.assertNotNull((String)"Travel Expense Item ID is null", (Object)travelExpenseItem.getTravelExpenseItemId());
        Assert.assertEquals((String)"Travel Expense Item document ID is incorrect", (Object)DOCUMENT_NUMBER, (Object)travelExpenseItem.getTravelAuthorizationDocumentId());
        Assert.assertEquals((String)"Travel Expense Item type is incorrect", (Object)EXPENSE_TYPE, (Object)travelExpenseItem.getTravelExpenseTypeCd());
        Assert.assertEquals((String)"Travel Company name is incorrect", (Object)TRAVEL_COMPANY_NAME, (Object)travelExpenseItem.getTravelCompanyName());
        Assert.assertEquals((String)"Travel Expense Item description is incorrect", (Object)EXPENSE_DESCRIPTION, (Object)travelExpenseItem.getExpenseDesc());
        Assert.assertEquals((String)"Travel Expense Item date is incorrect", (Object)DATE_FORMAT.parse(EXPENSE_DATE), (Object)travelExpenseItem.getExpenseDate());
        Assert.assertEquals((String)"Travel Expense Item amount is incorrect", (Object)EXPENSE_AMOUNT, (Object)travelExpenseItem.getExpenseAmount());
        Assert.assertTrue((String)"Travel Expense Item is not reimbursable", (boolean)travelExpenseItem.isReimbursable());
        Assert.assertFalse((String)"Travel Expense Item is taxable", (boolean)travelExpenseItem.isTaxable());
    }

    private String createTravelExpenseItem() throws Exception {
        TravelExpenseItem travelExpenseItem = new TravelExpenseItem();
        travelExpenseItem.setTravelAuthorizationDocumentId(DOCUMENT_NUMBER);
        travelExpenseItem.setTravelExpenseTypeCd(EXPENSE_TYPE);
        travelExpenseItem.setExpenseDesc(EXPENSE_DESCRIPTION);
        travelExpenseItem.setTravelCompanyName(TRAVEL_COMPANY_NAME);
        travelExpenseItem.setExpenseDate(DATE_FORMAT.parse(EXPENSE_DATE));
        travelExpenseItem.setExpenseAmount(EXPENSE_AMOUNT);
        travelExpenseItem.setReimbursable(true);
        travelExpenseItem.setTaxable(false);
        return ((TravelExpenseItem)KRADServiceLocator.getDataObjectService().save((Object)travelExpenseItem, new PersistenceOption[]{PersistenceOption.FLUSH})).getTravelExpenseItemId();
    }

    static {
        DESTINATION_NAME = PostalStateCode.CA.getLabel();
        COUNTRY_CODE = PostalCountryCode.US.getCode();
        STATE_CODE = PostalStateCode.CA.getCode();
        EXPENSE_TYPE = ExpenseType.A.getCode();
        EXPENSE_DESCRIPTION = ExpenseType.A.getLabel();
        EXPENSE_AMOUNT = new BigDecimal("1236.49");
    }
}

