/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.data.jpa.DisableVersioning;
import org.kuali.rice.krad.data.jpa.RemoveMapping;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class DisableVersioningTest
extends KRADTestCase {
    private DisableVersion createDisableVersion(String rndId, String propertyVal) {
        return new DisableVersion(rndId, propertyVal, new Long(0L));
    }

    private DisableNoVersion createDisableNoVersion(String rndId, String propertyVal) {
        return new DisableNoVersion(rndId, propertyVal);
    }

    private DisableNoVersionRemoveMapping createDisableNoVersionRemoveMapping(String rndId, String propertyVal) {
        return new DisableNoVersionRemoveMapping(rndId, propertyVal);
    }

    private String getRandomId() {
        String time = String.valueOf(System.currentTimeMillis());
        return time.substring(time.length() - 9);
    }

    @Test
    public void testDisableVersioning() {
        String rndId = this.getRandomId();
        String property = "testPropertyValue";
        KRADServiceLocator.getDataObjectService().save((Object)this.createDisableVersion(rndId, property), new PersistenceOption[0]);
        DisableVersion resultDV = (DisableVersion)((Object)KRADServiceLocator.getDataObjectService().find(DisableVersion.class, (Object)rndId));
        Assert.assertNotNull((String)"DisableVersion is null", (Object)((Object)resultDV));
        Assert.assertEquals((String)"DisableVersion id does not match given value", (Object)rndId, (Object)resultDV.getId());
        Assert.assertEquals((String)"DisableVersion property does not match given value", (Object)property, (Object)resultDV.getProperty());
        Assert.assertEquals((Object)new Long(0L), (Object)resultDV.getVersionNumber());
        resultDV.setVersionNumber(new Long(50L));
        resultDV = (DisableVersion)((Object)KRADServiceLocator.getDataObjectService().save((Object)resultDV, new PersistenceOption[0]));
        Assert.assertEquals((Object)new Long(50L), (Object)resultDV.getVersionNumber());
        try {
            KRADServiceLocator.getDataObjectService().save((Object)this.createDisableNoVersion(rndId, property), new PersistenceOption[0]);
            Assert.fail((String)"Database exception should have been thrown when saving with no version number column");
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        KRADServiceLocator.getDataObjectService().save((Object)this.createDisableNoVersionRemoveMapping(rndId, property), new PersistenceOption[0]);
        DisableNoVersionRemoveMapping resultDNV = (DisableNoVersionRemoveMapping)((Object)KRADServiceLocator.getDataObjectService().find(DisableNoVersionRemoveMapping.class, (Object)rndId));
        Assert.assertNotNull((String)"DisableNoVersionRemoveMapping is null", (Object)((Object)resultDNV));
        Assert.assertEquals((String)"DisableNoVersionRemoveMapping id does not match given value", (Object)rndId, (Object)resultDNV.getId());
        Assert.assertEquals((String)"DisableNoVersionRemoveMapping property does not match given value", (Object)property, (Object)resultDNV.getProperty());
    }

    @Entity
    @Table(name="KRTST_TEST_DISABLE_NO_VER_T")
    @DisableVersioning
    @RemoveMapping(name="versionNumber")
    public static class DisableNoVersionRemoveMapping
    extends PersistableBusinessObjectBase {
        @Id
        @Column(name="ID")
        private String id;
        @Column(name="STR_PROP")
        private String property;

        public DisableNoVersionRemoveMapping() {
        }

        public DisableNoVersionRemoveMapping(String id, String property) {
            this.id = id;
            this.property = property;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }
    }

    @Entity
    @Table(name="KRTST_TEST_DISABLE_NO_VER_T")
    @DisableVersioning
    public static class DisableNoVersion
    extends PersistableBusinessObjectBase {
        @Id
        @Column(name="ID")
        private String id;
        @Column(name="STR_PROP")
        private String property;

        public DisableNoVersion() {
        }

        public DisableNoVersion(String id, String property) {
            this.id = id;
            this.property = property;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }
    }

    @Entity
    @Table(name="KRTST_TEST_DISABLE_VER_T")
    @DisableVersioning
    public static class DisableVersion
    extends PersistableBusinessObjectBase {
        @Id
        @Column(name="ID")
        private String id;
        @Column(name="STR_PROP")
        private String property;

        public DisableVersion() {
        }

        public DisableVersion(String id, String property, Long versionNumber) {
            this.id = id;
            this.property = property;
            this.setVersionNumber(versionNumber);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }
    }
}

