/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.OrderByField;
import org.kuali.rice.core.api.criteria.OrderDirection;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.krad.bo.PersistableBusinessObjectExtension;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.DataObjectWrapper;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.kuali.rice.krad.data.provider.PersistenceProvider;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.document.bo.Account;
import org.kuali.rice.krad.test.document.bo.AccountExtension;
import org.kuali.rice.krad.test.document.bo.AccountType;
import org.kuali.rice.krad.test.document.bo.SimpleAccount;
import org.kuali.rice.krad.test.document.bo.SimpleAccountExtension;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.TestHarnessServiceLocator;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.transaction.UnexpectedRollbackException;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class JpaPersistenceProviderTest
extends KRADTestCase {
    protected PersistenceProvider provider;

    @Before
    public void setup() {
        this.provider = this.getPersistenceProvider();
    }

    protected QueryByCriteria queryFor(Object a) {
        return QueryByCriteria.Builder.andAttributes((Object)a, Arrays.asList(this.getPropertiesForQuery())).build();
    }

    protected Object createLinkedTestObject() {
        Object a = this.createTopLevelObject();
        Object saved = this.getPersistenceProvider().save(a, new PersistenceOption[0]);
        this.addLinkedReferences(saved);
        return saved;
    }

    protected Object createUnlinkedTestObject() {
        Object a = this.createTopLevelObject();
        Object saved = this.getPersistenceProvider().save(a, new PersistenceOption[0]);
        this.addUnlinkedReferences(saved);
        return saved;
    }

    protected void assignPK(Object a) {
        this.setTestObjectPK(a, this.getNextTestObjectId());
    }

    protected Map.Entry<Object, QueryByCriteria> createForQuery() {
        Object a = this.createLinkedTestObject();
        QueryByCriteria qbc = this.queryFor(a);
        return new AbstractMap.SimpleImmutableEntry<Object, QueryByCriteria>(a, qbc);
    }

    protected Map.Entry<List<Object>, QueryByCriteria.Builder> createForQuery(int count) {
        ArrayList<Object> objects = new ArrayList<Object>();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(count);
        for (int i = 0; i < count; ++i) {
            Object a = this.createLinkedTestObject();
            objects.add(a);
            predicates.add(this.queryFor(a).getPredicate());
        }
        QueryByCriteria.Builder qbc = QueryByCriteria.Builder.create();
        qbc.setPredicates(new Predicate[]{PredicateFactory.or((Predicate[])predicates.toArray(new Predicate[count]))});
        return new AbstractMap.SimpleImmutableEntry<List<Object>, QueryByCriteria.Builder>(objects, qbc);
    }

    @Test
    public void testSimpleSave() {
        Object a = this.createTopLevelObject();
        Assert.assertNull((Object)this.getIdForLookup(a));
        Object saved = this.provider.save(a, new PersistenceOption[0]);
        Assert.assertNotNull((Object)this.getIdForLookup(saved));
        this.assertTestObjectEquals(a, saved);
    }

    @Test
    public void testSaveLinkedSkipLinking() {
        Object a = this.createLinkedTestObject();
        Object id = this.getIdForLookup(a);
        Object saved = this.provider.save(a, new PersistenceOption[0]);
        this.assertTestObjectIdentityEquals(a, saved);
        Object found = this.provider.find(a.getClass(), id);
        this.assertTestObjectIdentityEquals(a, found);
        this.assertTestObjectIdentityEquals(saved, found);
    }

    @Test
    public void testExtensionKeySaving() {
        Account acct = new Account();
        acct.setNumber("a1");
        acct.setName("a1 name");
        AccountExtension ext = new AccountExtension();
        ext.setAccountTypeCode("EAX");
        acct.setExtension((PersistableBusinessObjectExtension)ext);
        acct = (Account)((Object)KradDataServiceLocator.getDataObjectService().save((Object)acct, new PersistenceOption[]{PersistenceOption.FLUSH}));
        Assert.assertNotNull((String)"extension object was null after save", (Object)acct.getExtension());
        Assert.assertEquals((String)"extension object class incorrect", AccountExtension.class, acct.getExtension().getClass());
        ext = (AccountExtension)acct.getExtension();
        Assert.assertEquals((String)"account type code incorrect after save", (Object)"EAX", (Object)ext.getAccountTypeCode());
        Assert.assertNotNull((String)"account object on extension not persisted", (Object)((Object)ext.getAccount()));
        Assert.assertEquals((String)"account ID on extension not persisted", (Object)"a1", (Object)ext.getNumber());
        this.provider.find(Account.class, (Object)"a1");
        Assert.assertNotNull((String)"extension object was null after reload", (Object)acct.getExtension());
        Assert.assertEquals((String)"extension object class incorrect after reload", AccountExtension.class, acct.getExtension().getClass());
        ext = (AccountExtension)acct.getExtension();
        Assert.assertEquals((String)"account type code incorrect after reload", (Object)"EAX", (Object)ext.getAccountTypeCode());
    }

    @Test
    public void testExistsSubQueryCriteria() {
        Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Adding Account");
        Account acct = new Account();
        acct.setNumber("a1");
        acct.setName("a1 name");
        this.provider.save((Object)acct, new PersistenceOption[]{PersistenceOption.FLUSH});
        Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Testing Account Saved");
        acct = (Account)((Object)this.provider.find(Account.class, (Object)"a1"));
        Assert.assertNotNull((String)"a1 SimpleAccount missing", (Object)((Object)acct));
        Predicate subquery = PredicateFactory.existsSubquery((String)AccountExtension.class.getName(), (Predicate)PredicateFactory.equalsProperty((String)"number", null, (String)"parent.number"));
        QueryByCriteria q = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{subquery});
        Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)("Performing Lookup with Exists Query: " + q));
        QueryResults results = this.provider.findMatching(Account.class, q);
        Assert.assertNotNull((String)"Results should not have been null", (Object)results);
        Assert.assertEquals((String)"Should have been no results in the default data", (long)0L, (long)results.getResults().size());
        Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Building extension object for retest");
        AccountExtension ext = new AccountExtension();
        ext.setAccount(acct);
        ext.setAccountTypeCode("EAX");
        this.provider.save((Object)ext, new PersistenceOption[]{PersistenceOption.FLUSH});
        Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Running query again to test results");
        results = this.provider.findMatching(Account.class, q);
        Assert.assertNotNull((String)"Results should not have been null", (Object)results);
        Assert.assertEquals((String)"We added an extension record, so there should have been one result", (long)1L, (long)results.getResults().size());
    }

    @Test
    public void testNotExistsSubQueryCriteria() {
        Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Adding Account1");
        Account acct = new Account();
        acct.setNumber("a1");
        acct.setName("a1 name");
        this.provider.save((Object)acct, new PersistenceOption[]{PersistenceOption.FLUSH});
        Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Adding Account2");
        Account acct2 = new Account();
        acct.setNumber("a2");
        acct.setName("a2 name");
        this.provider.save((Object)acct, new PersistenceOption[]{PersistenceOption.FLUSH});
        acct = null;
        Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Testing Account1 Saved");
        acct = (Account)((Object)this.provider.find(Account.class, (Object)"a1"));
        Assert.assertNotNull((String)"a1 SimpleAccount missing", (Object)((Object)acct));
        acct2 = null;
        Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Testing Account2 Saved");
        acct2 = (Account)((Object)this.provider.find(Account.class, (Object)"a2"));
        Assert.assertNotNull((String)"a2 SimpleAccount missing", (Object)((Object)acct2));
        Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Building extension object for retest");
        AccountExtension ext = new AccountExtension();
        ext.setAccount(acct);
        ext.setAccountTypeCode("EAX");
        this.provider.save((Object)ext, new PersistenceOption[]{PersistenceOption.FLUSH});
        Predicate subquery = PredicateFactory.notExistsSubquery((String)AccountExtension.class.getName(), (Predicate)PredicateFactory.equalsProperty((String)"number", null, (String)"parent.number"));
        QueryByCriteria q = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{subquery});
        Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)("Performing Lookup with Exists Query: " + q));
        QueryResults results = this.provider.findMatching(Account.class, q);
        Assert.assertNotNull((String)"Results should not have been null", (Object)results);
        Assert.assertEquals((String)"Should have been one result in the default data", (long)1L, (long)results.getResults().size());
        Assert.assertEquals((String)" A2 should be returned for not exists", (Object)((Account)((Object)results.getResults().get(0))).getNumber(), (Object)"a2");
        Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Building extension object for retest");
        AccountExtension ext2 = new AccountExtension();
        ext2.setAccount(acct2);
        ext2.setAccountTypeCode("EAX2");
        this.provider.save((Object)ext2, new PersistenceOption[]{PersistenceOption.FLUSH});
        Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Running query again to test results");
        results = this.provider.findMatching(Account.class, q);
        Assert.assertNotNull((String)"Results should not have been null", (Object)results);
        Assert.assertEquals((String)"We added an extension record, so there should have been no result", (long)0L, (long)results.getResults().size());
    }

    @Test(expected=UnexpectedRollbackException.class)
    public void testSaveUnlinkedSkipLinking() {
        Object a = this.createUnlinkedTestObject();
        this.provider.save(a, new PersistenceOption[0]);
        Assert.fail((String)"save should have resulted in an exception as references have not been linked correctly");
    }

    @Test
    public void testFindMatching() {
        Map.Entry<Object, QueryByCriteria> pair = this.createForQuery();
        Object a = pair.getKey();
        QueryByCriteria qbc = pair.getValue();
        Object saved = this.provider.save(a, new PersistenceOption[0]);
        this.assertTestObjectEquals(a, saved);
        QueryResults found = this.provider.findMatching(a.getClass(), qbc);
        Assert.assertEquals((long)1L, (long)found.getResults().size());
        this.assertTestObjectIdentityEquals(a, found.getResults().get(0));
        this.provider.delete(found.getResults().get(0));
        found = this.provider.findMatching(a.getClass(), qbc);
        Assert.assertEquals((long)0L, (long)found.getResults().size());
    }

    @Test(expected=InvalidDataAccessApiUsageException.class)
    public void testFindMatchingNullCriteria() {
        Map.Entry<Object, QueryByCriteria> pair = this.createForQuery();
        Object a = pair.getKey();
        this.provider.findMatching(a.getClass(), null);
    }

    @Test
    public void testFindMatchingEmptyCriteria() {
        Map.Entry<Object, QueryByCriteria> pair = this.createForQuery();
        Object a = pair.getKey();
        this.provider.findMatching(a.getClass(), QueryByCriteria.Builder.create().build());
    }

    @Test
    public void testFindBySingleKey() {
        Object a = this.createLinkedTestObject();
        Object saved = this.provider.save(a, new PersistenceOption[0]);
        this.assertTestObjectEquals(a, saved);
        Object id = this.getIdForLookup(saved);
        Object found = this.provider.find(a.getClass(), id);
        this.assertTestObjectIdentityEquals(a, found);
        this.provider.delete(found);
        Assert.assertNull((Object)this.provider.find(a.getClass(), id));
    }

    @Test
    public void testFindByCompoundKey() {
        Object a = this.createLinkedTestObject();
        Object saved = this.provider.save(a, new PersistenceOption[0]);
        this.assertTestObjectEquals(a, saved);
        TreeMap<String, Object> keys = new TreeMap<String, Object>();
        DataObjectWrapper wrap = KradDataServiceLocator.getDataObjectService().wrap(saved);
        for (String propertyName : this.getPropertiesForQuery()) {
            keys.put(propertyName, wrap.getPropertyValue(propertyName));
        }
        CompoundKey id = new CompoundKey(keys);
        Object found = this.provider.find(a.getClass(), (Object)id);
        this.assertTestObjectIdentityEquals(a, found);
        this.provider.delete(found);
        Assert.assertNull((Object)this.provider.find(a.getClass(), (Object)id));
    }

    @Test
    public void testFindMatchingOrderBy() {
        Map.Entry<List<Object>, QueryByCriteria.Builder> fixture = this.createForQuery(10);
        List<Object> objects = fixture.getKey();
        for (Object a : objects) {
            this.provider.save(a, new PersistenceOption[0]);
        }
        QueryByCriteria.Builder query = fixture.getValue();
        OrderByField.Builder nameOrderBy = OrderByField.Builder.create();
        OrderByField.Builder amIdOrderBy = OrderByField.Builder.create();
        nameOrderBy.setFieldName("number");
        nameOrderBy.setOrderDirection(OrderDirection.ASCENDING);
        amIdOrderBy.setFieldName("amId");
        amIdOrderBy.setOrderDirection(OrderDirection.ASCENDING);
        query.setOrderByFields(new OrderByField[]{nameOrderBy.build(), amIdOrderBy.build()});
        List ascOrder = this.provider.findMatching(SimpleAccount.class, query.build()).getResults();
        nameOrderBy.setOrderDirection(OrderDirection.DESCENDING);
        amIdOrderBy.setOrderDirection(OrderDirection.DESCENDING);
        query.setOrderByFields(new OrderByField[]{nameOrderBy.build(), amIdOrderBy.build()});
        List descOrder = this.provider.findMatching(SimpleAccount.class, query.build()).getResults();
        Assert.assertEquals((long)ascOrder.size(), (long)descOrder.size());
        if (!CollectionUtils.isEmpty((Collection)ascOrder)) {
            for (int idx = 0; idx < ascOrder.size(); ++idx) {
                this.assertTestObjectIdentityEquals(ascOrder.get(idx), descOrder.get(ascOrder.size() - 1 - idx));
            }
        }
    }

    @Test
    public void testFindWithResultsWindow() {
        List acctList = this.provider.findMatching(SimpleAccount.class, QueryByCriteria.Builder.create().build()).getResults();
        if (CollectionUtils.isEmpty((Collection)acctList)) {
            for (SimpleAccount acct : acctList) {
                this.provider.delete((Object)acct);
            }
        }
        Map.Entry<List<Object>, QueryByCriteria.Builder> fixture = this.createForQuery(10);
        List<Object> objects = fixture.getKey();
        for (Object a : objects) {
            this.provider.save(a, new PersistenceOption[0]);
        }
        QueryByCriteria.Builder query = fixture.getValue();
        OrderByField.Builder orderBy = OrderByField.Builder.create();
        orderBy.setFieldName("number");
        orderBy.setOrderDirection(OrderDirection.ASCENDING);
        query.setOrderByFields(new OrderByField[]{orderBy.build()});
        List resultsAll = this.provider.findMatching(SimpleAccount.class, query.build()).getResults();
        query.setStartAtIndex(Integer.valueOf(2));
        query.setMaxResults(Integer.valueOf(5));
        List results = this.provider.findMatching(SimpleAccount.class, query.build()).getResults();
        Assert.assertEquals((long)5L, (long)results.size());
        this.assertTestObjectIdentityEquals(resultsAll.get(2), results.get(0));
        this.assertTestObjectIdentityEquals(resultsAll.get(3), results.get(1));
        this.assertTestObjectIdentityEquals(resultsAll.get(4), results.get(2));
        this.assertTestObjectIdentityEquals(resultsAll.get(5), results.get(3));
        this.assertTestObjectIdentityEquals(resultsAll.get(6), results.get(4));
    }

    @Test
    public void testFindAll() {
        Object a = this.createTopLevelObject();
        QueryResults results = this.provider.findAll(a.getClass());
        Assert.assertEquals((long)0L, (long)results.getResults().size());
        Object savedA = this.provider.save(a, new PersistenceOption[0]);
        results = this.provider.findAll(a.getClass());
        Assert.assertEquals((long)1L, (long)results.getResults().size());
        this.provider.delete(savedA);
        results = this.provider.findAll(a.getClass());
        Assert.assertEquals((long)0L, (long)results.getResults().size());
    }

    @Test
    public void testDeleteNonExistentEntity() {
        Object a = this.createTopLevelObject();
        this.assignPK(a);
        Object id = this.getIdForLookup(a);
        Assert.assertNull((Object)this.provider.find(a.getClass(), id));
        this.provider.delete(a);
        Assert.assertNull((Object)this.provider.find(a.getClass(), id));
    }

    @Test(expected=InvalidDataAccessApiUsageException.class)
    public void testDeleteMatchingNullCriteria() {
        this.provider.deleteMatching(SimpleAccount.class, null);
    }

    @Test(expected=InvalidDataAccessApiUsageException.class)
    public void testDeleteMatchingEmptyCriteria() {
        this.provider.deleteMatching(SimpleAccount.class, QueryByCriteria.Builder.create().build());
    }

    @Test
    public void testDeleteMatchingNonExistentEntity() {
        ArrayList<String> nameList = new ArrayList<String>();
        Object a = this.createTopLevelObject();
        this.assignPK(a);
        nameList.add(((SimpleAccount)((Object)a)).getName());
        Object b = this.createTopLevelObject();
        this.assignPK(b);
        nameList.add(((SimpleAccount)((Object)b)).getName());
        Object c = this.createTopLevelObject();
        this.assignPK(c);
        nameList.add(((SimpleAccount)((Object)c)).getName());
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.in((String)"name", nameList)});
        QueryResults found = this.provider.findMatching(a.getClass(), builder.build());
        Assert.assertEquals((long)0L, (long)found.getResults().size());
        this.provider.deleteMatching(a.getClass(), builder.build());
        found = this.provider.findMatching(a.getClass(), builder.build());
        Assert.assertEquals((long)0L, (long)found.getResults().size());
    }

    @Test
    public void testDeleteMatchingAllSavedEntities() {
        ArrayList<String> nameList = new ArrayList<String>();
        Object a = this.createTopLevelObject();
        this.assignPK(a);
        Object savedA = this.provider.save(a, new PersistenceOption[0]);
        nameList.add(((SimpleAccount)((Object)savedA)).getName());
        Object b = this.createTopLevelObject();
        this.assignPK(b);
        Object savedB = this.provider.save(b, new PersistenceOption[0]);
        nameList.add(((SimpleAccount)((Object)savedB)).getName());
        Object c = this.createTopLevelObject();
        this.assignPK(c);
        Object savedC = this.provider.save(c, new PersistenceOption[0]);
        QueryResults found = this.provider.findAll(savedA.getClass());
        Assert.assertEquals((long)3L, (long)found.getResults().size());
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.in((String)"name", nameList)});
        this.provider.deleteMatching(a.getClass(), builder.build());
        found = this.provider.findAll(savedA.getClass());
        Assert.assertEquals((long)1L, (long)found.getResults().size());
        Object lastObject = found.getResults().get(0);
        Assert.assertEquals((Object)((SimpleAccount)((Object)lastObject)).getName(), (Object)((SimpleAccount)((Object)savedC)).getName());
        nameList.clear();
        nameList.add(((SimpleAccount)((Object)savedC)).getName());
        builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.in((String)"name", nameList)});
        this.provider.deleteMatching(a.getClass(), builder.build());
        found = this.provider.findAll(savedA.getClass());
        Assert.assertEquals((long)0L, (long)found.getResults().size());
    }

    @Test
    public void testDeleteAll() {
        Object a = this.createTopLevelObject();
        QueryResults results = this.provider.findAll(a.getClass());
        Assert.assertEquals((long)0L, (long)results.getResults().size());
        this.provider.deleteAll(a.getClass());
        results = this.provider.findAll(a.getClass());
        Assert.assertEquals((long)0L, (long)results.getResults().size());
        Object savedA = this.provider.save(a, new PersistenceOption[0]);
        Object b = this.createTopLevelObject();
        this.provider.save(b, new PersistenceOption[0]);
        results = this.provider.findAll(a.getClass());
        Assert.assertEquals((long)2L, (long)results.getResults().size());
        this.provider.deleteAll(savedA.getClass());
        results = this.provider.findAll(a.getClass());
        Assert.assertEquals((long)0L, (long)results.getResults().size());
    }

    @Test
    public void testHandles() {
        Object a = this.createTopLevelObject();
        Assert.assertTrue((boolean)this.provider.handles(a.getClass()));
        Class<?> guaranteedNotToBeMappedClass = ((Object)((Object)this)).getClass();
    }

    protected Object createTopLevelObject() {
        SimpleAccount a = new SimpleAccount();
        String name = RandomStringUtils.randomAlphanumeric((int)10);
        a.setName(name);
        return a;
    }

    protected void addLinkedReferences(Object o) {
        SimpleAccount a = (SimpleAccount)((Object)o);
        this.addUnlinkedReferences((Object)a);
        SimpleAccountExtension e = (SimpleAccountExtension)((Object)a.getExtension());
        e.setAccountTypeCode(e.getAccountType().getAccountTypeCode());
        e.setAccount(a);
    }

    protected void addUnlinkedReferences(Object o) {
        SimpleAccount a = (SimpleAccount)((Object)o);
        SimpleAccountExtension extension = new SimpleAccountExtension();
        AccountType at = new AccountType();
        at.setName(RandomStringUtils.randomAlphanumeric((int)10));
        at.setAccountTypeCode(RandomStringUtils.randomAlphanumeric((int)2));
        extension.setAccountType(at);
        a.setExtension((Object)extension);
    }

    protected String[] getPropertiesForQuery() {
        return new String[]{"number", "name"};
    }

    protected Object getIdForLookup(Object o) {
        SimpleAccount a = (SimpleAccount)((Object)o);
        return a.getNumber();
    }

    protected String getNextTestObjectId() {
        DataSource dataSource = TestHarnessServiceLocator.getDataSource();
        return MaxValueIncrementerFactory.getIncrementer((DataSource)dataSource, (String)"trvl_id_seq").nextStringValue();
    }

    protected void setTestObjectPK(Object o, Object key) {
        SimpleAccount a = (SimpleAccount)((Object)o);
        a.setNumber((String)key);
    }

    protected void assertTestObjectIdentityEquals(Object oExpected, Object oActual) {
        SimpleAccount expected = (SimpleAccount)((Object)oExpected);
        SimpleAccount actual = (SimpleAccount)((Object)oActual);
        this.assertTestObjectEquals((Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected.getNumber(), (Object)actual.getNumber());
    }

    protected void assertTestObjectEquals(Object oExpected, Object oActual) {
        SimpleAccount expected = (SimpleAccount)((Object)oExpected);
        SimpleAccount actual = (SimpleAccount)((Object)oActual);
        Assert.assertEquals((Object)expected.getAmId(), (Object)actual.getAmId());
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        if (expected.getExtension() != null) {
            SimpleAccountExtension e1 = (SimpleAccountExtension)((Object)expected.getExtension());
            SimpleAccountExtension e2 = (SimpleAccountExtension)((Object)actual.getExtension());
            Assert.assertEquals((Object)e1.getAccount().getNumber(), (Object)e2.getAccount().getNumber());
            Assert.assertEquals((Object)e1.getAccountTypeCode(), (Object)e2.getAccountTypeCode());
            if (e1.getAccountType() != null) {
                AccountType at1 = e1.getAccountType();
                AccountType at2 = e2.getAccountType();
                Assert.assertEquals((Object)at1.getName(), (Object)at2.getName());
                Assert.assertEquals((Object)at1.getAccountTypeCode(), (Object)at2.getAccountTypeCode());
            }
        }
    }

    protected PersistenceProvider getPersistenceProvider() {
        return (PersistenceProvider)this.getKRADTestHarnessContext().getBean("kradTestJpaPersistenceProvider", PersistenceProvider.class);
    }
}

