/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.provider.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.data.util.ReferenceLinker;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.conference.ConferenceSession;
import org.kuali.rice.krad.test.conference.PresenterInfo;
import org.kuali.rice.krad.test.conference.Room;
import org.kuali.rice.krad.test.conference.SessionCoordinator;
import org.kuali.rice.krad.test.conference.SessionPresenter;

public class ReferenceLinkerIntegrationTest
extends KRADTestCase {
    private DataObjectService dataObjectService;
    private ReferenceLinker referenceLinker;

    @Override
    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.dataObjectService = KradDataServiceLocator.getDataObjectService();
        this.referenceLinker = new ReferenceLinker();
        this.referenceLinker.setDataObjectService(this.dataObjectService);
    }

    @Test
    public void testIdentityLinking() {
        SessionCoordinator savedCoordinator = new SessionCoordinator();
        savedCoordinator.setName("Me");
        savedCoordinator = (SessionCoordinator)this.getDataObjectService().save((Object)savedCoordinator, new PersistenceOption[0]);
        Assert.assertNotNull((Object)savedCoordinator.getId());
        ConferenceSession session = new ConferenceSession();
        SessionCoordinator coordinator = new SessionCoordinator();
        session.setAltCoordinator1(coordinator);
        coordinator.setId(savedCoordinator.getId());
        HashSet<String> changes = new HashSet<String>();
        changes.add("altCoordinator1.id");
        this.referenceLinker.linkChanges((Object)session, changes);
        SessionCoordinator fetchedCoordinator = session.getAltCoordinator1();
        Assert.assertNotNull((Object)fetchedCoordinator);
        Assert.assertEquals((Object)savedCoordinator.getId(), (Object)fetchedCoordinator.getId());
        Assert.assertEquals((Object)"Me", (Object)fetchedCoordinator.getName());
        Assert.assertEquals((Object)savedCoordinator.getId(), (Object)session.getAltCoordinator1Id());
        Assert.assertEquals((long)1L, (long)fetchedCoordinator.getAltCoordinatedSessions1().size());
        Assert.assertEquals((Object)session, (Object)fetchedCoordinator.getAltCoordinatedSessions1().get(0));
    }

    @Test
    public void testIdentityLinking_InvalidKey() {
        ConferenceSession session = new ConferenceSession();
        session.setAltCoordinator1Id(Long.MAX_VALUE);
        HashSet<String> changes = new HashSet<String>();
        changes.add("altCoordinator1Id");
        this.referenceLinker.linkChanges((Object)session, changes);
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)session.getAltCoordinator1Id());
        Assert.assertNull((Object)session.getAltCoordinator1());
        SessionCoordinator sc = new SessionCoordinator();
        sc.setName("admin");
        sc.setId(12345L);
        session.setAltCoordinator1(sc);
        this.referenceLinker.linkChanges((Object)session, changes);
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)session.getAltCoordinator1Id());
        Assert.assertNull((Object)session.getAltCoordinator1());
    }

    @Test
    public void testAttributeLinking() {
        SessionCoordinator sc = new SessionCoordinator();
        sc.setName("admin");
        sc = (SessionCoordinator)this.getDataObjectService().save((Object)sc, new PersistenceOption[0]);
        Assert.assertNotNull((Object)sc.getId());
        ConferenceSession session = new ConferenceSession();
        session.setAltCoordinator1Id(sc.getId());
        HashSet<String> changes = new HashSet<String>();
        changes.add("altCoordinator1Id");
        this.referenceLinker.linkChanges((Object)session, changes);
        Assert.assertEquals((Object)session.getAltCoordinator1Id(), (Object)sc.getId());
        SessionCoordinator fetchedSc = session.getAltCoordinator1();
        Assert.assertNotNull((Object)fetchedSc);
        Assert.assertEquals((Object)session.getAltCoordinator1Id(), (Object)fetchedSc.getId());
        Assert.assertEquals((Object)"admin", (Object)fetchedSc.getName());
    }

    @Test
    public void testAttributeLinking_InvalidKey() {
        ConferenceSession session = new ConferenceSession();
        SessionCoordinator sc = new SessionCoordinator();
        sc.setId(-1L);
        session.setAltCoordinator1(sc);
        session.setAltCoordinator1Id(-2L);
        HashSet<String> changes = new HashSet<String>();
        changes.add("altCoordinator1.id");
        this.referenceLinker.linkChanges((Object)session, changes);
        Assert.assertEquals((Object)-1L, (Object)session.getAltCoordinator1().getId());
        Assert.assertEquals((Object)-1L, (Object)session.getAltCoordinator1Id());
    }

    @Test
    public void testAttributeLinking_Backward() {
        Room room = new Room();
        room.setNumber("1");
        room.setBuildingName("Building");
        room = (Room)this.getDataObjectService().save((Object)room, new PersistenceOption[0]);
        ConferenceSession session = new ConferenceSession();
        session.setRoom(room);
        session.setAltRoom1(room);
        session.setAltRoom2(room);
        this.referenceLinker.linkChanges((Object)session, (Set)Sets.newHashSet((Object[])new String[]{"room", "altRoom1", "altRoom2"}));
        Assert.assertEquals((Object)room.getId(), (Object)session.getAltRoom1Id());
        Assert.assertEquals((Object)room.getId(), (Object)session.getAltRoom2Id());
    }

    @Test
    public void testIdentityAndAttributeLinking() {
        SessionCoordinator sc = new SessionCoordinator();
        sc.setName("admin");
        sc = (SessionCoordinator)this.getDataObjectService().save((Object)sc, new PersistenceOption[0]);
        Assert.assertNotNull((Object)sc.getId());
        ConferenceSession session = new ConferenceSession();
        SessionCoordinator coordinator = new SessionCoordinator();
        session.setAltCoordinator1(coordinator);
        coordinator.setId(-1L);
        session.setAltCoordinator1Id(sc.getId());
        HashSet<String> changes = new HashSet<String>();
        changes.add("altCoordinator1.id");
        changes.add("altCoordinator1Id");
        this.referenceLinker.linkChanges((Object)session, changes);
        Assert.assertNotNull((Object)session.getAltCoordinator1());
        Assert.assertEquals((Object)sc.getId(), (Object)session.getAltCoordinator1Id());
        Assert.assertEquals((Object)sc.getId(), (Object)session.getAltCoordinator1().getId());
        Assert.assertEquals((Object)"admin", (Object)session.getAltCoordinator1().getName());
        session.setAltCoordinator1Id(-1L);
        this.referenceLinker.linkChanges((Object)session, changes);
        Assert.assertEquals((Object)-1L, (Object)session.getAltCoordinator1Id());
        Assert.assertNull((Object)session.getAltCoordinator1());
    }

    @Test
    public void testParentObjectWithNonUpdatableFK() {
        ConferenceSession session = new ConferenceSession();
        session.setSessionTitle("blah");
        SessionCoordinator coordinator = new SessionCoordinator();
        coordinator.setName("someuser");
        session.setAltCoordinator2(coordinator);
        ConferenceSession savedSession = (ConferenceSession)this.dataObjectService.save((Object)session, new PersistenceOption[]{PersistenceOption.FLUSH});
        Assert.assertNotNull((Object)savedSession.getId());
        Assert.assertNotNull((Object)savedSession.getAltCoordinator2().getId());
        Assert.assertNull((Object)savedSession.getAltCoordinator2Id());
        this.referenceLinker.linkChanges((Object)savedSession, (Set)Sets.newHashSet((Object[])new String[]{"altCoordinator2.id"}));
        Assert.assertEquals((Object)savedSession.getAltCoordinator2().getId(), (Object)savedSession.getAltCoordinator2Id());
        ConferenceSession savedSession2 = (ConferenceSession)this.dataObjectService.save((Object)session, new PersistenceOption[]{PersistenceOption.LINK_KEYS});
        Assert.assertNotEquals((Object)savedSession.getId(), (Object)savedSession2.getId());
        Assert.assertNotEquals((Object)savedSession.getAltCoordinator2().getId(), (Object)savedSession2.getAltCoordinator2().getId());
        Assert.assertEquals((Object)savedSession2.getAltCoordinator2().getId(), (Object)savedSession2.getAltCoordinator2Id());
        savedSession2.setAltCoordinator2(null);
        Assert.assertNotNull((Object)savedSession2.getAltCoordinator2Id());
        savedSession2 = (ConferenceSession)this.dataObjectService.save((Object)savedSession2, new PersistenceOption[]{PersistenceOption.LINK_KEYS});
        Assert.assertNull((Object)savedSession2.getAltCoordinator2());
        Assert.assertNull((Object)savedSession2.getAltCoordinator2Id());
        savedSession.setAltCoordinator2(null);
        Assert.assertNotNull((Object)savedSession.getAltCoordinator2Id());
        this.referenceLinker.linkChanges((Object)savedSession, (Set)Sets.newHashSet((Object[])new String[]{"altCoordinator2"}));
        Assert.assertNull((Object)savedSession.getAltCoordinator2());
        Assert.assertNull((Object)savedSession.getAltCoordinator2Id());
    }

    @Test
    public void testLinkingThroughCollection() {
        PresenterInfo presenter1 = new PresenterInfo();
        presenter1.setName("presenter1");
        presenter1.setInstitution("institution1");
        PresenterInfo presenter2 = new PresenterInfo();
        presenter2.setName("presenter2");
        presenter2.setInstitution("institution2");
        PresenterInfo presenter3 = new PresenterInfo();
        presenter3.setName("presenter3");
        presenter3.setInstitution("institution1");
        presenter1 = (PresenterInfo)this.getDataObjectService().save((Object)presenter1, new PersistenceOption[]{PersistenceOption.FLUSH});
        presenter2 = (PresenterInfo)this.getDataObjectService().save((Object)presenter2, new PersistenceOption[]{PersistenceOption.FLUSH});
        presenter3 = (PresenterInfo)this.getDataObjectService().save((Object)presenter3, new PersistenceOption[]{PersistenceOption.FLUSH});
        ConferenceSession session = new ConferenceSession();
        SessionPresenter sessionPresenter1 = new SessionPresenter();
        sessionPresenter1.setPrimary(true);
        sessionPresenter1.setPresenterId(presenter1.getId());
        SessionPresenter sessionPresenter2 = new SessionPresenter();
        PresenterInfo presenter2Id = new PresenterInfo();
        presenter2Id.setId(presenter2.getId());
        sessionPresenter2.setPresenter(presenter2Id);
        SessionPresenter sessionPresenter3 = new SessionPresenter();
        sessionPresenter3.setPresenter(presenter3);
        session.getPresenters().add(sessionPresenter1);
        session.getPresenters().add(sessionPresenter2);
        session.getPresenters().add(sessionPresenter3);
        HashSet changes = Sets.newHashSet((Object[])new String[]{"presenters[0].presenterId", "presenters[1].presenter.id", "presenters[2].presenter"});
        this.referenceLinker.linkChanges((Object)session, (Set)changes);
        SessionPresenter linkedPresenter1 = session.getPresenters().get(0);
        Assert.assertEquals((Object)session, (Object)linkedPresenter1.getSession());
        Assert.assertNotNull((Object)linkedPresenter1.getPresenter());
        Assert.assertEquals((Object)presenter1.getId(), (Object)linkedPresenter1.getPresenterId());
        Assert.assertEquals((Object)presenter1.getId(), (Object)linkedPresenter1.getPresenter().getId());
        Assert.assertEquals((Object)presenter1.getName(), (Object)linkedPresenter1.getPresenter().getName());
        SessionPresenter linkedPresenter2 = session.getPresenters().get(1);
        Assert.assertEquals((Object)session, (Object)linkedPresenter2.getSession());
        Assert.assertNotNull((Object)linkedPresenter2.getPresenter());
        Assert.assertEquals((Object)presenter2.getId(), (Object)linkedPresenter2.getPresenterId());
        Assert.assertEquals((Object)presenter2.getId(), (Object)linkedPresenter2.getPresenter().getId());
        Assert.assertEquals((Object)presenter2.getName(), (Object)linkedPresenter2.getPresenter().getName());
        SessionPresenter linkedPresenter3 = session.getPresenters().get(2);
        Assert.assertEquals((Object)session, (Object)linkedPresenter3.getSession());
        Assert.assertNotNull((Object)linkedPresenter3.getPresenter());
        Assert.assertEquals((Object)presenter3.getId(), (Object)linkedPresenter3.getPresenterId());
        Assert.assertEquals((Object)presenter3.getId(), (Object)linkedPresenter3.getPresenter().getId());
        Assert.assertEquals((Object)presenter3.getName(), (Object)linkedPresenter3.getPresenter().getName());
        ConferenceSession savedSession = (ConferenceSession)this.getDataObjectService().save((Object)session, new PersistenceOption[]{PersistenceOption.LINK_KEYS});
        Assert.assertNotNull((Object)savedSession.getId());
        for (SessionPresenter sessionPresenter : savedSession.getPresenters()) {
            String presenterName = sessionPresenter.getPresenter().getName();
            Assert.assertNotNull((String)("Session presenter should have generated an id for presenter " + presenterName), (Object)sessionPresenter.getId());
            Assert.assertEquals((String)("Session id was not linked for presenter " + presenterName), (Object)savedSession.getId(), (Object)sessionPresenter.getSessionId());
        }
        SessionPresenter sessionPresenter4 = new SessionPresenter();
        sessionPresenter4.setPresenterId(presenter1.getId());
        savedSession.getPresenters().add(sessionPresenter4);
        this.referenceLinker.linkChanges((Object)savedSession, (Set)Sets.newHashSet((Object[])new String[]{"presenters[3].presenterId"}));
        Assert.assertEquals((Object)presenter1.getId(), (Object)sessionPresenter4.getPresenterId());
        Assert.assertNotNull((Object)sessionPresenter4.getPresenter());
        Assert.assertEquals((Object)presenter1, (Object)sessionPresenter4.getPresenter());
        Assert.assertEquals((Object)savedSession, (Object)sessionPresenter4.getSession());
        Assert.assertEquals((Object)savedSession.getId(), (Object)sessionPresenter4.getSessionId());
        ConferenceSession savedSession2 = (ConferenceSession)this.getDataObjectService().save((Object)savedSession, new PersistenceOption[0]);
        Assert.assertEquals((long)4L, (long)savedSession2.getPresenters().size());
    }

    @Test
    public void testBiDirectionalCollectionLinking() {
        SessionCoordinator sc = new SessionCoordinator();
        ArrayList<ConferenceSession> sessions = new ArrayList<ConferenceSession>();
        ConferenceSession session = new ConferenceSession();
        sessions.add(session);
        sc.setAltCoordinatedSessions1(sessions);
        Assert.assertNull((Object)session.getAltCoordinator1());
        this.referenceLinker.linkChanges((Object)sc, (Set)Sets.newHashSet());
        this.referenceLinker.linkChanges((Object)sc, (Set)Sets.newHashSet((Object[])new String[]{"altCoordinatedSessions1"}));
        Assert.assertEquals((Object)sc, (Object)session.getAltCoordinator1());
        session.setAltCoordinator1(null);
        this.referenceLinker.linkChanges((Object)sc, (Set)Sets.newHashSet((Object[])new String[]{"altCoordinatedSessions1[1]"}));
        Assert.assertNull((Object)session.getAltCoordinator1());
        this.referenceLinker.linkChanges((Object)sc, (Set)Sets.newHashSet((Object[])new String[]{"altCoordinatedSessions1[0]"}));
        Assert.assertEquals((Object)sc, (Object)session.getAltCoordinator1());
    }

    private DataObjectService getDataObjectService() {
        return KradDataServiceLocator.getDataObjectService();
    }
}

