/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.fieldlevel;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kns.datadictionary.validation.fieldlevel.JavaClassValidationPattern;
import org.kuali.rice.krad.test.KRADTestCase;

public class JavaClassValidationPatternTest
extends KRADTestCase {
    JavaClassValidationPattern pattern;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.pattern = new JavaClassValidationPattern();
    }

    @Test
    public final void testMatches_actualClass() {
        Assert.assertTrue((boolean)this.pattern.matches(String.class.getName()));
    }

    @Test
    public final void testMatches_fictitiousClass() {
        Assert.assertTrue((boolean)this.pattern.matches("something.wicked.this.way.Comes"));
    }

    @Test
    public final void testMatches_unqualifiedClass() {
        Assert.assertTrue((boolean)this.pattern.matches("String"));
    }

    @Test
    public final void testMatches_invalidClassname1() {
        Assert.assertFalse((boolean)this.pattern.matches("23Tests"));
    }

    @Test
    public final void testMatches_invalidClassname2() {
        Assert.assertFalse((boolean)this.pattern.matches("more tests"));
    }

    @Test
    public final void testMatches_invalidClassname3() {
        Assert.assertFalse((boolean)this.pattern.matches("more.and.more:tests"));
    }

    @Test
    public final void testMatches_invalidClassname4() {
        Assert.assertFalse((boolean)this.pattern.matches("still.more.tests."));
    }
}

