/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.data.jpa.testbo.TestDataObject;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.document.bo.Account;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.data.PerTestUnitTestData;
import org.kuali.rice.test.data.UnitTestData;
import org.kuali.rice.test.data.UnitTestFile;
import org.kuali.rice.test.data.UnitTestSql;

@PerTestUnitTestData(value={@UnitTestData(order={UnitTestData.Type.SQL_STATEMENTS, UnitTestData.Type.SQL_FILES}, sqlStatements={@UnitTestSql(value="delete from trv_acct where acct_fo_id = '1'"), @UnitTestSql(value="delete from trv_acct_type"), @UnitTestSql(value="delete from krtst_test_table_t")}, sqlFiles={@UnitTestFile(filename="classpath:testAccountType.sql", delimiter=";"), @UnitTestFile(filename="classpath:testAccounts.sql", delimiter=";"), @UnitTestFile(filename="classpath:testDataObjects.sql", delimiter=";")})}, tearDown={@UnitTestData(sqlStatements={@UnitTestSql(value="delete from trv_acct where acct_fo_id = '1'"), @UnitTestSql(value="delete from krtst_test_table_t")})})
@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class LookupServiceTest
extends KRADTestCase {
    protected <T> Collection<T> findCollectionBySearchHelper(Class<T> clazz, Map<String, String> formProps, boolean unbounded) {
        return KRADServiceLocatorWeb.getLookupService().findCollectionBySearchHelper(clazz, formProps, unbounded);
    }

    protected <T> Collection<T> findCollectionBySearch(Class<T> clazz, Map<String, String> formProps) {
        return KRADServiceLocatorWeb.getLookupService().findCollectionBySearch(clazz, formProps);
    }

    protected <T> Collection<T> findCollectionBySearchUnbounded(Class<T> clazz, Map<String, String> formProps) {
        return KRADServiceLocatorWeb.getLookupService().findCollectionBySearchUnbounded(clazz, formProps);
    }

    @Test
    public void testLookupReturnLimits_Account() throws Exception {
        HashMap<String, String> formProps = new HashMap<String, String>();
        Collection<Account> travelAccounts = this.findCollectionBySearchHelper(Account.class, formProps, false);
        Assert.assertEquals((long)200L, (long)travelAccounts.size());
        travelAccounts = this.findCollectionBySearch(Account.class, formProps);
        Assert.assertEquals((long)200L, (long)travelAccounts.size());
    }

    @Test
    public void testLookupReturnLimits_TestDataObject() throws Exception {
        HashMap<String, String> formProps = new HashMap<String, String>();
        Collection<TestDataObject> testDataObjects = this.findCollectionBySearchHelper(TestDataObject.class, formProps, false);
        Assert.assertEquals((long)200L, (long)testDataObjects.size());
        testDataObjects = this.findCollectionBySearch(TestDataObject.class, formProps);
        Assert.assertEquals((long)200L, (long)testDataObjects.size());
    }

    @Test
    public void testLookupReturnDefaultLimit() throws Exception {
        HashMap<String, String> formProps = new HashMap<String, String>();
        Collection<Account> travelAccounts = this.findCollectionBySearchHelper(Account.class, formProps, false);
        Assert.assertEquals((long)200L, (long)travelAccounts.size());
        travelAccounts = this.findCollectionBySearch(Account.class, formProps);
        Assert.assertEquals((long)200L, (long)travelAccounts.size());
    }

    @Test
    public void testLookupReturnDefaultUnbounded_Account() throws Exception {
        HashMap<String, String> formProps = new HashMap<String, String>();
        Collection<Account> travelAccounts = this.findCollectionBySearchHelper(Account.class, formProps, true);
        int size = travelAccounts.size();
        Assert.assertTrue((String)"# of Travel Accounts should be > 200", (size > 200 ? 1 : 0) != 0);
        travelAccounts = this.findCollectionBySearchUnbounded(Account.class, formProps);
        size = travelAccounts.size();
        Assert.assertTrue((String)"# of Travel Accounts should be > 200", (size > 200 ? 1 : 0) != 0);
    }

    @Test
    public void testLookupReturnDefaultUnbounded_TestDataObject() throws Exception {
        HashMap<String, String> formProps = new HashMap<String, String>();
        Collection<TestDataObject> testDataObjects = this.findCollectionBySearchHelper(TestDataObject.class, formProps, true);
        int size = testDataObjects.size();
        Assert.assertTrue((String)"# of Test Data objects should be > 200", (size > 200 ? 1 : 0) != 0);
        testDataObjects = this.findCollectionBySearchUnbounded(TestDataObject.class, formProps);
        size = testDataObjects.size();
        Assert.assertTrue((String)"# of Test Data objects should be > 200", (size > 200 ? 1 : 0) != 0);
    }
}

