/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.test.document;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.krad.document.TransactionalDocumentBase;

@Entity
@Table(name="TST_SEARCH_ATTR_INDX_TST_DOC_T")
public class SearchAttributeIndexTestDocument
extends TransactionalDocumentBase {
    static Logger LOG = Logger.getLogger(SearchAttributeIndexTestDocument.class);
    private static final long serialVersionUID = -2290510385815271758L;
    @Column(name="RTE_LVL_CNT")
    private Long routeLevelCount = 0L;
    @Column(name="CNSTNT_STR")
    private String constantString;
    @Column(name="RTD_STR")
    private String routedString;
    @Column(name="HLD_RTD_STR")
    private String heldRoutedString;
    @Column(name="RD_ACCS_CNT")
    private Long readAccessCount = 0L;

    public void initialize(String constantString, String routedString) {
        this.constantString = constantString;
        this.heldRoutedString = routedString;
    }

    public Long getRouteLevelCount() {
        this.readAccessCount = this.readAccessCount + 1L;
        return this.routeLevelCount;
    }

    public String getConstantString() {
        return this.constantString;
    }

    public String getRoutedString() {
        return this.routedString;
    }

    public String getHeldRoutedString() {
        return this.heldRoutedString;
    }

    public Long getReadAccessCount() {
        return this.readAccessCount;
    }

    public void doRouteLevelChange(DocumentRouteLevelChange levelChangeEvent) {
        super.doRouteLevelChange(levelChangeEvent);
        this.routeLevelCount = this.routeLevelCount + 1L;
        if (this.routedString == null) {
            this.routedString = this.heldRoutedString;
        }
        LOG.info((Object)("Performing route level change on SearchAttributeIndexTestDocument; routeLevelCount is " + this.routeLevelCount));
    }
}

