/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.test.data.PerSuiteUnitTestData;
import org.kuali.rice.test.data.UnitTestData;
import org.kuali.rice.test.data.UnitTestFile;

@PerSuiteUnitTestData(value={@UnitTestData(order={UnitTestData.Type.SQL_STATEMENTS, UnitTestData.Type.SQL_FILES}, sqlFiles={@UnitTestFile(filename="classpath:testValidationMessages.sql", delimiter=";")})})
public class ValidationMessageRetrievalTest
extends KRADTestCase {
    private MessageMap messageMap;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.messageMap = new MessageMap();
    }

    @Test
    public void testRetrieveMessage_keyOnly() throws Exception {
        this.messageMap.putError("field1", "testErrorKey", new String[0]);
        List fieldErrors = this.messageMap.getErrorMessagesForProperty("field1");
        Assert.assertEquals((String)"Incorrect number of messages for field1", (long)1L, (long)fieldErrors.size());
        ErrorMessage message = (ErrorMessage)fieldErrors.get(0);
        String messageText = KRADUtils.getMessageText((ErrorMessage)message, (boolean)true);
        Assert.assertEquals((String)"Message for field1 is not correct", (Object)"Error on field1", (Object)messageText);
    }

    @Test
    public void testRetrieveMessage_namespaceKey() throws Exception {
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setNamespaceCode("KR-NS");
        errorMessage.setErrorKey("testErrorKey");
        this.messageMap.putError("field1", errorMessage);
        List fieldErrors = this.messageMap.getErrorMessagesForProperty("field1");
        Assert.assertEquals((String)"Incorrect number of messages for field1", (long)1L, (long)fieldErrors.size());
        ErrorMessage message = (ErrorMessage)fieldErrors.get(0);
        String messageText = KRADUtils.getMessageText((ErrorMessage)message, (boolean)true);
        Assert.assertEquals((String)"Message for field1 is not correct", (Object)"Error on field1", (Object)messageText);
    }

    @Test
    public void testRetrieveMessage_componentKey() throws Exception {
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setNamespaceCode("KR-NS");
        errorMessage.setComponentCode("GeneralGroup");
        errorMessage.setErrorKey("testErrorKey");
        this.messageMap.putError("field1", errorMessage);
        List fieldErrors = this.messageMap.getErrorMessagesForProperty("field1");
        Assert.assertEquals((String)"Incorrect number of messages for field1", (long)1L, (long)fieldErrors.size());
        ErrorMessage message = (ErrorMessage)fieldErrors.get(0);
        String messageText = KRADUtils.getMessageText((ErrorMessage)message, (boolean)true);
        Assert.assertEquals((String)"Message for field1 is not correct", (Object)"Error on field1", (Object)messageText);
    }
}

