/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.repository.reference.ReferenceObjectBinding;
import org.kuali.rice.krms.api.repository.reference.ReferenceObjectBindingContract;
import org.kuali.rice.krms.test.RuleManagementBaseTest;
import org.kuali.rice.krms.test.RuleManagementBaseTestObjectNames;

public class RuleManagementReferenceObjectBindingTest
extends RuleManagementBaseTest {
    @Override
    @Before
    public void setClassDiscriminator() {
        this.CLASS_DISCRIMINATOR = "RMROBT";
    }

    @Test
    public void testCreateReferenceObjectBinding() {
        RuleManagementBaseTestObjectNames t0 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t0");
        ReferenceObjectBinding.Builder refObjBindingBuilder = this.createTestReferenceObjectBinding(t0.object0);
        ReferenceObjectBinding refObjBinding = this.ruleManagementService.getReferenceObjectBinding(refObjBindingBuilder.getId());
        refObjBindingBuilder = ReferenceObjectBinding.Builder.create((ReferenceObjectBindingContract)refObjBinding);
        Assert.assertNotNull((String)"Created ReferenceObjectBinding not found", (Object)refObjBindingBuilder);
        Assert.assertEquals((String)"Invalid CollectionName of refObjBindingBuilder found", (Object)"ParkingPolicies", (Object)refObjBindingBuilder.getCollectionName());
        Assert.assertEquals((String)"Invalid KrmsObjectId of refObjBindingBuilder found", (Object)t0.agenda_Id, (Object)refObjBindingBuilder.getKrmsObjectId());
        Assert.assertEquals((String)"Invalid KrmsDiscriminatorType of refObjBindingBuilder found", (Object)this.krmsTypeRepository.getTypeByName(t0.namespaceName, "AgendaType" + t0.object0).getId(), (Object)refObjBindingBuilder.getKrmsDiscriminatorType());
        Assert.assertEquals((String)"Invalid Namespace of refObjBindingBuilder found", (Object)t0.namespaceName, (Object)refObjBindingBuilder.getNamespace());
        Assert.assertEquals((String)"Invalid ReferenceObjectId of refObjBindingBuilder found", (Object)t0.referenceObject_0_Id, (Object)refObjBindingBuilder.getReferenceObjectId());
        Assert.assertEquals((String)"Invalid ReferenceDiscriminatorType of refObjBindingBuilder found", (Object)t0.referenceObject_0_DiscriminatorType, (Object)refObjBindingBuilder.getReferenceDiscriminatorType());
        Assert.assertEquals((String)"Invalid Active value of refObjBindingBuilder found", (Object)true, (Object)refObjBindingBuilder.isActive());
        try {
            this.ruleManagementService.createReferenceObjectBinding(refObjBindingBuilder.build());
            Assert.fail((String)"Should have thrown IllegalStateException: the ReferenceObjectBinding to create already exists");
        }
        catch (Exception exception) {
            // empty catch block
        }
        refObjBindingBuilder.setId("RefObjBindIdChanged");
        try {
            this.ruleManagementService.createReferenceObjectBinding(refObjBindingBuilder.build());
            Assert.fail((String)"Should have thrown DataIntegrityViolationException: OJB operation; SQL []; Duplicate entry");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetReferenceObjectBinding() {
        RuleManagementBaseTestObjectNames t1 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t1");
        ReferenceObjectBinding.Builder refObjBindingBuilder = this.createTestReferenceObjectBinding(t1.object0);
        ReferenceObjectBinding refObjBinding = this.ruleManagementService.getReferenceObjectBinding(refObjBindingBuilder.getId());
        Assert.assertNotNull((String)"ReferenceObjectBinding should have been returned", (Object)refObjBinding);
        Assert.assertEquals((String)"Incorrect value found on returned ReferenceObjectBinding", (Object)t1.referenceObject_0_Id, (Object)refObjBinding.getReferenceObjectId());
        try {
            refObjBinding = this.ruleManagementService.getReferenceObjectBinding(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: referenceObjectBindingId was null");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull((String)"ReferenceObjectBinding should not have been found", (Object)this.ruleManagementService.getReferenceObjectBinding("junk_value"));
    }

    @Test
    public void testGetReferenceObjectBindings() {
        RuleManagementBaseTestObjectNames t2 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t2");
        ArrayList<String> referenceObjectBindingIds = new ArrayList<String>();
        referenceObjectBindingIds.add(this.createTestReferenceObjectBinding(t2.object0).getId());
        referenceObjectBindingIds.add(this.createTestReferenceObjectBinding(t2.object1).getId());
        referenceObjectBindingIds.add(this.createTestReferenceObjectBinding(t2.object2).getId());
        List referenceObjectBindings = this.ruleManagementService.getReferenceObjectBindings(referenceObjectBindingIds);
        int objectsFound = 0;
        for (ReferenceObjectBinding referenceObjectBinding : referenceObjectBindings) {
            if (referenceObjectBindingIds.contains(referenceObjectBinding.getId())) {
                ++objectsFound;
                continue;
            }
            Assert.fail((String)"Unexpected object returned");
        }
        Assert.assertEquals((String)"Expected number of objects not returned", (long)3L, (long)objectsFound);
        try {
            this.ruleManagementService.getReferenceObjectBindings(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: reference binding object ids must not be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Incorrect number of objects returned", (long)0L, (long)this.ruleManagementService.getReferenceObjectBindings(new ArrayList()).size());
        referenceObjectBindingIds.add("junkValue");
        referenceObjectBindings = this.ruleManagementService.getReferenceObjectBindings(referenceObjectBindingIds);
        objectsFound = 0;
        for (ReferenceObjectBinding referenceObjectBinding : referenceObjectBindings) {
            if (referenceObjectBindingIds.contains(referenceObjectBinding.getId())) {
                ++objectsFound;
                continue;
            }
            Assert.fail((String)"Unexpected object returned");
        }
        Assert.assertEquals((String)"Expected number of objects not returned", (long)3L, (long)objectsFound);
    }

    @Test
    public void testFindReferenceObjectBindingsByReferenceObject() {
        RuleManagementBaseTestObjectNames t3 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t3");
        ReferenceObjectBinding.Builder refObjBindingBuilder = this.createTestReferenceObjectBinding(t3.object0);
        List referenceObjectBindings = this.ruleManagementService.findReferenceObjectBindingsByReferenceObject(refObjBindingBuilder.getReferenceDiscriminatorType(), refObjBindingBuilder.getReferenceObjectId());
        Assert.assertEquals((String)"Incorrect number of objects returned", (long)1L, (long)referenceObjectBindings.size());
        try {
            this.ruleManagementService.findReferenceObjectBindingsByReferenceObject(null, refObjBindingBuilder.getReferenceObjectId());
            Assert.fail((String)"should have thrown RiceIllegalArgumentException: reference binding object discriminator type must not be null");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.findReferenceObjectBindingsByReferenceObject(refObjBindingBuilder.getReferenceDiscriminatorType(), null);
            Assert.fail((String)"should have thrown RiceIllegalArgumentException: reference object id must not be null");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        referenceObjectBindings = this.ruleManagementService.findReferenceObjectBindingsByReferenceObject("junkvalue", "junkvalue");
        Assert.assertEquals((String)"Incorrect number of objects returned", (long)0L, (long)referenceObjectBindings.size());
    }

    @Test
    public void testFindReferenceObjectBindingsByReferenceDiscriminatorType() {
        RuleManagementBaseTestObjectNames t4 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t4");
        ReferenceObjectBinding.Builder refObjBindingBuilder = this.createTestReferenceObjectBinding(t4.object0);
        refObjBindingBuilder.setReferenceDiscriminatorType("ParkingAffiliationType" + t4.discriminator);
        this.ruleManagementService.updateReferenceObjectBinding(refObjBindingBuilder.build());
        refObjBindingBuilder = this.createTestReferenceObjectBinding(t4.object1);
        refObjBindingBuilder.setReferenceDiscriminatorType("ParkingAffiliationType" + t4.discriminator);
        this.ruleManagementService.updateReferenceObjectBinding(refObjBindingBuilder.build());
        List referenceObjectBindings = this.ruleManagementService.findReferenceObjectBindingsByReferenceDiscriminatorType(refObjBindingBuilder.getReferenceDiscriminatorType());
        Assert.assertEquals((String)"Incorrect number of objects returned", (long)2L, (long)referenceObjectBindings.size());
        try {
            this.ruleManagementService.findReferenceObjectBindingsByReferenceDiscriminatorType("   ");
            Assert.fail((String)"Should have thrown IllegalArgumentException: referenceDiscriminatorType is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.findReferenceObjectBindingsByReferenceDiscriminatorType(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: referenceDiscriminatorType is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFindReferenceObjectBindingsByKrmsDiscriminatorType() {
        RuleManagementBaseTestObjectNames t5 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t5");
        ReferenceObjectBinding.Builder refObjBindingBuilder6008 = this.createTestReferenceObjectBinding(t5.object0);
        ReferenceObjectBinding.Builder refObjBindingBuilder6009 = this.createTestReferenceObjectBinding(t5.object1);
        refObjBindingBuilder6009.setKrmsDiscriminatorType(refObjBindingBuilder6008.getKrmsDiscriminatorType());
        this.ruleManagementService.updateReferenceObjectBinding(refObjBindingBuilder6009.build());
        List referenceObjectBindings = this.ruleManagementService.findReferenceObjectBindingsByKrmsDiscriminatorType(refObjBindingBuilder6008.getKrmsDiscriminatorType());
        Assert.assertEquals((String)"Incorrect number of objects returned", (long)2L, (long)referenceObjectBindings.size());
        try {
            this.ruleManagementService.findReferenceObjectBindingsByKrmsDiscriminatorType("   ");
            Assert.fail((String)"Should have thrown IllegalArgumentException: krmsDiscriminatorType is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.findReferenceObjectBindingsByKrmsDiscriminatorType(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: krmsDiscriminatorType is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFindReferenceObjectBindingsByKrmsObject() {
        RuleManagementBaseTestObjectNames t6 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t6");
        ReferenceObjectBinding.Builder refObjBindingBuilder0 = this.createTestReferenceObjectBinding(t6.object0);
        ReferenceObjectBinding.Builder refObjBindingBuilder1 = this.createTestReferenceObjectBinding(t6.object1);
        refObjBindingBuilder1.setKrmsObjectId(refObjBindingBuilder0.getKrmsObjectId());
        this.ruleManagementService.updateReferenceObjectBinding(refObjBindingBuilder1.build());
        List referenceObjectBindings = this.ruleManagementService.findReferenceObjectBindingsByKrmsObject(refObjBindingBuilder0.getKrmsObjectId());
        Assert.assertEquals((String)"Incorrect number of objects returned", (long)2L, (long)referenceObjectBindings.size());
        try {
            this.ruleManagementService.findReferenceObjectBindingsByKrmsObject("   ");
            Assert.fail((String)"Should have thrown IllegalArgumentException: krmsObjectId is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.findReferenceObjectBindingsByKrmsObject(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: krmsObjectId is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateReferenceObjectBinding() {
        RuleManagementBaseTestObjectNames t7 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t7");
        ReferenceObjectBinding.Builder refObjBindingBuilder = this.createTestReferenceObjectBinding(t7.object0);
        ReferenceObjectBinding refObjBinding = this.ruleManagementService.getReferenceObjectBinding(refObjBindingBuilder.getId());
        refObjBindingBuilder = ReferenceObjectBinding.Builder.create((ReferenceObjectBindingContract)refObjBinding);
        Assert.assertNotNull((String)"Created ReferenceObjectBinding not found", (Object)refObjBindingBuilder);
        Assert.assertEquals((String)"Invalid CollectionName of refObjBindingBuilder found", (Object)"ParkingPolicies", (Object)refObjBindingBuilder.getCollectionName());
        Assert.assertEquals((String)"Invalid KrmsObjectId of refObjBindingBuilder found", (Object)t7.agenda_Id, (Object)refObjBindingBuilder.getKrmsObjectId());
        Assert.assertEquals((String)"Invalid KrmsDiscriminatorType of refObjBindingBuilder found", (Object)this.krmsTypeRepository.getTypeByName(t7.namespaceName, "AgendaType" + t7.object0).getId(), (Object)refObjBindingBuilder.getKrmsDiscriminatorType());
        Assert.assertEquals((String)"Invalid Namespace of refObjBindingBuilder found", (Object)t7.namespaceName, (Object)refObjBindingBuilder.getNamespace());
        Assert.assertEquals((String)"Invalid ReferenceObjectId of refObjBindingBuilder found", (Object)t7.referenceObject_0_Id, (Object)refObjBindingBuilder.getReferenceObjectId());
        Assert.assertEquals((String)"Invalid ReferenceDiscriminatorType  of refObjBindingBuilder found", (Object)"ParkingAffiliationType", (Object)refObjBindingBuilder.getReferenceDiscriminatorType());
        Assert.assertEquals((String)"Invalid Active value of refObjBindingBuilder found", (Object)true, (Object)refObjBindingBuilder.isActive());
        refObjBindingBuilder.setCollectionName("ParkingPolicies6Changed");
        refObjBindingBuilder.setKrmsObjectId("AgendaId6Changed");
        refObjBindingBuilder.setKrmsDiscriminatorType("KDTtype6Changed");
        refObjBindingBuilder.setNamespace("Namespace6Changed");
        refObjBindingBuilder.setReferenceObjectId("PA6Changed");
        refObjBindingBuilder.setReferenceDiscriminatorType("ParkingAffiliationTypeChanged");
        refObjBindingBuilder.setActive(false);
        this.ruleManagementService.updateReferenceObjectBinding(refObjBindingBuilder.build());
        refObjBinding = this.ruleManagementService.getReferenceObjectBinding(refObjBindingBuilder.getId());
        refObjBindingBuilder = ReferenceObjectBinding.Builder.create((ReferenceObjectBindingContract)refObjBinding);
        Assert.assertNotNull((String)"Created ReferenceObjectBinding not found", (Object)refObjBindingBuilder);
        Assert.assertEquals((String)"Invalid CollectionName of refObjBindingBuilder found", (Object)"ParkingPolicies6Changed", (Object)refObjBindingBuilder.getCollectionName());
        Assert.assertEquals((String)"Invalid KrmsObjectId of refObjBindingBuilder found", (Object)"AgendaId6Changed", (Object)refObjBindingBuilder.getKrmsObjectId());
        Assert.assertEquals((String)"Invalid KrmsDiscriminatorType of refObjBindingBuilder found", (Object)"KDTtype6Changed", (Object)refObjBindingBuilder.getKrmsDiscriminatorType());
        Assert.assertEquals((String)"Invalid Namespace of refObjBindingBuilder found", (Object)"Namespace6Changed", (Object)refObjBindingBuilder.getNamespace());
        Assert.assertEquals((String)"Invalid ReferenceObjectId of refObjBindingBuilder found", (Object)"PA6Changed", (Object)refObjBindingBuilder.getReferenceObjectId());
        Assert.assertEquals((String)"Invalid ReferenceDiscriminatorType  of refObjBindingBuilder found", (Object)"ParkingAffiliationTypeChanged", (Object)refObjBindingBuilder.getReferenceDiscriminatorType());
        Assert.assertEquals((String)"Invalid Active value of refObjBindingBuilder found", (Object)false, (Object)refObjBindingBuilder.isActive());
        refObjBindingBuilder.setId("junkValue");
        try {
            this.ruleManagementService.updateReferenceObjectBinding(refObjBindingBuilder.build());
            Assert.fail((String)"Should have thrown IllegalStateException: the ReferenceObjectBinding to update does not exists");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteReferenceObjectBinding() {
        RuleManagementBaseTestObjectNames t8 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t8");
        ReferenceObjectBinding.Builder refObjBindingBuilder = this.createTestReferenceObjectBinding(t8.object0);
        ReferenceObjectBinding refObjBinding = this.ruleManagementService.getReferenceObjectBinding(refObjBindingBuilder.getId());
        refObjBindingBuilder = ReferenceObjectBinding.Builder.create((ReferenceObjectBindingContract)refObjBinding);
        Assert.assertNotNull((String)"Created ReferenceObjectBinding not found", (Object)refObjBindingBuilder);
        this.ruleManagementService.deleteReferenceObjectBinding(refObjBinding.getId());
        Assert.assertNull((String)"Deleted ReferenceObjectBinding found", (Object)this.ruleManagementService.getReferenceObjectBinding(refObjBindingBuilder.getId()));
        try {
            this.ruleManagementService.deleteReferenceObjectBinding(refObjBinding.getId());
            Assert.fail((String)"should have thrown IllegalStateException: the ReferenceObjectBinding to delete does not exists");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.deleteReferenceObjectBinding(null);
            Assert.fail((String)"should have thrown IllegalArgumentException: referenceObjectBindingId was null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFindReferenceObjectBindingIds() {
        RuleManagementBaseTestObjectNames t9 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t9");
        ArrayList<String> refObjBindingBuilderIds = new ArrayList<String>();
        ReferenceObjectBinding.Builder refObjBindingBuilder = this.createTestReferenceObjectBinding(t9.object0);
        refObjBindingBuilderIds.add(refObjBindingBuilder.getId());
        refObjBindingBuilder = this.createTestReferenceObjectBinding(t9.object1);
        refObjBindingBuilderIds.add(refObjBindingBuilder.getId());
        refObjBindingBuilder = this.createTestReferenceObjectBinding(t9.object2);
        refObjBindingBuilderIds.add(refObjBindingBuilder.getId());
        refObjBindingBuilder.setActive(false);
        this.ruleManagementService.updateReferenceObjectBinding(refObjBindingBuilder.build());
        QueryByCriteria.Builder query = QueryByCriteria.Builder.create();
        query.setPredicates(new Predicate[]{PredicateFactory.in((String)"id", (Object[])refObjBindingBuilderIds.toArray(new String[0]))});
        List referenceObjectBindingIds = this.ruleManagementService.findReferenceObjectBindingIds(query.build());
        for (String referenceObjectBindingId : referenceObjectBindingIds) {
            Assert.assertTrue((boolean)refObjBindingBuilderIds.contains(referenceObjectBindingId));
        }
        Assert.assertEquals((String)"incorrect number of ReferenceObjectBindingIds found", (long)3L, (long)referenceObjectBindingIds.size());
        query = QueryByCriteria.Builder.create();
        query.setPredicates(new Predicate[]{PredicateFactory.equal((String)"active", (Object)Boolean.TRUE), PredicateFactory.in((String)"id", (Object[])refObjBindingBuilderIds.toArray(new String[0]))});
        referenceObjectBindingIds = this.ruleManagementService.findReferenceObjectBindingIds(query.build());
        for (String referenceObjectBindingId : referenceObjectBindingIds) {
            Assert.assertTrue((boolean)refObjBindingBuilderIds.contains(referenceObjectBindingId));
        }
        Assert.assertEquals((String)"incorrect number of ReferenceObjectBindingIds found", (long)2L, (long)referenceObjectBindingIds.size());
    }
}

