/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.action.ActionDefinitionContract;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.test.RuleManagementBaseTest;
import org.kuali.rice.krms.test.RuleManagementBaseTestObjectNames;

public class RuleManagementActionDefinitionTest
extends RuleManagementBaseTest {
    @Override
    @Before
    public void setClassDiscriminator() {
        this.CLASS_DISCRIMINATOR = "RMADT";
    }

    @Test
    public void testCreateAction() {
        RuleManagementBaseTestObjectNames t0 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t0");
        KrmsTypeDefinition krmsTypeDefinition = this.createKrmsActionTypeDefinition(t0.namespaceName);
        RuleDefinition ruleDefintion = this.buildTestRuleDefinition(t0.namespaceName, t0.discriminator);
        ActionDefinition actionDefinition = ActionDefinition.Builder.create((String)t0.action0_Id, (String)t0.action0_Name, (String)t0.namespaceName, (String)krmsTypeDefinition.getId(), (String)ruleDefintion.getId(), (Integer)1).build();
        Assert.assertNull((String)"action should not be in database", (Object)this.ruleManagementService.getAction(t0.action0_Id));
        actionDefinition = this.ruleManagementService.createAction(actionDefinition);
        ActionDefinition returnActionDefinition = this.ruleManagementService.getAction(actionDefinition.getId());
        Assert.assertNotNull((String)"created action not found", (Object)returnActionDefinition);
        Assert.assertEquals((String)"create action error:", (Object)t0.action0_Id, (Object)returnActionDefinition.getId());
    }

    @Test
    public void testUpdateAction() {
        RuleManagementBaseTestObjectNames t1 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t1");
        KrmsTypeDefinition krmsTypeDefinition = this.createKrmsActionTypeDefinition(t1.namespaceName);
        RuleDefinition ruleDefinition = this.buildTestRuleDefinition(t1.namespaceName, t1.object0);
        ActionDefinition actionDefinition = ActionDefinition.Builder.create((String)t1.action0_Id, (String)t1.action0_Name, (String)t1.namespaceName, (String)krmsTypeDefinition.getId(), (String)ruleDefinition.getId(), (Integer)1).build();
        Assert.assertNull((String)"action should not be in database", (Object)this.ruleManagementService.getAction(t1.action0_Id));
        actionDefinition = this.ruleManagementService.createAction(actionDefinition);
        ActionDefinition returnActionDefinition = this.ruleManagementService.getAction(actionDefinition.getId());
        ActionDefinition.Builder builder = ActionDefinition.Builder.create((ActionDefinitionContract)returnActionDefinition);
        builder.setDescription("ChangedDescr");
        this.ruleManagementService.updateAction(builder.build());
        returnActionDefinition = this.ruleManagementService.getAction(actionDefinition.getId());
        Assert.assertNotNull((String)"action not found", (Object)returnActionDefinition);
        Assert.assertEquals((String)"update action error:", (Object)"ChangedDescr", (Object)returnActionDefinition.getDescription());
    }

    @Test
    public void testDeleteAction() {
        RuleManagementBaseTestObjectNames t2 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t2");
        KrmsTypeDefinition krmsTypeDefinition = this.createKrmsActionTypeDefinition(t2.namespaceName);
        RuleDefinition ruleDefintion = this.buildTestRuleDefinition(t2.namespaceName, t2.object0);
        ActionDefinition actionDefinition = ActionDefinition.Builder.create((String)t2.action0_Id, (String)t2.action0_Name, (String)t2.namespaceName, (String)krmsTypeDefinition.getId(), (String)ruleDefintion.getId(), (Integer)1).build();
        Assert.assertNull((String)"action should not be in database", (Object)this.ruleManagementService.getAction(t2.action0_Id));
        actionDefinition = this.ruleManagementService.createAction(actionDefinition);
        actionDefinition = this.ruleManagementService.getAction(actionDefinition.getId());
        Assert.assertNotNull((String)"action not found", (Object)this.ruleManagementService.getAction(actionDefinition.getId()));
        try {
            this.ruleManagementService.deleteAction(t2.action0_Id);
            Assert.fail((String)"should fail deleteAction not implemented");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        actionDefinition = this.ruleManagementService.getAction(actionDefinition.getId());
        Assert.assertNotNull((String)"action not found", (Object)actionDefinition);
    }

    @Test
    public void testGetAction() {
        RuleManagementBaseTestObjectNames t3 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t3");
        KrmsTypeDefinition krmsTypeDefinition = this.createKrmsActionTypeDefinition(t3.namespaceName);
        RuleDefinition ruleDefintion = this.buildTestRuleDefinition(t3.namespaceName, t3.object0);
        ActionDefinition actionDefinition = ActionDefinition.Builder.create((String)t3.action0_Id, (String)t3.action0_Name, (String)t3.namespaceName, (String)krmsTypeDefinition.getId(), (String)ruleDefintion.getId(), (Integer)1).build();
        Assert.assertNull((String)"action should not be in database", (Object)this.ruleManagementService.getAction(t3.action0_Id));
        actionDefinition = this.ruleManagementService.createAction(actionDefinition);
        ActionDefinition returnActionDefinition = this.ruleManagementService.getAction(actionDefinition.getId());
        Assert.assertNotNull((String)"action not found", (Object)returnActionDefinition);
        Assert.assertEquals((String)"getAction error:", (Object)t3.action0_Id, (Object)returnActionDefinition.getId());
    }

    @Test
    public void testGetActions() {
        RuleManagementBaseTestObjectNames t4 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t4");
        RuleDefinition ruleDefinition0 = this.buildTestRuleDefinition(t4.namespaceName, t4.object0);
        RuleDefinition ruleDefinition1 = this.buildTestRuleDefinition(t4.namespaceName, t4.object1);
        RuleDefinition ruleDefinition2 = this.buildTestRuleDefinition(t4.namespaceName, t4.object2);
        RuleDefinition ruleDefinition3 = this.buildTestRuleDefinition(t4.namespaceName, t4.object3);
        this.buildTestActionDefinition(t4.action0_Id, t4.action0_Name, t4.action0_Descr, 1, ruleDefinition0.getId(), t4.namespaceName);
        this.buildTestActionDefinition(t4.action1_Id, t4.action1_Name, t4.action1_Descr, 1, ruleDefinition1.getId(), t4.namespaceName);
        this.buildTestActionDefinition(t4.action2_Id, t4.action2_Name, t4.action2_Descr, 1, ruleDefinition2.getId(), t4.namespaceName);
        this.buildTestActionDefinition(t4.action3_Id, t4.action3_Name, t4.action3_Descr, 1, ruleDefinition3.getId(), t4.namespaceName);
        List<String> actionIds = Arrays.asList(t4.action0_Id, t4.action1_Id, t4.action2_Id, t4.action3_Id);
        List returnActionDefinitions = this.ruleManagementService.getActions(actionIds);
        Assert.assertEquals((String)"incorrect number of actions returned", (long)4L, (long)returnActionDefinitions.size());
        int actionsFound = 0;
        for (ActionDefinition actionDefinition : returnActionDefinitions) {
            if (!actionIds.contains(actionDefinition.getId())) continue;
            ++actionsFound;
        }
        Assert.assertEquals((String)"incorrect number of actions returned", (long)4L, (long)actionsFound);
        Assert.assertEquals((String)"action not found", (Object)t4.action0_Descr, (Object)this.ruleManagementService.getAction(t4.action0_Id).getDescription());
        Assert.assertEquals((String)"action not found", (Object)t4.action1_Descr, (Object)this.ruleManagementService.getAction(t4.action1_Id).getDescription());
        Assert.assertEquals((String)"action not found", (Object)t4.action2_Descr, (Object)this.ruleManagementService.getAction(t4.action2_Id).getDescription());
        Assert.assertEquals((String)"action not found", (Object)t4.action3_Descr, (Object)this.ruleManagementService.getAction(t4.action3_Id).getDescription());
    }

    @Test
    public void testFindActionIds() {
        RuleManagementBaseTestObjectNames t5 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t5");
        RuleDefinition ruleDefinition = this.buildTestRuleDefinition(t5.namespaceName, t5.object0);
        this.buildTestActionDefinition(t5.action0_Id, t5.action0_Name, t5.action0_Descr, 1, ruleDefinition.getId(), t5.namespaceName);
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"name", (Object)t5.action0_Name)});
        List actionIds = this.ruleManagementService.findActionIds(builder.build());
        if (!actionIds.contains(t5.action0_Id)) {
            Assert.fail((String)"actionId not found");
        }
    }

    @Test
    public void testActionCacheEvict() {
        RuleManagementBaseTestObjectNames t6 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t6");
        this.verifyEmptyAction(t6);
        RuleDefinition ruleDefinition = this.buildTestRuleDefinition(t6.namespaceName, t6.object0);
        this.buildTestActionDefinition(t6.action_Id, t6.action_Name, t6.action_Descr, 1, ruleDefinition.getId(), t6.namespaceName);
        this.verifyFullAction(t6);
    }

    private void verifyEmptyAction(RuleManagementBaseTestObjectNames t) {
        ActionDefinition action = this.ruleManagementService.getAction(t.action_Id);
        Assert.assertNull((String)"Action is not null", (Object)action);
        RuleDefinition rule = this.ruleManagementService.getRule(t.rule_Id);
        Assert.assertFalse((String)"Action in Rule found", (rule != null ? 1 : 0) != 0);
    }

    private void verifyFullAction(RuleManagementBaseTestObjectNames t) {
        ActionDefinition action = this.ruleManagementService.getAction(t.action_Id);
        Assert.assertNotNull((String)"Action is null", (Object)action);
        boolean foundRule = false;
        RuleDefinition rule = this.ruleManagementService.getRule(t.rule_Id);
        if (rule != null) {
            for (ActionDefinition ruleAction : rule.getActions()) {
                if (!StringUtils.equals((String)t.rule_Id, (String)ruleAction.getRuleId())) continue;
                foundRule = true;
                break;
            }
        }
        Assert.assertTrue((String)"Action in Rule not found", (boolean)foundRule);
    }
}

