/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.context.ContextDefinitionContract;
import org.kuali.rice.krms.test.RuleManagementBaseTest;
import org.kuali.rice.krms.test.RuleManagementBaseTestObjectNames;

public class RuleManagementContextDefinitionTest
extends RuleManagementBaseTest {
    @Override
    @Before
    public void setClassDiscriminator() {
        this.CLASS_DISCRIMINATOR = "RMCDT";
    }

    @Test
    public void testCreateContext() {
        RuleManagementBaseTestObjectNames t0 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t0");
        ContextDefinition.Builder contextDefinitionBuilder = ContextDefinition.Builder.create((String)t0.namespaceName, (String)t0.context0_Name);
        contextDefinitionBuilder.setId(t0.context0_Id);
        this.ruleManagementService.createContext(contextDefinitionBuilder.build());
        try {
            this.ruleManagementService.createContext(contextDefinitionBuilder.build());
            Assert.fail((String)"Should have thrown IllegalStateException: the context to create already exists");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ContextDefinition context = this.ruleManagementService.getContext(t0.context0_Id);
        Assert.assertEquals((String)"Unexpected namespace on created context", (Object)t0.namespaceName, (Object)context.getNamespace());
        Assert.assertEquals((String)"Unexpected name on created context", (Object)t0.context0_Name, (Object)context.getName());
        Assert.assertEquals((String)"Unexpected context id on returned context", (Object)t0.context0_Id, (Object)context.getId());
        try {
            contextDefinitionBuilder = ContextDefinition.Builder.create(null, (String)t0.context1_Name);
            Assert.fail((String)"Should have thrown IllegalArgumentException: namespace is blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            contextDefinitionBuilder = ContextDefinition.Builder.create((String)t0.namespaceName, null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: name is blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFindCreateContext() {
        RuleManagementBaseTestObjectNames t1 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t1");
        ContextDefinition.Builder contextDefinitionBuilder = ContextDefinition.Builder.create((String)t1.namespaceName, (String)t1.context0_Name);
        contextDefinitionBuilder.setId(t1.context0_Id);
        ContextDefinition context = this.ruleManagementService.findCreateContext(contextDefinitionBuilder.build());
        Assert.assertEquals((String)"Unexpected namespace on created context", (Object)t1.namespaceName, (Object)context.getNamespace());
        Assert.assertEquals((String)"Unexpected name on created context", (Object)t1.context0_Name, (Object)context.getName());
        Assert.assertEquals((String)"Unexpected context id on returned context", (Object)t1.context0_Id, (Object)context.getId());
        contextDefinitionBuilder = ContextDefinition.Builder.create((String)t1.namespaceName, (String)t1.context0_Name);
        context = this.ruleManagementService.findCreateContext(contextDefinitionBuilder.build());
        Assert.assertEquals((String)"Unexpected context id on returned context", (Object)t1.context0_Id, (Object)context.getId());
        Assert.assertEquals((String)"Unexpected namespace on created context", (Object)t1.namespaceName, (Object)context.getNamespace());
        Assert.assertEquals((String)"Unexpected name on created context", (Object)t1.context0_Name, (Object)context.getName());
        try {
            this.ruleManagementService.findCreateContext(null);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateContext() {
        RuleManagementBaseTestObjectNames t2 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t2");
        ContextDefinition context = this.buildTestContext(t2.object0);
        context = this.ruleManagementService.getContext(context.getId());
        Assert.assertEquals((String)"Unexpected namespace on created context", (Object)t2.namespaceName, (Object)context.getNamespace());
        Assert.assertEquals((String)"Unexpected name on created context", (Object)t2.context0_Name, (Object)context.getName());
        Assert.assertEquals((String)"Unexpected context id on returned context", (Object)t2.context0_Id, (Object)context.getId());
        Assert.assertNull((String)"Context Description not yet set, should have been null", (Object)context.getDescription());
        Assert.assertEquals((String)"Unexpected context active state", (Object)true, (Object)context.isActive());
        ContextDefinition.Builder contextBuilder = ContextDefinition.Builder.create((ContextDefinitionContract)context);
        contextBuilder.setNamespace(t2.namespaceName + "Changed");
        contextBuilder.setName(t2.context0_Name + "Changed");
        contextBuilder.setDescription(t2.context0_Descr + "Changed");
        contextBuilder.setActive(false);
        this.ruleManagementService.updateContext(contextBuilder.build());
        context = this.ruleManagementService.getContext(t2.context0_Id);
        Assert.assertEquals((String)"Unexpected namespace on created context", (Object)(t2.namespaceName + "Changed"), (Object)context.getNamespace());
        Assert.assertEquals((String)"Unexpected name on created context", (Object)(t2.context0_Name + "Changed"), (Object)context.getName());
        Assert.assertEquals((String)"Unexpected context id on returned context", (Object)t2.context0_Id, (Object)context.getId());
        Assert.assertEquals((String)"Unexpected context description on returned context", (Object)(t2.context0_Descr + "Changed"), (Object)context.getDescription());
        Assert.assertEquals((String)"Unexpected contex active state", (Object)false, (Object)context.isActive());
        try {
            this.ruleManagementService.updateContext(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: context is null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteContext() {
        RuleManagementBaseTestObjectNames t3 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t3");
        ContextDefinition context = this.buildTestContext(t3.object0);
        context = this.ruleManagementService.getContext(t3.context0_Id);
        Assert.assertEquals((String)"Unexpected contex name returned ", (Object)t3.context0_Name, (Object)context.getName());
        try {
            this.ruleManagementService.deleteContext(t3.context0_Id);
            Assert.fail((String)"Should have thrown RiceIllegalArgumentException: not implemented yet");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetContext() {
        RuleManagementBaseTestObjectNames t4 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t4");
        this.buildTestContext(t4.object0);
        ContextDefinition context = this.ruleManagementService.getContext(t4.context0_Id);
        Assert.assertEquals((String)"Unexpected contex name returned ", (Object)t4.context0_Name, (Object)context.getName());
        Assert.assertNull((String)"Should be null", (Object)this.ruleManagementService.getContext(null));
        Assert.assertNull((String)"Should be null", (Object)this.ruleManagementService.getContext("   "));
        Assert.assertNull((String)"Should be null", (Object)this.ruleManagementService.getContext("badValue"));
    }

    @Test
    public void testGetContextByNameAndNamespace() {
        RuleManagementBaseTestObjectNames t5 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t5");
        this.buildTestContext(t5.object0);
        ContextDefinition context = this.ruleManagementService.getContextByNameAndNamespace(t5.context0_Name, t5.namespaceName);
        Assert.assertEquals((String)"Unexpected namespace on created context", (Object)t5.namespaceName, (Object)context.getNamespace());
        Assert.assertEquals((String)"Unexpected name on created context", (Object)t5.context0_Name, (Object)context.getName());
        try {
            this.ruleManagementService.getContextByNameAndNamespace(null, t5.namespaceName);
            Assert.fail((String)"Should have thrown IllegalArgumentException: name is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.getContextByNameAndNamespace(null, t5.namespaceName);
            Assert.fail((String)"Should have thrown IllegalArgumentException: namespace is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.getContextByNameAndNamespace("  ", t5.namespaceName);
            Assert.fail((String)"Should have thrown IllegalArgumentException: name is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.getContextByNameAndNamespace(t5.context0_Name, "  ");
            Assert.fail((String)"Should have thrown IllegalArgumentException: namespace is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertNull((String)"Should be null", (Object)this.ruleManagementService.getContextByNameAndNamespace("badValue", t5.namespaceName));
        Assert.assertNull((String)"Should be null", (Object)this.ruleManagementService.getContextByNameAndNamespace(t5.context0_Name, "badValue"));
    }

    @Test
    public void testFindContextIds() {
        RuleManagementBaseTestObjectNames t6 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t6");
        this.buildTestContext(t6.object0);
        this.buildTestContext(t6.object1);
        this.buildTestContext(t6.object2);
        this.buildTestContext(t6.object3);
        List<String> contextIds = Arrays.asList(t6.context0_Id, t6.context1_Id, t6.context2_Id, t6.context3_Id);
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.in((String)"id", (Object[])contextIds.toArray(new String[0]))});
        List foundIds = this.ruleManagementService.findContextIds(builder.build());
        Assert.assertEquals((String)"Should of found 4 contexts", (long)4L, (long)foundIds.size());
        for (String contactId : contextIds) {
            Assert.assertTrue((String)"Should have only these ids", (boolean)foundIds.contains(contactId));
        }
        try {
            this.ruleManagementService.findContextIds(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: criteria is null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

