/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.junit.Before;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeAttribute;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.impl.repository.ContextAttributeBo;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.ContextBoService;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.test.KRMSTestCase;
import org.kuali.rice.test.BaselineTestCase;
import org.springframework.util.CollectionUtils;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK)
public abstract class AbstractBoTest
extends KRMSTestCase {
    protected ContextBoService contextRepository;
    protected KrmsTypeRepositoryService krmsTypeRepository;
    protected KrmsAttributeDefinitionService krmsAttributeDefinitionService;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.contextRepository = KrmsRepositoryServiceLocator.getContextBoService();
        this.krmsTypeRepository = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService();
        this.krmsAttributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
    }

    protected BusinessObjectService getBoService() {
        return KNSServiceLocator.getBusinessObjectService();
    }

    protected DataObjectService getDataObjectService() {
        return KRADServiceLocator.getDataObjectService();
    }

    protected ContextDefinition createContextDefinition(String nameSpace, String name, Map<String, String> contextAttributes) {
        KrmsTypeDefinition krmsContextTypeDefinition;
        ArrayList<KrmsTypeAttribute.Builder> contextAttributeBuilders = new ArrayList<KrmsTypeAttribute.Builder>();
        int contextAttrSequenceIndex = 0;
        ArrayList<KrmsAttributeDefinition> attributeDefintions = new ArrayList<KrmsAttributeDefinition>();
        if (contextAttributes != null) {
            for (Map.Entry<String, String> entry : contextAttributes.entrySet()) {
                KrmsAttributeDefinition.Builder contextTypeAttributeDefnBuilder = KrmsAttributeDefinition.Builder.create(null, (String)entry.getKey(), (String)nameSpace);
                contextTypeAttributeDefnBuilder.setLabel(entry.getKey() + " attribute label");
                KrmsAttributeDefinition contextTypeAttributeDefinition = this.krmsAttributeDefinitionService.createAttributeDefinition(contextTypeAttributeDefnBuilder.build());
                attributeDefintions.add(contextTypeAttributeDefinition);
                contextAttributeBuilders.add(KrmsTypeAttribute.Builder.create(null, (String)contextTypeAttributeDefinition.getId(), (Integer)contextAttrSequenceIndex));
                ++contextAttrSequenceIndex;
            }
        }
        if ((krmsContextTypeDefinition = this.krmsTypeRepository.getTypeByName(nameSpace, "KrmsTestContextType")) == null) {
            KrmsTypeDefinition.Builder krmsContextTypeDefnBuilder = KrmsTypeDefinition.Builder.create((String)"KrmsTestContextType", (String)nameSpace);
            krmsContextTypeDefnBuilder.setAttributes(contextAttributeBuilders);
            krmsContextTypeDefinition = krmsContextTypeDefnBuilder.build();
            krmsContextTypeDefinition = this.krmsTypeRepository.createKrmsType(krmsContextTypeDefinition);
        }
        ContextDefinition.Builder contextBuilder = ContextDefinition.Builder.create((String)nameSpace, (String)name);
        contextBuilder.setTypeId(krmsContextTypeDefinition.getId());
        ContextDefinition contextDefinition = contextBuilder.build();
        contextDefinition = this.contextRepository.createContext(contextDefinition);
        for (KrmsAttributeDefinition contextTypeAttributeDefinition : attributeDefintions) {
            ContextAttributeBo contextAttribute = new ContextAttributeBo();
            contextAttribute.setAttributeDefinition(KrmsAttributeDefinitionBo.from((KrmsAttributeDefinition)contextTypeAttributeDefinition));
            contextAttribute.setContext(ContextBo.from((ContextDefinition)contextDefinition));
            contextAttribute.setValue(contextAttributes.get(contextTypeAttributeDefinition.getName()));
            contextAttribute = (ContextAttributeBo)this.getDataObjectService().save((Object)contextAttribute, new PersistenceOption[0]);
        }
        return contextDefinition;
    }

    protected KrmsTypeDefinition createKrmsGenericTypeDefinition(String nameSpace, String serviceName, String attributeDefinitionLabel, String attributeDefinitionName) {
        KrmsTypeDefinition krmsGenericTypeDefinition = this.krmsTypeRepository.getTypeByName(nameSpace, "KrmsTestGenericType");
        if (null == krmsGenericTypeDefinition) {
            KrmsAttributeDefinition.Builder genericTypeAttributeDefnBuilder = KrmsAttributeDefinition.Builder.create(null, (String)attributeDefinitionName, (String)nameSpace);
            genericTypeAttributeDefnBuilder.setLabel(attributeDefinitionLabel);
            KrmsAttributeDefinition genericTypeAttributeDefinition1 = this.krmsAttributeDefinitionService.createAttributeDefinition(genericTypeAttributeDefnBuilder.build());
            KrmsTypeAttribute.Builder genericTypeAttrBuilder = KrmsTypeAttribute.Builder.create(null, (String)genericTypeAttributeDefinition1.getId(), (Integer)1);
            KrmsTypeDefinition.Builder krmsGenericTypeDefnBuilder = KrmsTypeDefinition.Builder.create((String)"KrmsTestGenericType", (String)nameSpace);
            krmsGenericTypeDefnBuilder.setServiceName(serviceName);
            krmsGenericTypeDefnBuilder.setAttributes(Collections.singletonList(genericTypeAttrBuilder));
            krmsGenericTypeDefinition = this.krmsTypeRepository.createKrmsType(krmsGenericTypeDefnBuilder.build());
        }
        return krmsGenericTypeDefinition;
    }

    public String getNamespaceByContextName(String name) {
        QueryByCriteria contextCrit = QueryByCriteria.Builder.forAttribute((String)"name", (Object)name).build();
        QueryResults results = this.getDataObjectService().findMatching(ContextBo.class, contextCrit);
        if (CollectionUtils.isEmpty((Collection)results.getResults())) {
            return null;
        }
        if (results.getResults().size() != 1) {
            throw new IllegalStateException("getNamespaceByContextName can't handle a universe where multiple contexts have the same name");
        }
        return ((ContextBo)results.getResults().iterator().next()).getNamespace();
    }

    public ContextBoService getContextRepository() {
        return this.contextRepository;
    }

    public KrmsTypeRepositoryService getKrmsTypeRepository() {
        return this.krmsTypeRepository;
    }

    public KrmsAttributeDefinitionService getKrmsAttributeDefinitionService() {
        return this.krmsAttributeDefinitionService;
    }
}

