/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.term.TermDefinition;
import org.kuali.rice.krms.api.repository.term.TermDefinitionContract;
import org.kuali.rice.krms.api.repository.term.TermParameterDefinition;
import org.kuali.rice.krms.api.repository.term.TermResolverDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinitionContract;
import org.kuali.rice.krms.api.repository.type.KrmsTypeBoService;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.impl.repository.ContextBoService;
import org.kuali.rice.krms.impl.repository.ContextBoServiceImpl;
import org.kuali.rice.krms.impl.repository.KrmsTypeBoServiceImpl;
import org.kuali.rice.krms.impl.repository.TermBoService;
import org.kuali.rice.krms.impl.repository.TermBoServiceImpl;
import org.kuali.rice.krms.test.AbstractBoTest;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class TermRelatedBoTest
extends AbstractBoTest {
    private TermBoService termBoService;
    private ContextBoService contextRepository;
    private KrmsTypeBoService krmsTypeBoService;

    @Before
    public void setup() {
        this.termBoService = new TermBoServiceImpl();
        ((TermBoServiceImpl)this.termBoService).setDataObjectService((DataObjectService)GlobalResourceLoader.getService((String)"dataObjectService"));
        this.contextRepository = new ContextBoServiceImpl();
        ((ContextBoServiceImpl)this.contextRepository).setDataObjectService(this.getDataObjectService());
        this.krmsTypeBoService = new KrmsTypeBoServiceImpl();
        ((KrmsTypeBoServiceImpl)this.krmsTypeBoService).setDataObjectService(this.getDataObjectService());
    }

    @Test
    public void creationTest() {
        ContextDefinition contextDefinition = this.createContext();
        KrmsTypeDefinition krmsTermResolverTypeDefinition = this.createTermResolverType();
        TermSpecificationDefinition outputTermSpec = TermSpecificationDefinition.Builder.create(null, (String)"outputTermSpec", (String)contextDefinition.getId(), (String)"java.lang.String").build();
        outputTermSpec = this.termBoService.createTermSpecification(outputTermSpec);
        TermSpecificationDefinition prereqTermSpec = TermSpecificationDefinition.Builder.create(null, (String)"prereqTermSpec", (String)contextDefinition.getId(), (String)"java.lang.String").build();
        prereqTermSpec = this.termBoService.createTermSpecification(prereqTermSpec);
        TermResolverDefinition termResolverDef = TermResolverDefinition.Builder.create(null, (String)"KRMS", (String)"testResolver", (String)krmsTermResolverTypeDefinition.getId(), (TermSpecificationDefinition.Builder)TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)outputTermSpec), Collections.singleton(TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)prereqTermSpec)), null, Collections.singleton("testParamName")).build();
        termResolverDef = this.termBoService.createTermResolver(termResolverDef);
        TermParameterDefinition.Builder termParamBuilder = TermParameterDefinition.Builder.create(null, null, (String)"testParamName", (String)"testParamValue");
        TermDefinition termDefinition = TermDefinition.Builder.create(null, (TermSpecificationDefinition.Builder)TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)outputTermSpec), Collections.singletonList(termParamBuilder)).build();
        this.termBoService.createTerm(termDefinition);
    }

    @Test
    public void updateTermChangeParameterTest() {
        TermDefinition termDefinition = this.createTermForUpdate();
        TermDefinition.Builder updateTermBuilder = TermDefinition.Builder.create((TermDefinitionContract)termDefinition);
        updateTermBuilder.setDescription("updated description");
        Assert.assertTrue((updateTermBuilder.getParameters().size() == 1 ? 1 : 0) != 0);
        ((TermParameterDefinition.Builder)updateTermBuilder.getParameters().get(0)).setValue("updatedParamValue");
        this.termBoService.updateTerm(updateTermBuilder.build());
        TermDefinition updatedTerm = this.termBoService.getTerm(termDefinition.getId());
        Assert.assertFalse((String)"descriptions should not be equal after update", (boolean)updatedTerm.getDescription().equals(termDefinition.getDescription()));
        Assert.assertTrue((updatedTerm.getParameters().size() == 1 ? 1 : 0) != 0);
        TermParameterDefinition updatedParam = (TermParameterDefinition)updatedTerm.getParameters().get(0);
        Assert.assertTrue((boolean)updatedParam.getValue().equals("updatedParamValue"));
    }

    @Test
    public void updateTermReplaceParameterTest() {
        TermDefinition termDefinition = this.createTermForUpdate();
        TermDefinition.Builder updateTermBuilder = TermDefinition.Builder.create((TermDefinitionContract)termDefinition);
        updateTermBuilder.setDescription("updated description");
        Assert.assertTrue((updateTermBuilder.getParameters().size() == 1 ? 1 : 0) != 0);
        updateTermBuilder.getParameters().clear();
        updateTermBuilder.getParameters().add(TermParameterDefinition.Builder.create(null, (String)termDefinition.getId(), (String)"secondParamName", (String)"secondParamValue"));
        this.termBoService.updateTerm(updateTermBuilder.build());
        TermDefinition updatedTerm = this.termBoService.getTerm(termDefinition.getId());
        Assert.assertFalse((String)"descriptions should not be equal after update", (boolean)updatedTerm.getDescription().equals(termDefinition.getDescription()));
        Assert.assertTrue((updatedTerm.getParameters().size() == 1 ? 1 : 0) != 0);
        TermParameterDefinition secondParam = (TermParameterDefinition)updatedTerm.getParameters().get(0);
        Assert.assertTrue((boolean)secondParam.getValue().equals("secondParamValue"));
    }

    private ContextDefinition createContext() {
        KrmsTypeDefinition krmsContextTypeDefinition = KrmsTypeDefinition.Builder.create((String)"KrmsTestContextType", (String)"KRMS").build();
        krmsContextTypeDefinition = this.krmsTypeBoService.createKrmsType(krmsContextTypeDefinition);
        ContextDefinition.Builder contextBuilder = ContextDefinition.Builder.create((String)"KRMS", (String)"testContext");
        contextBuilder.setTypeId(krmsContextTypeDefinition.getId());
        ContextDefinition contextDefinition = contextBuilder.build();
        contextDefinition = this.contextRepository.createContext(contextDefinition);
        return contextDefinition;
    }

    private TermDefinition createTermForUpdate() {
        ContextDefinition contextDefinition = this.createContext();
        TermSpecificationDefinition termSpec = TermSpecificationDefinition.Builder.create(null, (String)"TermUpdateTestTermSpec", (String)contextDefinition.getId(), (String)"java.lang.String").build();
        termSpec = this.termBoService.createTermSpecification(termSpec);
        List<TermParameterDefinition.Builder> paramBuilders = Arrays.asList(TermParameterDefinition.Builder.create(null, null, (String)"paramName", (String)"paramValue"));
        TermDefinition termDefinition = TermDefinition.Builder.create(null, (TermSpecificationDefinition.Builder)TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)termSpec), paramBuilders).build();
        termDefinition = this.termBoService.createTerm(termDefinition);
        return termDefinition;
    }

    private KrmsTypeDefinition createTermResolverType() {
        KrmsTypeDefinition krmsTermResolverTypeDefinition = KrmsTypeDefinition.Builder.create((String)"KrmsTestResolverType", (String)"KRMS").build();
        krmsTermResolverTypeDefinition = this.krmsTypeBoService.createKrmsType(krmsTermResolverTypeDefinition);
        return krmsTermResolverTypeDefinition;
    }
}

