/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.messaging.AsynchronousCallback;
import org.kuali.rice.ksb.messaging.ClientAppServiceSharedPayloadObj;
import org.kuali.rice.ksb.messaging.KSBTestUtils;
import org.kuali.rice.ksb.messaging.callbacks.SimpleCallback;
import org.kuali.rice.ksb.messaging.service.KSBJavaService;
import org.kuali.rice.ksb.test.KSBTestCase;

public class ContextObjectMessagingTest
extends KSBTestCase {
    @Override
    public boolean startClient1() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallingQueueAsnyc() throws Exception {
        KSBTestUtils.setMessagingToAsync();
        QName serviceName = new QName("testAppsSharedQueue", "sharedQueue");
        String contextObject = "my_context_object";
        SimpleCallback callback = new SimpleCallback();
        KSBJavaService testJavaAsyncService = (KSBJavaService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(serviceName, (AsynchronousCallback)callback, (Serializable)((Object)contextObject));
        SimpleCallback simpleCallback = callback;
        synchronized (simpleCallback) {
            testJavaAsyncService.invoke((Serializable)new ClientAppServiceSharedPayloadObj("message content", false));
            callback.waitForAsyncCall();
        }
        Serializable contextAfterMessaging = callback.getMethodCall().getContext();
        Assert.assertEquals((Object)contextObject, (Object)contextAfterMessaging);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallingAsyncTopics() throws Exception {
        KSBTestUtils.setMessagingToAsync();
        QName serviceName = new QName("testAppsSharedTopic", "sharedTopic");
        SimpleCallback callback = new SimpleCallback();
        String contextObject = "my_context_object";
        KSBJavaService testJavaAsyncService = (KSBJavaService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(serviceName, (AsynchronousCallback)callback, (Serializable)((Object)contextObject));
        SimpleCallback simpleCallback = callback;
        synchronized (simpleCallback) {
            testJavaAsyncService.invoke((Serializable)new ClientAppServiceSharedPayloadObj("message content", false));
            callback.waitForAsyncCall();
        }
        Serializable contextAfterMessaging = callback.getMethodCall().getContext();
        Assert.assertEquals((Object)contextObject, (Object)contextAfterMessaging);
    }
}

