/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.io.Serializable;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.messaging.AsynchronousCallback;
import org.kuali.rice.ksb.messaging.ClientAppServiceSharedPayloadObj;
import org.kuali.rice.ksb.messaging.KSBTestUtils;
import org.kuali.rice.ksb.messaging.bam.BAMTargetEntry;
import org.kuali.rice.ksb.messaging.bam.service.BAMService;
import org.kuali.rice.ksb.messaging.callbacks.SimpleCallback;
import org.kuali.rice.ksb.messaging.service.KSBJavaService;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.kuali.rice.ksb.test.KSBTestCase;

public class DistributedQueueTest
extends KSBTestCase {
    private static final Logger LOG = Logger.getLogger(DistributedQueueTest.class);

    @Override
    public boolean startClient1() {
        return true;
    }

    @Override
    public boolean startClient2() {
        return true;
    }

    @Test
    public void testSuccessfullyCallingQueueOnce() throws Exception {
        QName serviceName = new QName("testAppsSharedQueue", "sharedQueue");
        KSBJavaService testJavaAsyncService = (KSBJavaService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(serviceName);
        testJavaAsyncService.invoke((Serializable)new ClientAppServiceSharedPayloadObj("message content", false));
        this.verifyServiceCalls(serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallingQueueAsnyc() throws Exception {
        KSBTestUtils.setMessagingToAsync();
        for (int i = 0; i < 100; ++i) {
            LOG.info((Object)("testCallingQueueAsnyc, iteration: " + i));
            QName serviceName = new QName("testAppsSharedQueue", "sharedQueue");
            SimpleCallback callback = new SimpleCallback();
            KSBJavaService testJavaAsyncService = (KSBJavaService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(serviceName, (AsynchronousCallback)callback);
            SimpleCallback simpleCallback = callback;
            synchronized (simpleCallback) {
                testJavaAsyncService.invoke((Serializable)new ClientAppServiceSharedPayloadObj("message content", false));
                callback.waitForAsyncCall();
            }
            this.verifyServiceCalls(serviceName);
            KSBServiceLocator.getBAMService().clearBAMTables();
        }
    }

    private void verifyServiceCalls(QName serviceName) throws Exception {
        BAMService bamService = KSBServiceLocator.getBAMService();
        List bamCalls = bamService.getCallsForService(serviceName);
        Assert.assertTrue((String)"No service call recorded", (bamCalls.size() > 0 ? 1 : 0) != 0);
        boolean foundClientCall = false;
        boolean foundServiceCall = false;
        for (BAMTargetEntry bamEntry : bamCalls) {
            if (bamEntry.getServerInvocation().booleanValue()) {
                foundServiceCall = true;
                continue;
            }
            foundClientCall = true;
        }
        Assert.assertTrue((String)"No client call recorded", (boolean)foundClientCall);
        Assert.assertTrue((String)"No service call recorded", (boolean)foundServiceCall);
        Assert.assertEquals((String)"Wrong number of calls recorded", (long)2L, (long)bamCalls.size());
    }
}

