/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ksb.api.bus.support.JavaServiceDefinition;
import org.kuali.rice.ksb.api.bus.support.RestServiceDefinition;
import org.kuali.rice.ksb.test.KSBTestCase;

public class RestServiceDefinitionTest
extends KSBTestCase {
    private RestServiceDefinition restDefinition;
    private RestServiceDefinition sameExactRestDefinition;
    private RestServiceDefinition otherRestDefinition;
    private RestServiceDefinition otherNameRestDefinition;
    private RestServiceDefinition otherServiceRestDefinition;
    private RestServiceDefinition singleResourceDefinition;
    private JavaServiceDefinition javaServiceDefinition;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        String a = "a";
        String b = "b";
        String c = "c";
        Long l = 123L;
        ArrayList<String> restResources = new ArrayList<String>();
        restResources.add(a);
        restResources.add(b);
        ArrayList<String> sameExactRestResources = new ArrayList<String>();
        sameExactRestResources.add(a);
        sameExactRestResources.add(b);
        ArrayList<String> functionallySameResources = new ArrayList<String>();
        functionallySameResources.add(b);
        functionallySameResources.add(c);
        ArrayList<Object> otherRestResources = new ArrayList<Object>();
        otherRestResources.add(l);
        otherRestResources.add(b);
        ArrayList service = new ArrayList();
        this.restDefinition = new RestServiceDefinition();
        this.restDefinition.setLocalServiceName("restServiceName");
        this.restDefinition.setResources(restResources);
        this.restDefinition.validate();
        this.sameExactRestDefinition = new RestServiceDefinition();
        this.sameExactRestDefinition.setLocalServiceName("restServiceName");
        this.sameExactRestDefinition.setResources(sameExactRestResources);
        this.sameExactRestDefinition.validate();
        this.otherRestDefinition = new RestServiceDefinition();
        this.otherRestDefinition.setLocalServiceName("restServiceName");
        this.otherRestDefinition.setResources(otherRestResources);
        this.otherRestDefinition.validate();
        this.otherNameRestDefinition = new RestServiceDefinition();
        this.otherNameRestDefinition.setLocalServiceName("anotherRestServiceName");
        this.otherNameRestDefinition.setResources(sameExactRestResources);
        this.otherNameRestDefinition.validate();
        this.otherServiceRestDefinition = new RestServiceDefinition();
        this.otherServiceRestDefinition.setLocalServiceName("restServiceName");
        this.otherServiceRestDefinition.setService(service);
        this.otherServiceRestDefinition.setResources(restResources);
        this.otherServiceRestDefinition.validate();
        this.singleResourceDefinition = new RestServiceDefinition();
        this.singleResourceDefinition.setLocalServiceName("restServiceName");
        this.singleResourceDefinition.setService(service);
        this.singleResourceDefinition.validate();
        this.javaServiceDefinition = new JavaServiceDefinition();
        this.javaServiceDefinition.setBusSecurity(Boolean.FALSE);
        this.javaServiceDefinition.setLocalServiceName("restServiceName");
        this.javaServiceDefinition.setService(service);
        this.javaServiceDefinition.validate();
    }

    @Test
    public void testIsSameSuccessWithSameDefinition() {
        Assert.assertTrue((boolean)this.restDefinition.equals((Object)this.restDefinition));
    }

    @Test
    public void testIsSameSuccessWithDifferentDefinition() throws Exception {
        Assert.assertTrue((boolean)this.restDefinition.equals((Object)this.sameExactRestDefinition));
    }

    @Test
    public void testIsSameFailureWithDifferentServiceClass() throws Exception {
        Assert.assertFalse((boolean)this.restDefinition.equals((Object)this.otherRestDefinition));
    }

    @Test
    public void testIsSameFailureWithDifferentDefinitionOfSameResources() throws Exception {
        Assert.assertFalse((boolean)this.restDefinition.equals((Object)this.otherNameRestDefinition));
    }

    @Test
    public void testIsSameFailureWithDifferentService() throws Exception {
        Assert.assertFalse((boolean)this.restDefinition.equals((Object)this.otherServiceRestDefinition));
    }

    @Test
    public void testIsSameFailureWithSingleResourceService() throws Exception {
        Assert.assertFalse((boolean)this.restDefinition.equals((Object)this.singleResourceDefinition));
    }

    @Test
    public void testIsSameFailureWithDifferentServiceDefinitionType() throws Exception {
        Assert.assertFalse((boolean)this.otherServiceRestDefinition.equals((Object)this.javaServiceDefinition));
    }
}

