/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.io.Serializable;
import java.util.List;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.messaging.AsynchronousCallback;
import org.kuali.rice.ksb.messaging.KSBTestUtils;
import org.kuali.rice.ksb.messaging.MessagingTestObject;
import org.kuali.rice.ksb.messaging.bam.BAMTargetEntry;
import org.kuali.rice.ksb.messaging.bam.service.BAMService;
import org.kuali.rice.ksb.messaging.callbacks.SimpleCallback;
import org.kuali.rice.ksb.messaging.service.KSBJavaService;
import org.kuali.rice.ksb.messaging.service.KSBXMLService;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.kuali.rice.ksb.test.KSBTestCase;

public class SimpleServiceCallTest
extends KSBTestCase {
    @Override
    public boolean startClient1() {
        return true;
    }

    @Test
    public void testToStringOnService() {
        KSBTestUtils.setMessagingToAsync();
        QName serviceName = new QName("TestCl1", "testJavaAsyncService");
        SimpleCallback callback = new SimpleCallback();
        KSBJavaService testJavaAsyncService = (KSBJavaService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(serviceName, (AsynchronousCallback)callback);
        String toStringValue = testJavaAsyncService.toString();
        System.out.println("toString value on async service: " + toStringValue);
        Assert.assertTrue((String)("toString should have started with 'Service call proxy' but was instead: " + toStringValue), (boolean)toStringValue.startsWith("Service call proxy"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncJavaCall() throws Exception {
        KSBTestUtils.setMessagingToAsync();
        QName serviceName = new QName("TestCl1", "testJavaAsyncService");
        SimpleCallback callback = new SimpleCallback();
        KSBJavaService testJavaAsyncService = (KSBJavaService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(serviceName, (AsynchronousCallback)callback);
        SimpleCallback simpleCallback = callback;
        synchronized (simpleCallback) {
            testJavaAsyncService.invoke((Serializable)new MessagingTestObject("message content"));
            callback.waitForAsyncCall();
        }
        this.verifyServiceCalls(serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncXmlCall() throws Exception {
        KSBTestUtils.setMessagingToAsync();
        QName serviceName = new QName("TestCl1", "testXmlAsyncService");
        SimpleCallback callback = new SimpleCallback();
        KSBXMLService testXmlAsyncService = (KSBXMLService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(serviceName, (AsynchronousCallback)callback);
        SimpleCallback simpleCallback = callback;
        synchronized (simpleCallback) {
            testXmlAsyncService.invoke("message content");
            callback.waitForAsyncCall();
        }
        this.verifyServiceCalls(serviceName);
    }

    private void verifyServiceCalls(QName serviceName) throws Exception {
        BAMService bamService = KSBServiceLocator.getBAMService();
        List bamCalls = bamService.getCallsForService(serviceName);
        Assert.assertTrue((String)"No service call recorded", (bamCalls.size() > 0 ? 1 : 0) != 0);
        boolean foundClientCall = false;
        boolean foundServiceCall = false;
        for (BAMTargetEntry bamEntry : bamCalls) {
            if (bamEntry.getServerInvocation().booleanValue()) {
                foundServiceCall = true;
                continue;
            }
            foundClientCall = true;
        }
        Assert.assertTrue((String)"No client call recorded", (boolean)foundClientCall);
        Assert.assertTrue((String)"No service call recorded", (boolean)foundServiceCall);
    }
}

