/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.net.URL;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ksb.api.bus.support.JavaServiceDefinition;
import org.kuali.rice.ksb.api.bus.support.SoapServiceDefinition;
import org.kuali.rice.ksb.test.KSBTestCase;

public class SoapServiceDefinitionTest
extends KSBTestCase {
    private SoapServiceDefinition soapDefinition;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.soapDefinition = new SoapServiceDefinition();
        this.soapDefinition.setLocalServiceName("testServiceName");
        this.soapDefinition.setEndpointUrl(new URL("http://www.rutgers.edu"));
        this.soapDefinition.setService(new ArrayList());
        this.soapDefinition.validate();
    }

    @Test
    public void testIsSameSuccessWithSameDefinition() {
        Assert.assertTrue((boolean)this.soapDefinition.equals((Object)this.soapDefinition));
    }

    @Test
    public void testIsSameSuccessWithDifferentDefinition() throws Exception {
        SoapServiceDefinition soapServiceDefinition = new SoapServiceDefinition();
        soapServiceDefinition.setLocalServiceName("testServiceName");
        soapServiceDefinition.setEndpointUrl(new URL("http://www.rutgers.edu"));
        soapServiceDefinition.setService(new ArrayList());
        soapServiceDefinition.validate();
        Assert.assertTrue((boolean)this.soapDefinition.equals((Object)soapServiceDefinition));
    }

    @Test
    public void testIsSameFailureWithDifferentClass() throws Exception {
        JavaServiceDefinition javaServiceDefinition = new JavaServiceDefinition();
        javaServiceDefinition.setBusSecurity(Boolean.FALSE);
        javaServiceDefinition.setLocalServiceName("testServiceName");
        javaServiceDefinition.setEndpointUrl(new URL("http://www.rutgers.edu"));
        javaServiceDefinition.setService(new ArrayList());
        javaServiceDefinition.validate();
        Assert.assertFalse((boolean)this.soapDefinition.equals((Object)javaServiceDefinition));
    }
}

