/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.ServiceBus;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.messaging.remotedservices.GenericTestService;
import org.kuali.rice.ksb.messaging.remotedservices.TestServiceInterface;
import org.kuali.rice.ksb.messaging.serviceconnectors.BusLocalConnector;
import org.kuali.rice.ksb.messaging.serviceconnectors.ServiceConnector;
import org.kuali.rice.ksb.messaging.serviceconnectors.ServiceConnectorFactory;
import org.kuali.rice.ksb.test.KSBTestCase;

public class DevModeTest
extends KSBTestCase {
    @Override
    public void setUp() throws Exception {
        System.setProperty("a.test.specific.config.location", "classpath:org/kuali/rice/ksb/messaging/dev_mode_config.xml");
        super.setUp();
    }

    public void tearDown() throws Exception {
        try {
            System.clearProperty("a.test.specific.config.location");
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testCallInDevMode() throws Exception {
        junit.framework.Assert.assertEquals((Object)ConfigContext.getCurrentContextConfig().getDevMode(), (Object)Boolean.TRUE);
        QName serviceName = new QName("KEW", "testLocalServiceFavoriteCall");
        TestServiceInterface service = (TestServiceInterface)GlobalResourceLoader.getService((QName)serviceName);
        service.invoke();
        Assert.assertTrue((String)"No calls to dev defined service", (GenericTestService.NUM_CALLS > 0 ? 1 : 0) != 0);
        ServiceBus serviceBus = KsbApiServiceLocator.getServiceBus();
        ServiceConnector serviceConnector = ServiceConnectorFactory.getServiceConnector((ServiceConfiguration)serviceBus.getLocalEndpoint(serviceName).getServiceConfiguration());
        Assert.assertTrue((String)"Not BusLocalConnector", (boolean)(serviceConnector instanceof BusLocalConnector));
        service = (TestServiceInterface)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(serviceName);
        service.invoke();
        Assert.assertTrue((String)"No calls to dev defined service", (GenericTestService.NUM_CALLS > 1 ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((String)"should be no registered services", (int)KsbApiServiceLocator.getServiceRegistry().getAllServices().size(), (int)0);
    }
}

