/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.io.Serializable;
import java.util.List;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.messaging.GlobalCallbackRegistry;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.TestCallback;
import org.kuali.rice.ksb.messaging.remotedservices.TestHarnessExplodingQueue;
import org.kuali.rice.ksb.messaging.service.KSBJavaService;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.kuali.rice.ksb.test.KSBTestCase;
import org.kuali.rice.test.TestUtilities;

public class ExceptionRetryCountTest
extends KSBTestCase {
    private QName retryCountServiceName = new QName("KEW", "testExplodingRetryCount");
    private TestCallback callback = new TestCallback();

    @Override
    public void setUp() throws Exception {
        System.setProperty("RouteQueue.timeIncrement", "500");
        System.setProperty("RouteQueue.maxRetryAttempts", "2");
        super.setUp();
        GlobalCallbackRegistry.getCallbacks().clear();
        GlobalCallbackRegistry.getCallbacks().add(this.callback);
        TestCallback.clearCallbacks();
        TestHarnessExplodingQueue.NUM_CALLS = 0;
    }

    public void tearDown() throws Exception {
        try {
            KSBServiceLocator.getScheduler().shutdown();
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testRetryCount() throws Exception {
        PersistedMessageBO message;
        ConfigContext.getCurrentContextConfig().putProperty("RouteQueue.timeIncrement", "10000");
        KSBJavaService explodingQueue = (KSBJavaService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(this.retryCountServiceName);
        explodingQueue.invoke((Serializable)((Object)""));
        TestUtilities.waitForExceptionRouting();
        this.callback.pauseUntilNumberCallbacksUsingStaticCounter(3, this.retryCountServiceName);
        int i = 0;
        while (i++ < 30) {
            List queuedItems = KSBServiceLocator.getMessageQueueService().findAll();
            if (queuedItems.size() != 1) {
                Assert.fail((String)("test setup wrong should have a single item in the queue but instead had " + queuedItems.size() + "."));
            }
            if ((message = (PersistedMessageBO)queuedItems.get(0)).getQueueStatus().equals("E")) break;
            System.out.println("Message not saved to queue in 'E' status.  Sleeping 1 sec.");
            Thread.sleep(1000L);
        }
        Assert.assertEquals((String)"Service should have been called 3 times", (long)3L, (long)TestHarnessExplodingQueue.NUM_CALLS);
        List messagesQueued = KSBServiceLocator.getMessageQueueService().findByServiceName(this.retryCountServiceName, "invoke");
        message = (PersistedMessageBO)messagesQueued.get(0);
        Assert.assertEquals((String)"Message should be in exception status", (Object)"E", (Object)message.getQueueStatus());
        Assert.assertEquals((String)"Message retry count not what was configured", (Object)new Integer(2), (Object)message.getRetryCount());
    }
}

