/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.messaging.bam.BAMTargetEntry;
import org.kuali.rice.ksb.messaging.remotedservices.GenericTestService;
import org.kuali.rice.ksb.messaging.remotedservices.SOAPService;
import org.kuali.rice.ksb.messaging.remotedservices.TestServiceInterface;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.kuali.rice.ksb.test.KSBTestCase;

public class ServiceCallClusterTest
extends KSBTestCase {
    private static final int SERVICE_CALLS = 15;

    @Override
    public boolean startClient1() {
        return true;
    }

    @Override
    public boolean startClient2() {
        return true;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        KsbApiServiceLocator.getServiceBus().synchronize();
    }

    @Test
    public void testSOAPClustering() throws Exception {
        QName serviceName = new QName("testNameSpace", "soap-cluster-test");
        ArrayList<SOAPService> services = new ArrayList<SOAPService>();
        for (int i = 0; i < 15; ++i) {
            services.add((SOAPService)GlobalResourceLoader.getService((QName)serviceName));
        }
        for (SOAPService service : services) {
            service.doTheThing("testing one two three");
        }
        String server1Name = "TestClient1";
        String server2Name = "TestClient2";
        boolean server1Called = false;
        boolean server2Called = false;
        List bams = KSBServiceLocator.getBAMService().getCallsForService(serviceName);
        for (BAMTargetEntry bam : bams) {
            System.out.println("Found bam service URL of " + bam.getServiceURL());
            if (bam.getServiceURL().contains(server1Name)) {
                server1Called = true;
                continue;
            }
            if (!bam.getServiceURL().contains(server2Name)) continue;
            server2Called = true;
        }
        Assert.assertTrue((boolean)server1Called);
        Assert.assertTrue((boolean)server2Called);
    }

    @Test
    public void testClustering() throws Exception {
        QName serviceName = new QName("KEW", "testServiceFailover");
        ArrayList<TestServiceInterface> services = new ArrayList<TestServiceInterface>();
        for (int i = 0; i < 15; ++i) {
            services.add((TestServiceInterface)GlobalResourceLoader.getService((QName)serviceName));
        }
        for (TestServiceInterface service : services) {
            service.invoke();
        }
        String server1Name = "TestClient1";
        String server2Name = "TestClient2";
        boolean server1Called = false;
        boolean server2Called = false;
        List bams = KSBServiceLocator.getBAMService().getCallsForService(serviceName);
        for (BAMTargetEntry bam : bams) {
            if (bam.getServiceURL().contains(server1Name)) {
                server1Called = true;
                continue;
            }
            if (!bam.getServiceURL().contains(server2Name)) continue;
            server2Called = true;
        }
        Assert.assertTrue((boolean)server1Called);
        Assert.assertTrue((boolean)server2Called);
    }

    @Test
    public void testServiceFailOver() throws Exception {
        QName serviceName = new QName("KEW", "testServiceFailover");
        ArrayList<TestServiceInterface> services = new ArrayList<TestServiceInterface>();
        for (int i = 0; i < 15; ++i) {
            services.add((TestServiceInterface)GlobalResourceLoader.getService((QName)serviceName));
        }
        String server1Name = "TestClient1";
        String server2Name = "TestClient2";
        boolean server1Called = false;
        boolean server2Called = false;
        try {
            this.getTestClient1().stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (TestServiceInterface service : services) {
            service.invoke();
        }
        List bams = KSBServiceLocator.getBAMService().getCallsForService(serviceName);
        for (BAMTargetEntry bam : bams) {
            if (bam.getServiceURL().contains(server1Name) && bam.getServerInvocation().booleanValue()) {
                server1Called = true;
                continue;
            }
            if (!bam.getServiceURL().contains(server2Name)) continue;
            server2Called = true;
        }
        Assert.assertFalse((String)"server1 should not have been called", (boolean)server1Called);
        Assert.assertTrue((String)"server2 should have been called", (boolean)server2Called);
    }

    @Test
    public void testSOAPFailOver() throws Exception {
        QName serviceName = new QName("testNameSpace", "soap-cluster-test");
        ArrayList<SOAPService> services = new ArrayList<SOAPService>();
        for (int i = 0; i < 15; ++i) {
            services.add((SOAPService)GlobalResourceLoader.getService((QName)serviceName));
        }
        try {
            this.getTestClient1().stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (SOAPService service : services) {
            service.doTheThing("testing one two three");
        }
        String server1Name = "TestClient1";
        String server2Name = "TestClient2";
        boolean server1Called = false;
        boolean server2Called = false;
        List bams = KSBServiceLocator.getBAMService().getCallsForService(serviceName);
        for (BAMTargetEntry bam : bams) {
            if (bam.getServerInvocation().booleanValue() && bam.getServiceURL().contains(server1Name)) {
                server1Called = true;
                continue;
            }
            if (!bam.getServerInvocation().booleanValue() || !bam.getServiceURL().contains(server2Name)) continue;
            server2Called = true;
        }
        Assert.assertFalse((boolean)server1Called);
        Assert.assertTrue((boolean)server2Called);
    }

    @Test
    public void testDefaultToLocalService() throws Exception {
        QName serviceName = new QName("KEW", "testLocalServiceFavoriteCall");
        ArrayList<TestServiceInterface> services = new ArrayList<TestServiceInterface>();
        for (int i = 0; i < 15; ++i) {
            services.add((TestServiceInterface)GlobalResourceLoader.getService((QName)serviceName));
        }
        for (TestServiceInterface service : services) {
            service.invoke();
        }
        String testHarness = "en-test";
        String server1Name = "TestClient1";
        boolean localCalled = false;
        boolean server1Called = false;
        List bams = KSBServiceLocator.getBAMService().getCallsForService(serviceName);
        for (BAMTargetEntry bam : bams) {
            if (bam.getServiceURL().contains(server1Name)) {
                server1Called = true;
                continue;
            }
            if (!bam.getServiceURL().contains(testHarness)) continue;
            localCalled = true;
        }
        Assert.assertFalse((String)"BAM should not have recorded locally called services", (boolean)localCalled);
        Assert.assertFalse((String)"Remotely deployed service should have never been called in favor of remote service", (boolean)server1Called);
        Assert.assertTrue((String)"Service should have been called locally", (GenericTestService.NUM_CALLS > 0 ? 1 : 0) != 0);
    }
}

