/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.test;

import java.util.List;
import javax.xml.namespace.QName;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.framework.resourceloader.SpringResourceLoader;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.server.TestClient1;
import org.kuali.rice.ksb.server.TestClient2;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.runners.LoadTimeWeavableTestRunner;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK)
@RunWith(value=LoadTimeWeavableTestRunner.class)
@org.kuali.rice.test.runners.BootstrapTest(value=BootstrapTest.class)
public abstract class KSBTestCase
extends BaselineTestCase {
    private static final String KSB_MODULE_NAME = "ksb";
    private TestClient1 testClient1;
    private TestClient2 testClient2;
    private ResourceLoader springContextResourceLoader;

    public KSBTestCase() {
        super(KSB_MODULE_NAME);
    }

    public void setUp() throws Exception {
        ConfigContext.destroy();
        System.setProperty("http.keepAlive", "false");
        super.setUp();
        if (this.startClient1() || this.startClient2()) {
            KsbApiServiceLocator.getServiceBus().synchronize();
        }
    }

    protected List<Lifecycle> getPerTestLifecycles() {
        List lifecycles = super.getSuiteLifecycles();
        if (this.disableJta()) {
            System.setProperty("OJB.properties", "RiceNoJtaOJB.properties");
            this.springContextResourceLoader = new SpringResourceLoader(new QName("ksbtestharness"), "KSBTestHarnessNoJtaSpring.xml", null);
        } else {
            this.springContextResourceLoader = new SpringResourceLoader(new QName("ksbtestharness"), "KSBTestHarnessSpring.xml", null);
        }
        lifecycles.add(this.springContextResourceLoader);
        if (this.startClient1()) {
            this.testClient1 = new TestClient1();
            lifecycles.add(this.testClient1);
        }
        if (this.startClient2()) {
            this.testClient2 = new TestClient2();
            lifecycles.add(this.testClient2);
        }
        return lifecycles;
    }

    public boolean startClient1() {
        return false;
    }

    public boolean startClient2() {
        return false;
    }

    public TestClient1 getTestClient1() {
        return this.testClient1;
    }

    public TestClient2 getTestClient2() {
        return this.testClient2;
    }

    public ResourceLoader getSpringContextResourceLoader() {
        return this.springContextResourceLoader;
    }

    public void setSpringContextResourceLoader(ResourceLoader testHarnessResourceLoader) {
        this.springContextResourceLoader = testHarnessResourceLoader;
    }

    protected boolean disableJta() {
        return false;
    }

    public static final class BootstrapTest
    extends KSBTestCase {
        @Test
        public void bootstrapTest() {
        }
    }
}

