/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.messaging.AsynchronousCallback;
import org.kuali.rice.ksb.messaging.ClientAppServiceSharedPayloadObj;
import org.kuali.rice.ksb.messaging.KSBTestUtils;
import org.kuali.rice.ksb.messaging.callbacks.SimpleCallback;
import org.kuali.rice.ksb.messaging.remotedservices.ServiceCallInformationHolder;
import org.kuali.rice.ksb.messaging.service.KSBJavaService;
import org.kuali.rice.ksb.test.KSBTestCase;

public class DistributedTopicTest
extends KSBTestCase {
    @Override
    public boolean startClient1() {
        return true;
    }

    @Test
    public void testSuccessfullyCallingSyncTopics() throws Exception {
        KsbApiServiceLocator.getServiceBus().synchronize();
        QName serviceName = new QName("testAppsSharedTopic", "sharedTopic");
        KSBJavaService testJavaAsyncService = (KSBJavaService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(serviceName);
        testJavaAsyncService.invoke((Serializable)new ClientAppServiceSharedPayloadObj("message content", false));
        Assert.assertTrue((String)"Test harness topic never called", (boolean)ServiceCallInformationHolder.flags.get("TestHarnessCalled"));
        Assert.assertTrue((String)"Client1 app topic never called", (boolean)ServiceCallInformationHolder.flags.get("Client1Called"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallingAsyncTopics() throws Exception {
        KSBTestUtils.setMessagingToAsync();
        QName serviceName = new QName("testAppsSharedTopic", "sharedTopic");
        SimpleCallback simpleCallback = new SimpleCallback();
        KSBJavaService testJavaAsyncService = (KSBJavaService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(serviceName, (AsynchronousCallback)simpleCallback);
        SimpleCallback simpleCallback2 = simpleCallback;
        synchronized (simpleCallback2) {
            testJavaAsyncService.invoke((Serializable)new ClientAppServiceSharedPayloadObj("message content", false));
            simpleCallback.waitForAsyncCall();
        }
        for (int i = 0; i < 100 && ServiceCallInformationHolder.flags.get("Client1Called") == null; ++i) {
            Thread.sleep(1000L);
        }
        Assert.assertTrue((String)"Test harness topic never called", (boolean)ServiceCallInformationHolder.flags.get("TestHarnessCalled"));
        Assert.assertTrue((String)"Client1 app topic never called", (boolean)ServiceCallInformationHolder.flags.get("Client1Called"));
    }
}

