/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.util.List;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.messaging.KSBTestUtils;
import org.kuali.rice.ksb.messaging.bam.BAMTargetEntry;
import org.kuali.rice.ksb.messaging.bam.service.BAMService;
import org.kuali.rice.ksb.messaging.callbacks.SimpleCallback;
import org.kuali.rice.ksb.messaging.remotedservices.SOAPService;
import org.kuali.rice.ksb.messaging.remotedservices.ServiceCallInformationHolder;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.kuali.rice.ksb.test.KSBTestCase;

public class SOAPMessagingTest
extends KSBTestCase {
    @Override
    public boolean startClient1() {
        return true;
    }

    @Test
    public void testSuccessfullyCallingSOAPTopic() throws Exception {
        KsbApiServiceLocator.getServiceBus().synchronize();
        QName serviceName = new QName("testNameSpace", "soap-repeatTopic");
        SOAPService testJavaAsyncService = (SOAPService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(serviceName);
        testJavaAsyncService.doTheThing("The param");
        this.verifyServiceCalls(serviceName);
        Assert.assertTrue((String)"Test harness topic never called", (boolean)ServiceCallInformationHolder.flags.get("TestHarnessCalled"));
        Assert.assertTrue((String)"Cliet1 app topic never called", (boolean)ServiceCallInformationHolder.flags.get("Client1SOAPServiceCalled"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccessfullyCallingSOAPTopicAsync() throws Exception {
        KSBTestUtils.setMessagingToAsync();
        QName serviceName = new QName("testNameSpace", "soap-repeatTopic");
        SimpleCallback callback = new SimpleCallback();
        SOAPService testJavaAsyncService = (SOAPService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(serviceName);
        SimpleCallback simpleCallback = callback;
        synchronized (simpleCallback) {
            testJavaAsyncService.doTheThing("The param");
            callback.waitForAsyncCall(3000L);
        }
        this.verifyServiceCalls(serviceName);
        Assert.assertTrue((String)"Test harness topic never called", (boolean)ServiceCallInformationHolder.flags.get("TestHarnessCalled"));
        Assert.assertTrue((String)"Cliet1 app topic never called", (boolean)ServiceCallInformationHolder.flags.get("Client1SOAPServiceCalled"));
    }

    private void verifyServiceCalls(QName serviceName) throws Exception {
        BAMService bamService = KSBServiceLocator.getBAMService();
        List bamCalls = bamService.getCallsForService(serviceName);
        Assert.assertTrue((String)"No service call recorded", (bamCalls.size() > 0 ? 1 : 0) != 0);
        boolean foundClientCall = false;
        boolean foundServiceCall = false;
        for (BAMTargetEntry bamEntry : bamCalls) {
            if (bamEntry.getServerInvocation().booleanValue()) {
                foundServiceCall = true;
                continue;
            }
            foundClientCall = true;
        }
        Assert.assertTrue((String)"No client call recorded", (boolean)foundClientCall);
        Assert.assertTrue((String)"No service call recorded", (boolean)foundServiceCall);
        Assert.assertEquals((String)"Wrong number of calls recorded", (long)2L, (long)bamCalls.size());
    }
}

