/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.messaging.ClientAppServiceSharedPayloadObj;
import org.kuali.rice.ksb.messaging.KSBTestUtils;
import org.kuali.rice.ksb.messaging.service.KSBJavaService;
import org.kuali.rice.ksb.messaging.serviceproxies.MessageSendingTransactionSynchronization;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.kuali.rice.ksb.test.KSBTestCase;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class TransactionMessagingTest
extends KSBTestCase {
    @Override
    public boolean startClient1() {
        return true;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        MessageSendingTransactionSynchronization.CALLED_TRANS_COMMITTED.set(false);
        MessageSendingTransactionSynchronization.CALLED_TRANS_ROLLEDBACKED.set(false);
    }

    @Test
    public void testMessageSentOnCommittedTransaction() throws Exception {
        KSBTestUtils.setMessagingToAsync();
        KSBServiceLocator.getTransactionTemplate().execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                QName serviceName = new QName("testAppsSharedQueue", "sharedQueue");
                KSBJavaService testJavaAsyncService = (KSBJavaService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(serviceName);
                testJavaAsyncService.invoke((Serializable)new ClientAppServiceSharedPayloadObj("message content", false));
                Assert.assertFalse((boolean)MessageSendingTransactionSynchronization.CALLED_TRANS_COMMITTED.get());
                return null;
            }
        });
        Assert.assertTrue((String)"Message not sent transactionallY", (boolean)MessageSendingTransactionSynchronization.CALLED_TRANS_COMMITTED.get());
    }

    @Test
    public void testMessageNotSentOnRolledBackTransaction() throws Exception {
        KSBTestUtils.setMessagingToAsync();
        KSBServiceLocator.getTransactionTemplate().execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                QName serviceName = new QName("testAppsSharedQueue", "sharedQueue");
                KSBJavaService testJavaAsyncService = (KSBJavaService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(serviceName);
                testJavaAsyncService.invoke((Serializable)new ClientAppServiceSharedPayloadObj("message content", false));
                status.setRollbackOnly();
                Assert.assertFalse((boolean)MessageSendingTransactionSynchronization.CALLED_TRANS_ROLLEDBACKED.get());
                return null;
            }
        });
        Assert.assertFalse((String)"Message not sent transactionallY", (boolean)MessageSendingTransactionSynchronization.CALLED_TRANS_COMMITTED.get());
        Assert.assertTrue((String)"Message not sent transactionallY", (boolean)MessageSendingTransactionSynchronization.CALLED_TRANS_ROLLEDBACKED.get());
    }
}

