/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.quartz;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ksb.quartz.TestJob;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.kuali.rice.ksb.test.KSBTestCase;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.JobDetailImpl;

public class QuartzTest
extends KSBTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSchedulingJob() throws Exception {
        Scheduler scheduler = KSBServiceLocator.getScheduler();
        JobDataMap datMap = new JobDataMap();
        datMap.put("yo", "yo");
        JobDetailImpl jobDetail = new JobDetailImpl("myJob", null, TestJob.class);
        jobDetail.setJobDataMap(datMap);
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
        triggerBuilder.startAt(new Date());
        triggerBuilder.withIdentity("i'm a trigger puller");
        triggerBuilder.usingJobData(datMap);
        triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(1).withIntervalInMilliseconds(1L));
        Trigger trigger = triggerBuilder.build();
        scheduler.scheduleJob((JobDetail)jobDetail, trigger);
        Object object = TestJob.LOCK;
        synchronized (object) {
            TestJob.LOCK.wait(30000L);
        }
        Assert.assertTrue((String)"job never fired", (boolean)TestJob.EXECUTED);
    }
}

