/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.server;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.security.credentials.CredentialsSourceFactory;
import org.kuali.rice.ksb.BaseTestServer;
import org.kuali.rice.ksb.security.credentials.UsernamePasswordCredentialsSource;

public class TestClient1
extends BaseTestServer {
    private static final Logger LOG = Logger.getLogger(TestClient1.class);

    @Override
    protected Server createServer() {
        this.registerTestCredentialsSourceFactory();
        ConfigConstants configConstants = new ConfigConstants();
        Server server = new Server();
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        httpConfig.setSecurePort(configConstants.SERVER_HTTPS_PORT.intValue());
        httpConfig.setOutputBufferSize(32768);
        ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        http.setPort(configConstants.SERVER_HTTP_PORT.intValue());
        http.setIdleTimeout(30000L);
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(configConstants.KEYSTORE_PATH);
        sslContextFactory.setKeyStorePassword(configConstants.KEYSTORE_PASS);
        sslContextFactory.setKeyManagerPassword(configConstants.KEYSTORE_PASS);
        HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
        https.setPort(configConstants.SERVER_HTTPS_PORT.intValue());
        https.setIdleTimeout(500000L);
        server.setConnectors(new Connector[]{http, https});
        URL webRoot = this.getClass().getClassLoader().getResource(configConstants.WEB_ROOT);
        String location = webRoot.getPath();
        LOG.debug((Object)"#####################################");
        LOG.debug((Object)"#");
        LOG.debug((Object)("#  Starting Client1 using following web root " + location));
        LOG.debug((Object)"#");
        LOG.debug((Object)"#####################################");
        WebAppContext context = new WebAppContext();
        context.setResourceBase(location);
        context.setContextPath(configConstants.CONTEXT);
        HandlerCollection handlers = new HandlerCollection();
        handlers.addHandler((Handler)context);
        server.setHandler((Handler)handlers);
        server.setDumpAfterStart(true);
        return server;
    }

    private void registerTestCredentialsSourceFactory() {
        List<UsernamePasswordCredentialsSource> credentialsSources = Collections.singletonList(new UsernamePasswordCredentialsSource("gilesp", "thuperthecret"));
        CredentialsSourceFactory credentialsSourceFactory = new CredentialsSourceFactory();
        credentialsSourceFactory.setCredentialsSources(credentialsSources);
        try {
            credentialsSourceFactory.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new RiceRuntimeException((Throwable)e);
        }
        ConfigContext.getCurrentContextConfig().putObject("credentialsSourceFactory", (Object)credentialsSourceFactory);
    }

    public static final class ConfigConstants {
        public final String WEB_ROOT = "org/kuali/rice/ksb/testclient1";
        public final String CONTEXT = "/TestClient1";
        public final Integer SERVER_HTTP_PORT = Integer.valueOf(ConfigContext.getCurrentContextConfig().getProperty("ksb.client1.port"));
        public final Integer SERVER_HTTPS_PORT = Integer.valueOf(ConfigContext.getCurrentContextConfig().getProperty("ksb.client1.ssl.port"));
        public final String KEYSTORE_PASS = ConfigContext.getCurrentContextConfig().getKeystorePassword();
        public final String KEYSTORE_PATH;

        public ConfigConstants() {
            String keystoreFileTmp = null;
            try {
                keystoreFileTmp = ConfigContext.getCurrentContextConfig().getKeystoreFile();
            }
            catch (Exception e) {
                throw new RiceRuntimeException("Couldn't get keystore file location", (Throwable)e);
            }
            this.KEYSTORE_PATH = keystoreFileTmp;
        }
    }
}

