/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.testclient1;

import java.util.HashMap;
import java.util.Map;
import org.kuali.rice.ksb.messaging.remotedservices.Inbox;
import org.kuali.rice.ksb.messaging.remotedservices.Message;

public class Storage {
    public Map<String, Inbox> inboxes = new HashMap<String, Inbox>();
    public Map<String, Message> messages = new HashMap<String, Message>();
    private int lastInboxId = 0;
    private int lastMessageId = 0;

    public synchronized Inbox storeInbox(Inbox inbox) {
        String id = inbox.getId();
        if (id == null) {
            ++this.lastInboxId;
            id = String.valueOf(this.lastInboxId);
            inbox.setId(id);
        }
        this.inboxes.put(id, inbox);
        return inbox;
    }

    public synchronized Message storeMessage(Message message) {
        String id = message.getId();
        if (id == null) {
            ++this.lastMessageId;
            id = String.valueOf(this.lastMessageId);
            message.setId(id);
        }
        this.messages.put(id, message);
        return message;
    }

    public Inbox retrieveInbox(String id) {
        return this.inboxes.get(id);
    }

    public Message retrieveMessage(String id) {
        return this.messages.get(id);
    }

    public synchronized Inbox deleteInbox(String id) {
        return this.inboxes.remove(id);
    }

    public synchronized Message deleteMessage(String id) {
        return this.messages.remove(id);
    }
}

