/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.impl.data;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.location.api.campus.Campus;
import org.kuali.rice.location.api.campus.CampusQueryResults;
import org.kuali.rice.location.api.campus.CampusType;
import org.kuali.rice.location.api.campus.CampusTypeQueryResults;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryQueryResults;
import org.kuali.rice.location.api.county.County;
import org.kuali.rice.location.api.county.CountyQueryResults;
import org.kuali.rice.location.api.postalcode.PostalCode;
import org.kuali.rice.location.api.postalcode.PostalCodeQueryResults;
import org.kuali.rice.location.api.services.LocationApiServiceLocator;
import org.kuali.rice.location.api.state.State;
import org.kuali.rice.location.api.state.StateQueryResults;
import org.kuali.rice.location.impl.campus.CampusBo;
import org.kuali.rice.location.impl.campus.CampusTypeBo;
import org.kuali.rice.location.impl.country.CountryBo;
import org.kuali.rice.location.impl.county.CountyBo;
import org.kuali.rice.location.impl.county.CountyId;
import org.kuali.rice.location.impl.data.LocationTestCase;
import org.kuali.rice.location.impl.postalcode.PostalCodeBo;
import org.kuali.rice.location.impl.postalcode.PostalCodeId;
import org.kuali.rice.location.impl.state.StateBo;
import org.kuali.rice.location.impl.state.StateId;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class LocationDataJPATest
extends LocationTestCase {
    public void setUp() throws Exception {
        super.setUp();
        this.setupPostalCodeBoDataObjectAndSave();
        this.setupCampusBoDataObjectAndSave();
        KRADServiceLocator.getDataObjectService().flush(PostalCodeBo.class);
        KRADServiceLocator.getDataObjectService().flush(CountryBo.class);
        KRADServiceLocator.getDataObjectService().flush(CountyBo.class);
        KRADServiceLocator.getDataObjectService().flush(StateBo.class);
        KRADServiceLocator.getDataObjectService().flush(CampusTypeBo.class);
        KRADServiceLocator.getDataObjectService().flush(CampusBo.class);
    }

    @Test
    public void testPostalCodeBoDataObject() throws Exception {
        Assert.assertTrue((String)"PostalCodeBo is mapped in JPA", (boolean)KRADServiceLocator.getDataObjectService().supports(PostalCodeBo.class));
        PostalCodeBo postalCodeBo = (PostalCodeBo)KRADServiceLocator.getDataObjectService().find(PostalCodeBo.class, (Object)new PostalCodeId("US", "47203"));
        Assert.assertTrue((String)"PostalCode BO fetched after save", (postalCodeBo != null && StringUtils.equals((String)postalCodeBo.getCode(), (String)"47203") ? 1 : 0) != 0);
        Assert.assertTrue((String)"PostalCode BO fetched Country BO correctly", (postalCodeBo.getCountry() != null && StringUtils.equals((String)postalCodeBo.getCountry().getAlternateCode(), (String)"USA") ? 1 : 0) != 0);
        Assert.assertTrue((String)"PostalCode BO fetched State BO correctly", (postalCodeBo.getState() != null && StringUtils.equals((String)postalCodeBo.getState().getCode(), (String)"IN") ? 1 : 0) != 0);
        Assert.assertTrue((String)"PostalCode BO fetched County BO correctly", (postalCodeBo.getCounty() != null && StringUtils.equals((String)postalCodeBo.getCounty().getCode(), (String)"MON") ? 1 : 0) != 0);
    }

    @Test
    public void testCountyBoDataObject() throws Exception {
        Assert.assertTrue((String)"CountyBO is not mapped in JPA", (boolean)KRADServiceLocator.getDataObjectService().supports(CountryBo.class));
        CountyBo countyBo = (CountyBo)KRADServiceLocator.getDataObjectService().find(CountyBo.class, (Object)new CountyId("MON", "US", "IN"));
        Assert.assertNotNull((String)"County BO not retrieved after save", (Object)countyBo);
        Assert.assertEquals((String)"County name incorrect upon retrieve", (Object)"Monroe", (Object)countyBo.getName());
        Assert.assertEquals((String)"State code incorrect upon retrieve", (Object)"IN", (Object)countyBo.getStateCode());
        Assert.assertNotNull((String)"State on County BO should not be null", (Object)countyBo.getState());
        Assert.assertEquals((String)"State name on county incorrect", (Object)"Indiana", (Object)countyBo.getState().getName());
        Assert.assertNotNull((String)"Country on County BO should not be null", (Object)countyBo.getCountry());
        Assert.assertEquals((String)"Country code on county incorrect", (Object)"USA", (Object)countyBo.getCountry().getAlternateCode());
    }

    @Test
    public void testStateBoDataObject() throws Exception {
        Assert.assertTrue((String)"StateBO is mapped in JPA", (boolean)KRADServiceLocator.getDataObjectService().supports(StateBo.class));
        StateBo stateBo = (StateBo)KRADServiceLocator.getDataObjectService().find(StateBo.class, (Object)new StateId("IN", "US"));
        Assert.assertTrue((String)"State BO fetched after save", (stateBo != null && StringUtils.equals((String)stateBo.getName(), (String)"Indiana") ? 1 : 0) != 0);
        Assert.assertTrue((String)"State BO fetched Country BO correctly", (stateBo.getCountry() != null && StringUtils.equals((String)stateBo.getCountry().getAlternateCode(), (String)"USA") ? 1 : 0) != 0);
    }

    @Test
    public void testCountryBoDataObject() throws Exception {
        Assert.assertTrue((String)"CountryBO is mapped in JPA", (boolean)KRADServiceLocator.getDataObjectService().supports(CountryBo.class));
        CountryBo countryBo = (CountryBo)KRADServiceLocator.getDataObjectService().find(CountryBo.class, (Object)"CA");
        Assert.assertNotNull((String)"Country BO unable to be retrieved", (Object)countryBo);
        Assert.assertEquals((String)"Country BO Data incorrect", (Object)"CAN", (Object)countryBo.getAlternateCode());
    }

    @Test
    public void testCampusBoDataObject() throws Exception {
        Assert.assertTrue((String)"CampusBO is mapped in JPA", (boolean)KRADServiceLocator.getDataObjectService().supports(CampusBo.class));
        CampusBo campusBo = (CampusBo)KRADServiceLocator.getDataObjectService().find(CampusBo.class, (Object)"SE");
        Assert.assertTrue((String)"Campus BO fetched after save", (campusBo != null && StringUtils.equals((String)campusBo.getName(), (String)"SouthEast") ? 1 : 0) != 0);
        Assert.assertTrue((String)"Campus Type Bo fetched from Campus BO relationship", (campusBo.getCampusType() != null && StringUtils.equals((String)campusBo.getCampusType().getName(), (String)"Commuter") ? 1 : 0) != 0);
    }

    @Test
    public void testCampusTypeBoDataObject() throws Exception {
        Assert.assertTrue((String)"CampusTypeBo is mapped in JPA", (boolean)KRADServiceLocator.getDataObjectService().supports(CampusTypeBo.class));
        CampusTypeBo campusTypeBoFetched = (CampusTypeBo)KRADServiceLocator.getDataObjectService().find(CampusTypeBo.class, (Object)"C");
        Assert.assertTrue((String)"Campus Type BO refetched after save", (campusTypeBoFetched != null && campusTypeBoFetched.getName().equals("Commuter") ? 1 : 0) != 0);
    }

    @Test
    public void testCampusServiceImplJPA() throws Exception {
        Campus campusBo = LocationApiServiceLocator.getCampusService().getCampus("SE");
        Assert.assertTrue((String)"getCampusService retrieved correct call", (campusBo != null && StringUtils.equals((String)campusBo.getCode(), (String)"SE") ? 1 : 0) != 0);
        List activeCampuses = LocationApiServiceLocator.getCampusService().findAllCampuses();
        Assert.assertTrue((String)"findAllCampuses returned result", (activeCampuses.size() > 0 ? 1 : 0) != 0);
        CampusType campusType = LocationApiServiceLocator.getCampusService().getCampusType("C");
        Assert.assertTrue((String)"getCampusType retrieved correctly", (campusType != null && StringUtils.equals((String)campusType.getName(), (String)"Commuter") ? 1 : 0) != 0);
        List campusTypeList = LocationApiServiceLocator.getCampusService().findAllCampusTypes();
        Assert.assertTrue((String)"findAllCampusTypes retrieved correctly", (campusTypeList.size() > 0 ? 1 : 0) != 0);
        CampusQueryResults results = LocationApiServiceLocator.getCampusService().findCampuses(QueryByCriteria.Builder.forAttribute((String)"code", (Object)"SE").build());
        Assert.assertTrue((String)"findCampuses retrieved correctly", (results != null && results.getResults().size() == 1 ? 1 : 0) != 0);
        CampusTypeQueryResults resultsType = LocationApiServiceLocator.getCampusService().findCampusTypes(QueryByCriteria.Builder.forAttribute((String)"code", (Object)"C").build());
        Assert.assertTrue((String)"findCampuses retrieved correctly", (resultsType != null && resultsType.getResults().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testCountryServiceImplJPA() throws Exception {
        Country countryBo = LocationApiServiceLocator.getCountryService().getCountry("US");
        Assert.assertNotNull((String)"Country BO unable to be retrieved", (Object)countryBo);
        Assert.assertEquals((String)"Country BO Data incorrect", (Object)"USA", (Object)countryBo.getAlternateCode());
        countryBo = LocationApiServiceLocator.getCountryService().getCountryByAlternateCode("USA");
        Assert.assertNotNull((String)"Country BO unable to be retrieved", (Object)countryBo);
        Assert.assertEquals((String)"Country BO Data incorrect", (Object)"US", (Object)countryBo.getCode());
        List countryList = LocationApiServiceLocator.getCountryService().findAllCountries();
        Assert.assertNotNull((String)"Returned country list should not have been null", (Object)countryList);
        Assert.assertEquals((String)"Find all countries returned wrong number of results", (long)2L, (long)countryList.size());
        countryList = LocationApiServiceLocator.getCountryService().findAllCountriesNotRestricted();
        Assert.assertNotNull((String)"Returned country list should not have been null", (Object)countryList);
        Assert.assertEquals((String)"findAllCountriesNotRestricted returned wrong number of results", (long)1L, (long)countryList.size());
        CountryQueryResults results = LocationApiServiceLocator.getCountryService().findCountries(QueryByCriteria.Builder.forAttribute((String)"code", (Object)"US").build());
        Assert.assertNotNull((String)"findCountries country list should not have been null", (Object)results);
        Assert.assertNotNull((String)"findCountries.getResults() should not have been null", (Object)results.getResults());
        Assert.assertEquals((String)"findAllCountriesNotRestricted returned wrong number of results", (long)1L, (long)results.getResults().size());
    }

    @Test
    public void testCountyServiceImplJPA() throws Exception {
        County county = LocationApiServiceLocator.getCountyService().getCounty("US", "IN", "MON");
        Assert.assertTrue((String)"getCounty retrieved correctly", (county != null && StringUtils.equals((String)"MON", (String)county.getCode()) ? 1 : 0) != 0);
        CountyQueryResults results = LocationApiServiceLocator.getCountyService().findCounties(QueryByCriteria.Builder.forAttribute((String)"code", (Object)"MON").build());
        Assert.assertTrue((String)"findCounties retrieved correctly", (results != null && results.getResults().size() == 1 ? 1 : 0) != 0);
        List counties = LocationApiServiceLocator.getCountyService().findAllCountiesInCountryAndState("US", "IN");
        Assert.assertTrue((String)"findAllCountiesInCountryAndState retrieved correctly", (counties != null && counties.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testStateServiceImplJPA() throws Exception {
        State state = LocationApiServiceLocator.getStateService().getState("US", "IN");
        Assert.assertTrue((String)"getState retrieved correctly", (state != null && StringUtils.equals((String)"IN", (String)state.getCode()) ? 1 : 0) != 0);
        List stateList = LocationApiServiceLocator.getStateService().findAllStatesInCountry("US");
        Assert.assertTrue((String)"findAllStatesInCountry retrieved correctly", (stateList != null && stateList.size() == 1 ? 1 : 0) != 0);
        stateList = LocationApiServiceLocator.getStateService().findAllStatesInCountryByAltCode("USA");
        Assert.assertTrue((String)"findAllStatesInCountryByAltCode retrieved correctly", (stateList != null && stateList.size() == 1 ? 1 : 0) != 0);
        StateQueryResults results = LocationApiServiceLocator.getStateService().findStates(QueryByCriteria.Builder.forAttribute((String)"code", (Object)"IN").build());
        Assert.assertTrue((String)"findStates retrieved correctly", (results != null && results.getResults().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testPostalCodeServiceImplJPA() throws Exception {
        PostalCode postalCode = LocationApiServiceLocator.getPostalCodeService().getPostalCode("US", "47203");
        Assert.assertTrue((String)"getPostalCode retrieved correctly", (postalCode != null && StringUtils.equals((String)postalCode.getCode(), (String)"47203") ? 1 : 0) != 0);
        List postalCodeList = LocationApiServiceLocator.getPostalCodeService().findAllPostalCodesInCountry("US");
        Assert.assertTrue((String)"findAllPostalCodesInCountry retrieved correctly", (postalCodeList != null && postalCodeList.size() == 1 ? 1 : 0) != 0);
        PostalCodeQueryResults results = LocationApiServiceLocator.getPostalCodeService().findPostalCodes(QueryByCriteria.Builder.forAttribute((String)"code", (Object)"47203").build());
        Assert.assertTrue((String)"findPostalCodes retrieved correctly", (results != null && results.getResults().size() == 1 ? 1 : 0) != 0);
    }

    private void setupPostalCodeBoDataObjectAndSave() {
        KRADServiceLocator.getDataObjectService().flush(PostalCodeBo.class);
        if (KRADServiceLocator.getDataObjectService().find(PostalCodeBo.class, (Object)new PostalCodeId("US", "47203")) == null) {
            this.setupCountyBoDataObjectAndSave();
            PostalCodeBo postalCodeBo = new PostalCodeBo();
            postalCodeBo.setActive(true);
            postalCodeBo.setCityName("Bloomington");
            postalCodeBo.setCode("47203");
            postalCodeBo.setCountryCode("US");
            postalCodeBo.setCountyCode("MON");
            postalCodeBo.setStateCode("IN");
            KRADServiceLocator.getDataObjectService().save((Object)postalCodeBo, new PersistenceOption[0]);
        }
    }

    private void setupCountyBoDataObjectAndSave() {
        KRADServiceLocator.getDataObjectService().flush(CountyBo.class);
        if (KRADServiceLocator.getDataObjectService().find(CountyBo.class, (Object)new CountyId("MON", "US", "IN")) == null) {
            this.setupStateBoDataObjectAndSave();
            CountyBo countyBo = new CountyBo();
            countyBo.setActive(true);
            countyBo.setCode("MON");
            countyBo.setCountryCode("US");
            countyBo.setName("Monroe");
            countyBo.setStateCode("IN");
            CountyBo countyBo2 = (CountyBo)KRADServiceLocator.getDataObjectService().save((Object)countyBo, new PersistenceOption[0]);
        }
    }

    private void setupStateBoDataObjectAndSave() {
        this.setupCountryBoDataObjectAndSave();
        KRADServiceLocator.getDataObjectService().flush(StateBo.class);
        if (KRADServiceLocator.getDataObjectService().find(StateBo.class, (Object)new StateId("IN", "US")) == null) {
            StateBo stateBo = new StateBo();
            stateBo.setActive(true);
            stateBo.setCode("IN");
            stateBo.setCountryCode("US");
            stateBo.setName("Indiana");
            KRADServiceLocator.getDataObjectService().save((Object)stateBo, new PersistenceOption[0]);
        }
    }

    private void setupCountryBoDataObjectAndSave() {
        KRADServiceLocator.getDataObjectService().flush(CountryBo.class);
        if (KRADServiceLocator.getDataObjectService().find(CountryBo.class, (Object)"US") == null) {
            CountryBo countryBo = new CountryBo();
            countryBo.setActive(true);
            countryBo.setAlternateCode("USA");
            countryBo.setCode("US");
            countryBo.setName("UNITED STATES");
            countryBo.setRestricted(false);
            KRADServiceLocator.getDataObjectService().save((Object)countryBo, new PersistenceOption[0]);
            countryBo = new CountryBo();
            countryBo.setActive(true);
            countryBo.setAlternateCode("CAN");
            countryBo.setCode("CA");
            countryBo.setName("Canada");
            countryBo.setRestricted(true);
            KRADServiceLocator.getDataObjectService().save((Object)countryBo, new PersistenceOption[0]);
        }
    }

    private void setupCampusBoDataObjectAndSave() {
        KRADServiceLocator.getDataObjectService().flush(CampusBo.class);
        if (KRADServiceLocator.getDataObjectService().find(CampusBo.class, (Object)"SE") == null) {
            this.setupCampusTypeBoDataObjectAndSave();
            CampusBo campusBo = new CampusBo();
            campusBo.setActive(true);
            campusBo.setCampusTypeCode("C");
            campusBo.setCode("SE");
            campusBo.setName("SouthEast");
            campusBo.setShortName("SouthE");
            KRADServiceLocator.getDataObjectService().save((Object)campusBo, new PersistenceOption[0]);
        }
    }

    private void setupCampusTypeBoDataObjectAndSave() {
        KRADServiceLocator.getDataObjectService().flush(CampusTypeBo.class);
        if (KRADServiceLocator.getDataObjectService().find(CampusTypeBo.class, (Object)"C") == null) {
            CampusTypeBo campusTypeBo = new CampusTypeBo();
            campusTypeBo.setActive(true);
            campusTypeBo.setCode("C");
            campusTypeBo.setName("Commuter");
            KRADServiceLocator.getDataObjectService().save((Object)campusTypeBo, new PersistenceOption[0]);
        }
    }
}

