/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.peopleflow;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowBo;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.rules.MaintenanceDocumentRuleBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class PeopleFlowBusRule
extends MaintenanceDocumentRuleBase {
    private BusinessObjectService businessObjectService;

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = super.processCustomSaveDocumentBusinessRules(document);
        PeopleFlowBo peopleFlowDoc = (PeopleFlowBo)((Object)document.getNewMaintainableObject().getDataObject());
        if (StringUtils.isBlank((String)peopleFlowDoc.getId())) {
            result &= this.checkIfDuplicatePeopleFlow(peopleFlowDoc);
        }
        return result;
    }

    protected boolean checkIfDuplicatePeopleFlow(PeopleFlowBo peopleFlowBo) {
        boolean rulePassed = true;
        if (!StringUtils.isBlank((String)peopleFlowBo.getName()) && !StringUtils.isBlank((String)peopleFlowBo.getNamespaceCode())) {
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("namespaceCode", peopleFlowBo.getNamespaceCode());
            criteria.put("name", peopleFlowBo.getName());
            Collection peopleFlows = this.getBusinessObjectService().findMatching(PeopleFlowBo.class, criteria);
            if (CollectionUtils.isEmpty((Collection)peopleFlows)) {
                rulePassed = true;
            } else {
                GlobalVariables.getMessageMap().putError("document.peopleFlow.duplicate", "peopleFlow.duplicate", new String[]{peopleFlowBo.getName().toString(), peopleFlowBo.getNamespaceCode().toString()});
                rulePassed = false;
            }
        }
        return rulePassed;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

