/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.common.assignee;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kim.api.common.assignee.AssigneeContract;
import org.kuali.rice.kim.api.common.delegate.DelegateType;
import org.kuali.rice.kim.api.common.delegate.DelegateTypeContract;
import org.w3c.dom.Element;

@XmlRootElement(name="assignee")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="assigneeType", propOrder={"principalId", "groupId", "delegates", "_futureElements"})
public class Assignee
extends AbstractDataTransferObject
implements AssigneeContract {
    @XmlElement(name="principalId", required=false)
    private final String principalId;
    @XmlElement(name="groupId", required=true)
    private final String groupId;
    @XmlElementWrapper(name="delegates", required=false)
    @XmlElement(name="delegate", required=false)
    private final List<DelegateType> delegates;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private Assignee() {
        this.principalId = null;
        this.groupId = null;
        this.delegates = null;
    }

    public Assignee(Builder builder) {
        this.principalId = builder.getPrincipalId();
        this.groupId = builder.getGroupId();
        ArrayList<DelegateType> temp = new ArrayList<DelegateType>();
        if (!CollectionUtils.isEmpty(builder.getDelegates())) {
            for (DelegateType.Builder delegate : builder.getDelegates()) {
                temp.add(delegate.build());
            }
        }
        this.delegates = Collections.unmodifiableList(temp);
    }

    @Override
    public String getPrincipalId() {
        return this.principalId;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    public List<DelegateType> getDelegates() {
        return this.delegates;
    }

    static class Elements {
        static final String PRINCIPAL_ID = "principalId";
        static final String GROUP_ID = "groupId";
        static final String DELEGATES = "delegates";
        static final String DELEGATE = "delegate";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "assignee";
        static final String TYPE_NAME = "assigneeType";

        Constants() {
        }
    }

    public static final class Builder
    implements AssigneeContract,
    ModelBuilder,
    Serializable {
        private String principalId;
        private String groupId;
        private List<DelegateType.Builder> delegates;

        private Builder(String principalId, String groupId, List<DelegateType.Builder> delegates) {
            this.setPrincipalId(principalId);
            this.setGroupId(groupId);
            this.setDelegates(delegates);
        }

        public static Builder create(String principalId, String groupId, List<DelegateType.Builder> delegates) {
            return new Builder(principalId, groupId, delegates);
        }

        public static Builder create(AssigneeContract contract) {
            ArrayList<DelegateType.Builder> builders = new ArrayList<DelegateType.Builder>();
            for (DelegateTypeContract delegateTypeContract : contract.getDelegates()) {
                builders.add(DelegateType.Builder.create(delegateTypeContract));
            }
            Builder builder = new Builder(contract.getPrincipalId(), contract.getGroupId(), builders);
            return builder;
        }

        @Override
        public String getPrincipalId() {
            return this.principalId;
        }

        public void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public List<DelegateType.Builder> getDelegates() {
            return this.delegates;
        }

        public void setDelegates(List<DelegateType.Builder> delegates) {
            this.delegates = Collections.unmodifiableList(new ArrayList<DelegateType.Builder>(delegates));
        }

        public Assignee build() {
            boolean requiredSet;
            boolean bl = requiredSet = this.groupId != null ^ this.principalId != null && this.delegates != null;
            if (!requiredSet) {
                throw new IllegalStateException("all the required fields are not set");
            }
            return new Assignee(this);
        }
    }
}

