/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.role;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kim.api.role.RolePermissionContract;
import org.w3c.dom.Element;

@XmlRootElement(name="rolePermission")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="RolePermissionType", propOrder={"id", "roleId", "permissionId", "active", "versionNumber", "objectId", "_futureElements"})
public class RolePermission
extends AbstractDataTransferObject
implements RolePermissionContract {
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="roleId", required=false)
    private final String roleId;
    @XmlElement(name="permissionId", required=false)
    private final String permissionId;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private RolePermission() {
        this.id = null;
        this.roleId = null;
        this.permissionId = null;
        this.active = false;
        this.versionNumber = null;
        this.objectId = null;
    }

    public RolePermission(Builder builder) {
        this.id = builder.getId();
        this.roleId = builder.getRoleId();
        this.permissionId = builder.getPermissionId();
        this.active = builder.isActive();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getPermissionId() {
        return this.permissionId;
    }

    @Override
    public String getRoleId() {
        return this.roleId;
    }

    public boolean isActive() {
        return this.active;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    static class Elements {
        static final String ID = "id";
        static final String PERMISSION_ID = "permissionId";
        static final String ROLE_ID = "roleId";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "rolePermission";
        static final String TYPE_NAME = "RolePermissionType";

        Constants() {
        }
    }

    public static final class Builder
    implements RolePermissionContract,
    ModelBuilder,
    Serializable {
        private String id;
        private String roleId;
        private String permissionId;
        private Long versionNumber = 1L;
        private String objectId;
        private boolean active;

        private Builder(String id, String roleId, String permissionId) {
            this.setId(id);
            this.setRoleId(roleId);
            this.setPermissionId(permissionId);
        }

        public static Builder create(String id, String roleId, String permissionId) {
            return new Builder(id, roleId, permissionId);
        }

        public static Builder create(RolePermissionContract contract) {
            Builder builder = new Builder(contract.getId(), contract.getRoleId(), contract.getPermissionId());
            builder.setActive(contract.isActive());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            return builder;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id is blank");
            }
            this.id = id;
        }

        @Override
        public String getPermissionId() {
            return this.permissionId;
        }

        public void setPermissionId(String permissionId) {
            this.permissionId = permissionId;
        }

        @Override
        public String getRoleId() {
            return this.roleId;
        }

        public void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(Long versionNumber) {
            if (versionNumber != null && versionNumber <= 0L) {
                throw new IllegalArgumentException("versionNumber is invalid");
            }
            this.versionNumber = versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public RolePermission build() {
            if (this.versionNumber == null || this.versionNumber <= 0L) {
                throw new IllegalStateException("versionNumber is invalid");
            }
            if (StringUtils.isWhitespace((String)this.id)) {
                throw new IllegalStateException("id is blank");
            }
            return new RolePermission(this);
        }
    }
}

