/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.identity.name;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.DateTimeAdapter;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.name.EntityNameContract;
import org.w3c.dom.Element;

@XmlRootElement(name="entityName")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="EntityNameType", propOrder={"id", "entityId", "nameType", "namePrefix", "nameTitle", "firstName", "middleName", "lastName", "nameSuffix", "compositeName", "namePrefixUnmasked", "nameTitleUnmasked", "firstNameUnmasked", "middleNameUnmasked", "lastNameUnmasked", "nameSuffixUnmasked", "compositeNameUnmasked", "noteMessage", "nameChangedDate", "suppressName", "defaultValue", "active", "versionNumber", "objectId", "_futureElements"})
public final class EntityName
extends AbstractDataTransferObject
implements EntityNameContract {
    @XmlElement(name="nameSuffix", required=false)
    private final String nameSuffix;
    @XmlElement(name="entityId", required=false)
    private final String entityId;
    @XmlElement(name="nameType", required=false)
    private final CodedAttribute nameType;
    @XmlElement(name="firstName", required=false)
    private final String firstName;
    @XmlElement(name="firstNameUnmasked", required=false)
    private final String firstNameUnmasked;
    @XmlElement(name="middleName", required=false)
    private final String middleName;
    @XmlElement(name="middleNameUnmasked", required=false)
    private final String middleNameUnmasked;
    @XmlElement(name="lastName", required=false)
    private final String lastName;
    @XmlElement(name="lastNameUnmasked", required=false)
    private final String lastNameUnmasked;
    @XmlElement(name="namePrefix", required=false)
    private final String namePrefix;
    @XmlElement(name="namePrefixUnmasked", required=false)
    private final String namePrefixUnmasked;
    @XmlElement(name="nameTitle", required=false)
    private final String nameTitle;
    @XmlElement(name="nameTitleUnmasked", required=false)
    private final String nameTitleUnmasked;
    @XmlElement(name="nameSuffixUnmasked", required=false)
    private final String nameSuffixUnmasked;
    @XmlElement(name="compositeName", required=false)
    private final String compositeName;
    @XmlElement(name="compositeNameUnmasked", required=false)
    private final String compositeNameUnmasked;
    @XmlElement(name="noteMessage", required=false)
    private final String noteMessage;
    @XmlElement(name="nameChangedDate", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime nameChangedDate;
    @XmlElement(name="suppressName", required=false)
    private final boolean suppressName;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlElement(name="defaultValue", required=false)
    private final boolean defaultValue;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private EntityName() {
        this.nameSuffix = null;
        this.entityId = null;
        this.nameType = null;
        this.firstName = null;
        this.firstNameUnmasked = null;
        this.middleName = null;
        this.middleNameUnmasked = null;
        this.lastName = null;
        this.lastNameUnmasked = null;
        this.namePrefix = null;
        this.namePrefixUnmasked = null;
        this.nameTitle = null;
        this.nameTitleUnmasked = null;
        this.nameSuffixUnmasked = null;
        this.compositeName = null;
        this.compositeNameUnmasked = null;
        this.noteMessage = null;
        this.nameChangedDate = null;
        this.suppressName = false;
        this.versionNumber = null;
        this.objectId = null;
        this.defaultValue = false;
        this.active = false;
        this.id = null;
    }

    private EntityName(Builder builder) {
        this.nameSuffix = builder.getNameSuffix();
        this.entityId = builder.getEntityId();
        this.nameType = builder.getNameType() != null ? builder.getNameType().build() : null;
        this.firstName = builder.getFirstName();
        this.firstNameUnmasked = builder.getFirstNameUnmasked();
        this.middleName = builder.getMiddleName();
        this.middleNameUnmasked = builder.getMiddleNameUnmasked();
        this.lastName = builder.getLastName();
        this.lastNameUnmasked = builder.getLastNameUnmasked();
        this.namePrefix = builder.getNamePrefix();
        this.namePrefixUnmasked = builder.getNamePrefixUnmasked();
        this.nameTitle = builder.getNameTitle();
        this.nameTitleUnmasked = builder.getNameTitleUnmasked();
        this.nameSuffixUnmasked = builder.getNameSuffixUnmasked();
        this.compositeName = builder.getCompositeName();
        this.compositeNameUnmasked = builder.getCompositeNameUnmasked();
        this.noteMessage = builder.getNoteMessage();
        this.nameChangedDate = builder.getNameChangedDate();
        this.suppressName = builder.isSuppressName();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
        this.defaultValue = builder.isDefaultValue();
        this.active = builder.isActive();
        this.id = builder.getId();
    }

    @Override
    public String getNameSuffix() {
        return this.nameSuffix;
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    public CodedAttribute getNameType() {
        return this.nameType;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getFirstNameUnmasked() {
        return this.firstNameUnmasked;
    }

    @Override
    public String getMiddleName() {
        return this.middleName;
    }

    @Override
    public String getMiddleNameUnmasked() {
        return this.middleNameUnmasked;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getLastNameUnmasked() {
        return this.lastNameUnmasked;
    }

    @Override
    public String getNamePrefix() {
        return this.namePrefix;
    }

    @Override
    public String getNamePrefixUnmasked() {
        return this.namePrefixUnmasked;
    }

    @Override
    public String getNameTitle() {
        return this.nameTitle;
    }

    @Override
    public String getNameTitleUnmasked() {
        return this.nameTitleUnmasked;
    }

    @Override
    public String getNameSuffixUnmasked() {
        return this.nameSuffixUnmasked;
    }

    @Override
    public String getCompositeName() {
        return this.compositeName;
    }

    @Override
    public String getCompositeNameUnmasked() {
        return this.compositeNameUnmasked;
    }

    @Override
    public String getNoteMessage() {
        return this.noteMessage;
    }

    @Override
    public DateTime getNameChangedDate() {
        return this.nameChangedDate;
    }

    @Override
    public boolean isSuppressName() {
        return this.suppressName;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getId() {
        return this.id;
    }

    static class Elements {
        static final String NAME_SUFFIX = "nameSuffix";
        static final String ENTITY_ID = "entityId";
        static final String NAME_TYPE = "nameType";
        static final String FIRST_NAME = "firstName";
        static final String FIRST_NAME_UNMASKED = "firstNameUnmasked";
        static final String MIDDLE_NAME = "middleName";
        static final String MIDDLE_NAME_UNMASKED = "middleNameUnmasked";
        static final String LAST_NAME = "lastName";
        static final String LAST_NAME_UNMASKED = "lastNameUnmasked";
        static final String NAME_PREFIX = "namePrefix";
        static final String NAME_PREFIX_UNMASKED = "namePrefixUnmasked";
        static final String NAME_TITLE = "nameTitle";
        static final String NAME_TITLE_UNMASKED = "nameTitleUnmasked";
        static final String NAME_SUFFIX_UNMASKED = "nameSuffixUnmasked";
        static final String COMPOSITE_NAME = "compositeName";
        static final String COMPOSITE_NAME_UNMASKED = "compositeNameUnmasked";
        static final String NOTE_MESSAGE = "noteMessage";
        static final String NAME_CHANGED_DATE = "nameChangedDate";
        static final String SUPPRESS_NAME = "suppressName";
        static final String DEFAULT_VALUE = "defaultValue";
        static final String ACTIVE = "active";
        static final String ID = "id";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "entityName";
        static final String TYPE_NAME = "EntityNameType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    EntityNameContract {
        private String nameSuffix;
        private String entityId;
        private CodedAttribute.Builder nameType;
        private String firstName;
        private String middleName;
        private String lastName;
        private String namePrefix;
        private String nameTitle;
        private String compositeName;
        private String noteMessage;
        private DateTime nameChangedDate;
        private boolean suppressName;
        private Long versionNumber;
        private String objectId;
        private boolean defaultValue;
        private boolean active;
        private String id;

        private Builder() {
        }

        private Builder(String id, String entityId, String firstName, String lastName, boolean suppressName) {
            this.setId(id);
            this.setEntityId(entityId);
            this.setFirstName(firstName);
            this.setLastName(lastName);
            this.setSuppressName(suppressName);
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(String id, String entityId, String firstName, String lastName, boolean suppressName) {
            return new Builder(id, entityId, firstName, lastName, suppressName);
        }

        public static Builder create(EntityNameContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setNameSuffix(contract.getNameSuffix());
            builder.setEntityId(contract.getEntityId());
            if (contract.getNameType() != null) {
                builder.setNameType(CodedAttribute.Builder.create(contract.getNameType()));
            }
            builder.setFirstName(contract.getFirstName());
            builder.setMiddleName(contract.getMiddleName());
            builder.setLastName(contract.getLastName());
            builder.setNamePrefix(contract.getNamePrefix());
            builder.setNameTitle(contract.getNameTitle());
            builder.setNoteMessage(contract.getNoteMessage());
            builder.setNameChangedDate(contract.getNameChangedDate());
            builder.setSuppressName(contract.isSuppressName());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            builder.setDefaultValue(contract.isDefaultValue());
            builder.setActive(contract.isActive());
            builder.setId(contract.getId());
            builder.setCompositeName(contract.getCompositeName());
            return builder;
        }

        public EntityName build() {
            return new EntityName(this);
        }

        @Override
        public String getNameSuffix() {
            if (this.isSuppressName()) {
                return "Xxxxxx";
            }
            return this.nameSuffix;
        }

        @Override
        public String getEntityId() {
            return this.entityId;
        }

        @Override
        public CodedAttribute.Builder getNameType() {
            return this.nameType;
        }

        @Override
        public String getFirstName() {
            if (this.isSuppressName()) {
                return "Xxxxxx";
            }
            return this.firstName;
        }

        @Override
        public String getFirstNameUnmasked() {
            return this.firstName;
        }

        @Override
        public String getMiddleName() {
            if (this.isSuppressName()) {
                return "Xxxxxx";
            }
            return this.middleName;
        }

        @Override
        public String getMiddleNameUnmasked() {
            return this.middleName;
        }

        @Override
        public String getLastName() {
            if (this.isSuppressName()) {
                return "Xxxxxx";
            }
            return this.lastName;
        }

        @Override
        public String getLastNameUnmasked() {
            return this.lastName;
        }

        @Override
        public String getNamePrefix() {
            if (this.isSuppressName()) {
                return "Xxxxxx";
            }
            return this.namePrefix;
        }

        @Override
        public String getNamePrefixUnmasked() {
            return this.namePrefix;
        }

        @Override
        public String getNameTitle() {
            if (this.isSuppressName()) {
                return "Xxxxxx";
            }
            return this.nameTitle;
        }

        @Override
        public String getNameTitleUnmasked() {
            return this.nameTitle;
        }

        @Override
        public String getNameSuffixUnmasked() {
            return this.nameSuffix;
        }

        @Override
        public String getCompositeName() {
            if (this.isSuppressName()) {
                return "Xxxxxx";
            }
            return this.getCompositeNameUnmasked();
        }

        @Override
        public String getCompositeNameUnmasked() {
            if (this.compositeName == null) {
                String lastNameTemp = "";
                String firstNameTemp = "";
                if (StringUtils.isNotBlank((String)this.getLastName())) {
                    lastNameTemp = this.getLastName();
                }
                if (StringUtils.isNotBlank((String)this.getFirstName())) {
                    firstNameTemp = this.getFirstName();
                }
                if (StringUtils.isNotBlank((String)lastNameTemp) && StringUtils.isNotBlank((String)firstNameTemp)) {
                    lastNameTemp = lastNameTemp + ", ";
                }
                this.setCompositeName(lastNameTemp + firstNameTemp + (StringUtils.isBlank((String)this.getMiddleName()) ? "" : " " + this.getMiddleName()));
            }
            return this.compositeName;
        }

        @Override
        public String getNoteMessage() {
            return this.noteMessage;
        }

        @Override
        public DateTime getNameChangedDate() {
            return this.nameChangedDate;
        }

        @Override
        public boolean isSuppressName() {
            return this.suppressName;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public boolean isDefaultValue() {
            return this.defaultValue;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getId() {
            return this.id;
        }

        public void setNameSuffix(String nameSuffix) {
            this.nameSuffix = nameSuffix;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public void setNameType(CodedAttribute.Builder nameType) {
            this.nameType = nameType;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        public void setNameTitle(String nameTitle) {
            this.nameTitle = nameTitle;
        }

        public void setCompositeName(String compositeName) {
            this.compositeName = compositeName;
        }

        public void setNoteMessage(String noteMessage) {
            this.noteMessage = noteMessage;
        }

        public void setNameChangedDate(DateTime nameChangedDate) {
            this.nameChangedDate = nameChangedDate;
        }

        private void setSuppressName(boolean suppressName) {
            this.suppressName = suppressName;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public void setDefaultValue(boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id is blank");
            }
            this.id = id;
        }
    }
}

