/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.group;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.criteria.CriteriaLookupService;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.LookupCustomizer;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupContract;
import org.kuali.rice.kim.api.group.GroupMember;
import org.kuali.rice.kim.api.group.GroupMemberContract;
import org.kuali.rice.kim.api.group.GroupMemberQueryResults;
import org.kuali.rice.kim.api.group.GroupQueryResults;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.common.attribute.AttributeTransform;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeDataBo;
import org.kuali.rice.kim.impl.group.GroupAttributeBo;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.kim.impl.group.GroupMemberBo;
import org.kuali.rice.kim.impl.group.GroupServiceBase;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class GroupServiceImpl
extends GroupServiceBase
implements GroupService {
    private static final Logger LOG = Logger.getLogger(GroupServiceImpl.class);
    protected BusinessObjectService businessObjectService;
    private CriteriaLookupService criteriaLookupService;

    public Group getGroup(String groupId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(groupId, "groupId");
        return GroupBo.to(this.getGroupBo(groupId));
    }

    public List<Group> getGroupsByPrincipalId(String principalId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        return this.getGroupsByPrincipalIdAndNamespaceCodeInternal(principalId, null);
    }

    public List<Group> getGroupsByPrincipalIdAndNamespaceCode(String principalId, String namespaceCode) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        return this.getGroupsByPrincipalIdAndNamespaceCodeInternal(principalId, namespaceCode);
    }

    protected List<Group> getGroupsByPrincipalIdAndNamespaceCodeInternal(String principalId, String namespaceCode) throws RiceIllegalArgumentException {
        Collection<Group> directGroups = this.getDirectGroupsForPrincipal(principalId, namespaceCode);
        HashSet<Group> groups = new HashSet<Group>();
        groups.addAll(directGroups);
        for (Group group : directGroups) {
            groups.add(group);
            groups.addAll(this.getParentGroups(group.getId()));
        }
        return Collections.unmodifiableList(new ArrayList(groups));
    }

    public List<String> findGroupIds(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        GroupQueryResults results = this.findGroups(queryByCriteria);
        ArrayList<String> result = new ArrayList<String>();
        for (Group group : results.getResults()) {
            result.add(group.getId());
        }
        return Collections.unmodifiableList(result);
    }

    public boolean isDirectMemberOfGroup(String principalId, String groupId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(groupId, "groupId");
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("memberId", principalId);
        criteria.put("typeCode", KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode());
        criteria.put("groupId", groupId);
        Collection groupMembers = this.businessObjectService.findMatching(GroupMemberBo.class, criteria);
        for (GroupMemberBo gm : groupMembers) {
            if (!gm.isActive(new Timestamp(System.currentTimeMillis()))) continue;
            return true;
        }
        return false;
    }

    public List<String> getGroupIdsByPrincipalId(String principalId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        return this.getGroupIdsByPrincipalIdAndNamespaceCodeInternal(principalId, null);
    }

    public List<String> getGroupIdsByPrincipalIdAndNamespaceCode(String principalId, String namespaceCode) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        ArrayList<String> result = new ArrayList<String>();
        if (principalId != null) {
            List<Group> groupList = this.getGroupsByPrincipalIdAndNamespaceCode(principalId, namespaceCode);
            for (Group group : groupList) {
                result.add(group.getId());
            }
        }
        return Collections.unmodifiableList(result);
    }

    protected List<String> getGroupIdsByPrincipalIdAndNamespaceCodeInternal(String principalId, String namespaceCode) throws RiceIllegalArgumentException {
        ArrayList<String> result = new ArrayList<String>();
        if (principalId != null) {
            List<Group> groupList = this.getGroupsByPrincipalIdAndNamespaceCodeInternal(principalId, namespaceCode);
            for (Group group : groupList) {
                result.add(group.getId());
            }
        }
        return Collections.unmodifiableList(result);
    }

    public List<String> getDirectGroupIdsByPrincipalId(String principalId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        ArrayList<String> result = new ArrayList<String>();
        if (principalId != null) {
            Collection<Group> groupList = this.getDirectGroupsForPrincipal(principalId);
            for (Group g : groupList) {
                result.add(g.getId());
            }
        }
        return Collections.unmodifiableList(result);
    }

    public List<String> getMemberPrincipalIds(String groupId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(groupId, "groupId");
        return this.getMemberPrincipalIdsInternal(groupId, new HashSet<String>());
    }

    public List<String> getDirectMemberPrincipalIds(String groupId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(groupId, "groupId");
        return this.getMemberIdsByType(this.getMembersOfGroup(groupId), KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE);
    }

    public List<String> getMemberGroupIds(String groupId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(groupId, "groupId");
        List<GroupBo> groups = this.getMemberGroupBos(groupId);
        ArrayList<String> groupIds = new ArrayList<String>(groups.size());
        for (GroupBo group : groups) {
            if (!group.isActive()) continue;
            groupIds.add(group.getId());
        }
        return Collections.unmodifiableList(groupIds);
    }

    protected List<GroupBo> getMemberGroupBos(String groupId) {
        if (groupId == null) {
            return Collections.emptyList();
        }
        HashSet<GroupBo> groups = new HashSet<GroupBo>();
        GroupBo group = this.getGroupBo(groupId);
        this.getMemberGroupsInternal(group, groups);
        return new ArrayList<GroupBo>(groups);
    }

    protected void getMemberGroupsInternal(GroupBo group, Set<GroupBo> groups) {
        if (group == null) {
            return;
        }
        List<String> groupIds = group.getMemberGroupIds();
        for (String id : groupIds) {
            GroupBo memberGroup = this.getGroupBo(id);
            if (!memberGroup.isActive() || groups.contains((Object)memberGroup)) continue;
            groups.add(memberGroup);
            this.getMemberGroupsInternal(memberGroup, groups);
        }
    }

    public boolean isGroupMemberOfGroup(String groupMemberId, String groupId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(groupMemberId, "groupMemberId");
        this.incomingParamCheck(groupId, "groupId");
        return this.isMemberOfGroupInternal(groupMemberId, groupId, new HashSet<String>(), KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE);
    }

    public boolean isMemberOfGroup(String principalId, String groupId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(groupId, "groupId");
        HashSet<String> visitedGroupIds = new HashSet<String>();
        return this.isMemberOfGroupInternal(principalId, groupId, visitedGroupIds, KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE);
    }

    public List<String> getDirectMemberGroupIds(String groupId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(groupId, "groupId");
        return this.getMemberIdsByType(this.getMembersOfGroup(groupId), KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE);
    }

    public List<String> getParentGroupIds(String groupId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(groupId, "groupId");
        ArrayList<String> result = new ArrayList<String>();
        if (groupId != null) {
            List<Group> groupList = this.getParentGroups(groupId);
            for (Group group : groupList) {
                result.add(group.getId());
            }
        }
        return Collections.unmodifiableList(result);
    }

    public List<String> getDirectParentGroupIds(String groupId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(groupId, "groupId");
        ArrayList<String> result = new ArrayList<String>();
        if (groupId != null) {
            List<Group> groupList = this.getDirectParentGroups(groupId);
            for (Group group : groupList) {
                result.add(group.getId());
            }
        }
        return Collections.unmodifiableList(result);
    }

    public Map<String, String> getAttributes(String groupId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(groupId, "groupId");
        Group group = this.getGroup(groupId);
        if (group != null) {
            return group.getAttributes();
        }
        return Collections.emptyMap();
    }

    public List<GroupMember> getMembers(List<String> groupIds) throws RiceIllegalArgumentException {
        if (CollectionUtils.isEmpty(groupIds)) {
            throw new RiceIllegalArgumentException("groupIds is empty");
        }
        ArrayList<GroupMember> groupMembers = new ArrayList<GroupMember>();
        for (String groupId : groupIds) {
            groupMembers.addAll(this.getMembersOfGroup(groupId));
        }
        return Collections.unmodifiableList(groupMembers);
    }

    public List<Group> getGroups(Collection<String> groupIds) throws RiceIllegalArgumentException {
        this.incomingParamCheck(groupIds, "groupIds");
        if (groupIds.isEmpty()) {
            return Collections.emptyList();
        }
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new org.kuali.rice.core.api.criteria.Predicate[]{PredicateFactory.and((org.kuali.rice.core.api.criteria.Predicate[])new org.kuali.rice.core.api.criteria.Predicate[]{PredicateFactory.in((String)"id", (Object[])groupIds.toArray()), PredicateFactory.equal((String)"active", (Object)"Y")})});
        GroupQueryResults qr = this.findGroups(builder.build());
        return qr.getResults();
    }

    public Group getGroupByNamespaceCodeAndName(String namespaceCode, String groupName) throws RiceIllegalArgumentException {
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(groupName, "groupName");
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("namespaceCode", namespaceCode);
        criteria.put("name", groupName);
        Collection groups = this.businessObjectService.findMatching(GroupBo.class, criteria);
        if (!groups.isEmpty()) {
            return GroupBo.to((GroupBo)((Object)groups.iterator().next()));
        }
        return null;
    }

    public GroupQueryResults findGroups(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        LookupCustomizer.Builder lc = LookupCustomizer.Builder.create();
        lc.setPredicateTransform(AttributeTransform.getInstance());
        GenericQueryResults results = this.criteriaLookupService.lookup(GroupBo.class, queryByCriteria, lc.build());
        GroupQueryResults.Builder builder = GroupQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<Group.Builder> ims = new ArrayList<Group.Builder>();
        for (GroupBo bo : results.getResults()) {
            ims.add(Group.Builder.create((GroupContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public GroupMemberQueryResults findGroupMembers(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        GenericQueryResults results = this.criteriaLookupService.lookup(GroupMemberBo.class, queryByCriteria);
        GroupMemberQueryResults.Builder builder = GroupMemberQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<GroupMember.Builder> ims = new ArrayList<GroupMember.Builder>();
        for (GroupMemberBo bo : results.getResults()) {
            ims.add(GroupMember.Builder.create((GroupMemberContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    protected boolean isMemberOfGroupInternal(String memberId, String groupId, Set<String> visitedGroupIds, MemberType memberType) {
        if (memberId == null || groupId == null) {
            return false;
        }
        Group group = this.getGroup(groupId);
        if (group == null || !group.isActive()) {
            return false;
        }
        List<GroupMember> members = this.getMembersOfGroup(group.getId());
        for (String groupMemberId : this.getMemberIdsByType(members, memberType)) {
            if (!groupMemberId.equals(memberId)) continue;
            return true;
        }
        for (String memberGroupId : this.getMemberIdsByType(members, KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE)) {
            if (visitedGroupIds.contains(memberGroupId)) continue;
            visitedGroupIds.add(memberGroupId);
            if (!this.isMemberOfGroupInternal(memberId, memberGroupId, visitedGroupIds, memberType)) continue;
            return true;
        }
        return false;
    }

    protected void getParentGroupsInternal(String groupId, Set<Group> groups) {
        List<Group> parentGroups = this.getDirectParentGroups(groupId);
        for (Group group : parentGroups) {
            if (groups.contains(group)) continue;
            groups.add(group);
            this.getParentGroupsInternal(group.getId(), groups);
        }
    }

    protected List<Group> getDirectParentGroups(String groupId) {
        if (groupId == null) {
            return Collections.emptyList();
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("memberId", groupId);
        criteria.put("typeCode", KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.getCode());
        List groupMembers = (List)this.businessObjectService.findMatching(GroupMemberBo.class, criteria);
        HashSet<String> matchingGroupIds = new HashSet<String>();
        for (GroupMemberBo gm : groupMembers) {
            if (!gm.isActive(new Timestamp(System.currentTimeMillis()))) continue;
            matchingGroupIds.add(gm.getGroupId());
        }
        if (CollectionUtils.isNotEmpty(matchingGroupIds)) {
            return this.getGroups(matchingGroupIds);
        }
        return Collections.emptyList();
    }

    public List<GroupMember> getMembersOfGroup(String groupId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(groupId, "groupId");
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("groupId", groupId);
        Collection groupMembersBos = this.businessObjectService.findMatching(GroupMemberBo.class, criteria);
        ArrayList<GroupMember> groupMembers = new ArrayList<GroupMember>();
        for (GroupMemberBo groupBo : groupMembersBos) {
            if (!groupBo.isActive(new Timestamp(System.currentTimeMillis()))) continue;
            groupMembers.add(GroupMemberBo.to(groupBo));
        }
        return Collections.unmodifiableList(groupMembers);
    }

    protected List<String> getMemberIdsByType(Collection<GroupMember> members, MemberType memberType) {
        ArrayList<String> membersIds = new ArrayList<String>();
        if (members != null) {
            for (GroupMember member : members) {
                if (!member.getType().equals((Object)memberType)) continue;
                membersIds.add(member.getMemberId());
            }
        }
        return Collections.unmodifiableList(membersIds);
    }

    protected GroupBo getGroupBo(String groupId) {
        this.incomingParamCheck(groupId, "groupId");
        return (GroupBo)this.businessObjectService.findByPrimaryKey(GroupBo.class, Collections.singletonMap("id", groupId));
    }

    protected GroupMemberBo getGroupMemberBo(String id) {
        this.incomingParamCheck(id, "id");
        return (GroupMemberBo)this.businessObjectService.findByPrimaryKey(GroupMemberBo.class, Collections.singletonMap("id", id));
    }

    protected List<Group> getParentGroups(String groupId) throws RiceIllegalArgumentException {
        if (StringUtils.isEmpty((String)groupId)) {
            throw new RiceIllegalArgumentException("groupId is blank");
        }
        HashSet<Group> groups = new HashSet<Group>();
        this.getParentGroupsInternal(groupId, groups);
        return new ArrayList<Group>(groups);
    }

    protected List<String> getMemberPrincipalIdsInternal(String groupId, Set<String> visitedGroupIds) {
        if (groupId == null) {
            return Collections.emptyList();
        }
        HashSet<String> ids = new HashSet<String>();
        GroupBo group = this.getGroupBo(groupId);
        if (group == null || !group.isActive()) {
            return Collections.emptyList();
        }
        ids.addAll(group.getMemberPrincipalIds());
        visitedGroupIds.add(group.getId());
        for (String memberGroupId : group.getMemberGroupIds()) {
            if (visitedGroupIds.contains(memberGroupId)) continue;
            ids.addAll(this.getMemberPrincipalIdsInternal(memberGroupId, visitedGroupIds));
        }
        return Collections.unmodifiableList(new ArrayList(ids));
    }

    protected Collection<Group> getDirectGroupsForPrincipal(String principalId) {
        return this.getDirectGroupsForPrincipal(principalId, null);
    }

    protected Collection<Group> getDirectGroupsForPrincipal(String principalId, String namespaceCode) {
        if (principalId == null) {
            return Collections.emptyList();
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("memberId", principalId);
        criteria.put("typeCode", KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode());
        Collection groupMembers = this.businessObjectService.findMatching(GroupMemberBo.class, criteria);
        HashSet<String> groupIds = new HashSet<String>(groupMembers.size());
        for (GroupMemberBo gm : groupMembers) {
            if (!gm.isActive(new Timestamp(System.currentTimeMillis()))) continue;
            groupIds.add(gm.getGroupId());
        }
        List<Group> groups = CollectionUtils.isEmpty(groupIds) ? Collections.emptyList() : this.getGroups(groupIds);
        ArrayList<Group> result = new ArrayList<Group>(groups.size());
        for (Group group : groups) {
            if (!group.isActive() || !StringUtils.isBlank((String)namespaceCode) && !StringUtils.equals((String)namespaceCode, (String)group.getNamespaceCode())) continue;
            result.add(group);
        }
        return result;
    }

    public boolean addGroupToGroup(String childId, String parentId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(childId, "childId");
        this.incomingParamCheck(parentId, "parentId");
        if (childId.equals(parentId)) {
            throw new RiceIllegalArgumentException("Can't add group to itself.");
        }
        if (this.isGroupMemberOfGroup(parentId, childId)) {
            throw new RiceIllegalArgumentException("Circular group reference.");
        }
        GroupMemberBo groupMember = new GroupMemberBo();
        groupMember.setGroupId(parentId);
        groupMember.setType(KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE);
        groupMember.setMemberId(childId);
        this.businessObjectService.save((PersistableBusinessObject)groupMember);
        return true;
    }

    public boolean addPrincipalToGroup(String principalId, String groupId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(groupId, "groupId");
        GroupMemberBo groupMember = new GroupMemberBo();
        groupMember.setGroupId(groupId);
        groupMember.setType(KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE);
        groupMember.setMemberId(principalId);
        groupMember = (GroupMemberBo)this.businessObjectService.save((PersistableBusinessObject)groupMember);
        KimImplServiceLocator.getGroupInternalService().updateForUserAddedToGroup(groupMember.getMemberId(), groupMember.getGroupId());
        return true;
    }

    public Group createGroup(Group group) throws RiceIllegalArgumentException {
        this.incomingParamCheck(group, "group");
        if (StringUtils.isNotBlank((String)group.getId()) && this.getGroup(group.getId()) != null) {
            throw new RiceIllegalArgumentException("the group to create already exists: " + group);
        }
        List<GroupAttributeBo> attrBos = KimAttributeDataBo.createFrom(GroupAttributeBo.class, group.getAttributes(), group.getKimTypeId());
        if (StringUtils.isNotEmpty((String)group.getId())) {
            for (GroupAttributeBo attr : attrBos) {
                attr.setAssignedToId(group.getId());
            }
        }
        GroupBo bo = GroupBo.from(group);
        bo.setAttributeDetails(attrBos);
        bo = this.saveGroup(bo);
        return GroupBo.to(bo);
    }

    public Group updateGroup(Group group) throws RiceIllegalArgumentException {
        this.incomingParamCheck(group, "group");
        GroupBo origGroup = this.getGroupBo(group.getId());
        if (StringUtils.isBlank((String)group.getId()) || origGroup == null) {
            throw new RiceIllegalArgumentException("the group does not exist: " + group);
        }
        List<GroupAttributeBo> attrBos = KimAttributeDataBo.createFrom(GroupAttributeBo.class, group.getAttributes(), group.getKimTypeId());
        GroupBo bo = GroupBo.from(group);
        bo.setMembers(origGroup.getMembers());
        bo.setAttributeDetails(attrBos);
        bo = this.saveGroup(bo);
        if (origGroup.isActive() && !bo.isActive()) {
            KimImplServiceLocator.getRoleInternalService().groupInactivated(bo.getId());
        }
        return GroupBo.to(bo);
    }

    public Group updateGroup(String groupId, Group group) throws RiceIllegalArgumentException {
        this.incomingParamCheck(group, "group");
        this.incomingParamCheck(groupId, "groupId");
        if (StringUtils.equals((String)groupId, (String)group.getId())) {
            return this.updateGroup(group);
        }
        GroupBo groupBo = this.getGroupBo(groupId);
        if (StringUtils.isBlank((String)group.getId()) || groupBo == null) {
            throw new RiceIllegalArgumentException("the group does not exist: " + group);
        }
        GroupBo newGroup = GroupBo.from(group);
        newGroup.setMembers(groupBo.getMembers());
        List<GroupAttributeBo> attrBos = KimAttributeDataBo.createFrom(GroupAttributeBo.class, group.getAttributes(), group.getKimTypeId());
        newGroup.setAttributeDetails(attrBos);
        newGroup = this.saveGroup(newGroup);
        groupBo.setActive(false);
        this.saveGroup(groupBo);
        return GroupBo.to(newGroup);
    }

    public GroupMember createGroupMember(GroupMember groupMember) throws RiceIllegalArgumentException {
        this.incomingParamCheck(groupMember, "groupMember");
        if (StringUtils.isNotBlank((String)groupMember.getId()) && this.getGroupMemberBo(groupMember.getId()) != null) {
            throw new RiceIllegalArgumentException("the groupMember to create already exists: " + groupMember);
        }
        GroupMemberBo bo = GroupMemberBo.from(groupMember);
        GroupBo groupBo = this.getGroupBo(groupMember.getGroupId());
        groupBo.getMembers().add(bo);
        groupBo = this.saveGroup(groupBo);
        for (GroupMemberBo member : groupBo.getMembers()) {
            if (!member.getMemberId().equals(groupMember.getMemberId()) || !member.getType().equals((Object)groupMember.getType()) || !member.getActiveFromDate().equals((Object)groupMember.getActiveFromDate()) || !member.getActiveToDate().equals((Object)groupMember.getActiveToDate())) continue;
            return GroupMemberBo.to(member);
        }
        return GroupMemberBo.to(bo);
    }

    public GroupMember updateGroupMember(@WebParam(name="groupMember") GroupMember groupMember) throws RiceIllegalArgumentException {
        this.incomingParamCheck(groupMember, "groupMember");
        if (StringUtils.isBlank((String)groupMember.getId()) || this.getGroupMemberBo(groupMember.getId()) == null) {
            throw new RiceIllegalArgumentException("the groupMember to update does not exist: " + groupMember);
        }
        GroupMemberBo bo = GroupMemberBo.from(groupMember);
        GroupBo groupBo = this.getGroupBo(groupMember.getGroupId());
        ArrayList<GroupMemberBo> memberList = new ArrayList<GroupMemberBo>();
        for (GroupMemberBo member : groupBo.getMembers()) {
            if (member.getId().equals(bo.getId())) {
                memberList.add(bo);
                continue;
            }
            memberList.add(member);
        }
        groupBo.setMembers(memberList);
        groupBo = this.saveGroup(groupBo);
        for (GroupMemberBo member : groupBo.getMembers()) {
            if (!member.getId().equals(groupMember.getId())) continue;
            return GroupMemberBo.to(member);
        }
        return GroupMemberBo.to(bo);
    }

    public void removeAllMembers(String groupId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(groupId, "groupId");
        GroupService groupService = KimApiServiceLocator.getGroupService();
        List memberPrincipalsBefore = groupService.getMemberPrincipalIds(groupId);
        List<GroupMemberBo> toDeactivate = this.getActiveGroupMembers(groupId, null, null);
        Timestamp today = new Timestamp(System.currentTimeMillis());
        for (GroupMemberBo aToDeactivate : toDeactivate) {
            aToDeactivate.setActiveToDateValue(today);
        }
        this.businessObjectService.save(new ArrayList<GroupMemberBo>(toDeactivate));
        List memberPrincipalsAfter = groupService.getMemberPrincipalIds(groupId);
        if (!CollectionUtils.isEmpty((Collection)memberPrincipalsAfter)) {
            LOG.warn((Object)("after attempting removal of all members, group with id '" + groupId + "' still has principal members"));
        }
        KimImplServiceLocator.getGroupInternalService().updateForWorkgroupChange(groupId, memberPrincipalsBefore, memberPrincipalsAfter);
    }

    public boolean removeGroupFromGroup(String childId, String parentId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(childId, "childId");
        this.incomingParamCheck(parentId, "parentId");
        Timestamp today = new Timestamp(System.currentTimeMillis());
        List<GroupMemberBo> groupMembers = this.getActiveGroupMembers(parentId, childId, KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE);
        if (groupMembers.size() == 1) {
            GroupMemberBo groupMember = groupMembers.get(0);
            groupMember.setActiveToDateValue(today);
            this.businessObjectService.save((PersistableBusinessObject)groupMember);
            return true;
        }
        return false;
    }

    public boolean removePrincipalFromGroup(String principalId, String groupId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(groupId, "groupId");
        List<GroupMemberBo> groupMembers = this.getActiveGroupMembers(groupId, principalId, KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE);
        if (groupMembers.size() == 1) {
            GroupMemberBo member = groupMembers.iterator().next();
            member.setActiveToDateValue(new Timestamp(System.currentTimeMillis()));
            this.businessObjectService.save((PersistableBusinessObject)member);
            KimImplServiceLocator.getGroupInternalService().updateForUserRemovedFromGroup(member.getMemberId(), member.getGroupId());
            return true;
        }
        return false;
    }

    protected GroupBo saveGroup(GroupBo group) {
        GroupBo oldGroup;
        if (group == null) {
            return null;
        }
        if (group.getId() != null && (oldGroup = this.getGroupBo(group.getId())) != null) {
            Timestamp activeTo = new Timestamp(System.currentTimeMillis());
            ArrayList<GroupMemberBo> toReAdd = null;
            if (oldGroup.getMembers() != null) {
                for (GroupMemberBo member : oldGroup.getMembers()) {
                    if (group.getMembers() != null && group.getMembers().contains((Object)member)) continue;
                    member.setActiveToDateValue(activeTo);
                    if (toReAdd == null) {
                        toReAdd = new ArrayList<GroupMemberBo>();
                    }
                    toReAdd.add(member);
                }
            }
            if (toReAdd != null) {
                List<GroupMemberBo> groupMembers = group.getMembers();
                if (groupMembers == null) {
                    groupMembers = new ArrayList<GroupMemberBo>(toReAdd.size());
                }
                group.setMembers(groupMembers);
            }
        }
        return KimImplServiceLocator.getGroupInternalService().saveWorkgroup(group);
    }

    private List<GroupMemberBo> getActiveGroupMembers(String parentId, String childId, MemberType memberType) {
        final Date today = new Date(System.currentTimeMillis());
        if (childId != null && memberType == null) {
            throw new RiceRuntimeException("memberType must be non-null if childId is non-null");
        }
        HashMap<String, String> criteria = new HashMap<String, String>(4);
        criteria.put("groupId", parentId);
        if (childId != null) {
            criteria.put("memberId", childId);
            criteria.put("typeCode", memberType.getCode());
        }
        Collection groupMembers = this.businessObjectService.findMatching(GroupMemberBo.class, criteria);
        CollectionUtils.filter((Collection)groupMembers, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                GroupMemberBo member = (GroupMemberBo)((Object)object);
                return member.getActiveToDate() == null || today.before(member.getActiveToDate().toDate());
            }
        });
        return new ArrayList<GroupMemberBo>(groupMembers);
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setCriteriaLookupService(CriteriaLookupService criteriaLookupService) {
        this.criteriaLookupService = criteriaLookupService;
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }
}

