/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.jws.WebParam;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.CriteriaLookupService;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.address.EntityAddress;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationType;
import org.kuali.rice.kim.api.identity.citizenship.EntityCitizenship;
import org.kuali.rice.kim.api.identity.email.EntityEmail;
import org.kuali.rice.kim.api.identity.employment.EntityEmployment;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityContract;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.entity.EntityDefaultQueryResults;
import org.kuali.rice.kim.api.identity.entity.EntityQueryResults;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifier;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifierType;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.api.identity.name.EntityNameContract;
import org.kuali.rice.kim.api.identity.name.EntityNameQueryResults;
import org.kuali.rice.kim.api.identity.personal.EntityBioDemographics;
import org.kuali.rice.kim.api.identity.personal.EntityEthnicity;
import org.kuali.rice.kim.api.identity.phone.EntityPhone;
import org.kuali.rice.kim.api.identity.principal.EntityNamePrincipalName;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.identity.principal.PrincipalQueryResults;
import org.kuali.rice.kim.api.identity.privacy.EntityPrivacyPreferences;
import org.kuali.rice.kim.api.identity.residency.EntityResidency;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfo;
import org.kuali.rice.kim.api.identity.visa.EntityVisa;
import org.kuali.rice.kim.impl.identity.EntityTypeBo;
import org.kuali.rice.kim.impl.identity.address.EntityAddressBo;
import org.kuali.rice.kim.impl.identity.address.EntityAddressTypeBo;
import org.kuali.rice.kim.impl.identity.affiliation.EntityAffiliationBo;
import org.kuali.rice.kim.impl.identity.affiliation.EntityAffiliationTypeBo;
import org.kuali.rice.kim.impl.identity.citizenship.EntityCitizenshipBo;
import org.kuali.rice.kim.impl.identity.citizenship.EntityCitizenshipStatusBo;
import org.kuali.rice.kim.impl.identity.email.EntityEmailBo;
import org.kuali.rice.kim.impl.identity.email.EntityEmailTypeBo;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentBo;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentStatusBo;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentTypeBo;
import org.kuali.rice.kim.impl.identity.entity.EntityBo;
import org.kuali.rice.kim.impl.identity.external.EntityExternalIdentifierBo;
import org.kuali.rice.kim.impl.identity.external.EntityExternalIdentifierTypeBo;
import org.kuali.rice.kim.impl.identity.name.EntityNameBo;
import org.kuali.rice.kim.impl.identity.name.EntityNameTypeBo;
import org.kuali.rice.kim.impl.identity.personal.EntityBioDemographicsBo;
import org.kuali.rice.kim.impl.identity.personal.EntityEthnicityBo;
import org.kuali.rice.kim.impl.identity.phone.EntityPhoneBo;
import org.kuali.rice.kim.impl.identity.phone.EntityPhoneTypeBo;
import org.kuali.rice.kim.impl.identity.principal.PrincipalBo;
import org.kuali.rice.kim.impl.identity.privacy.EntityPrivacyPreferencesBo;
import org.kuali.rice.kim.impl.identity.residency.EntityResidencyBo;
import org.kuali.rice.kim.impl.identity.type.EntityTypeContactInfoBo;
import org.kuali.rice.kim.impl.identity.visa.EntityVisaBo;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class IdentityServiceImpl
implements IdentityService {
    private CriteriaLookupService criteriaLookupService;
    private BusinessObjectService businessObjectService;
    private static final String UNAVAILABLE = "Unavailable";

    public Entity getEntity(String entityId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(entityId, "entityId");
        EntityBo entity = this.getEntityBo(entityId);
        if (entity == null) {
            return null;
        }
        return EntityBo.to(entity);
    }

    public Entity getEntityByPrincipalId(String principalId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        EntityBo entity = this.getEntityBoByPrincipalId(principalId);
        if (entity == null) {
            return null;
        }
        return EntityBo.to(entity);
    }

    public Entity getEntityByPrincipalName(String principalName) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalName, "principalName");
        EntityBo entity = this.getEntityBoByPrincipalName(principalName);
        if (entity == null) {
            return null;
        }
        return EntityBo.to(entity);
    }

    public Entity getEntityByEmployeeId(String employeeId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(employeeId, "employeeId");
        EntityBo entity = this.getEntityBoByEmployeeId(employeeId);
        if (entity == null) {
            return null;
        }
        return EntityBo.to(entity);
    }

    public EntityDefault getEntityDefault(String entityId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(entityId, "entityId");
        EntityBo entity = this.getEntityBo(entityId);
        if (entity == null) {
            return null;
        }
        return EntityBo.toDefault(entity);
    }

    public EntityDefault getEntityDefaultByPrincipalId(String principalId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        EntityBo entity = this.getEntityBoByPrincipalId(principalId);
        if (entity == null) {
            return null;
        }
        return EntityBo.toDefault(entity);
    }

    public EntityDefault getEntityDefaultByPrincipalName(String principalName) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalName, "principalName");
        EntityBo entity = this.getEntityBoByPrincipalName(principalName);
        if (entity == null) {
            return null;
        }
        return EntityBo.toDefault(entity);
    }

    public EntityDefault getEntityDefaultByEmployeeId(String employeeId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(employeeId, "employeeId");
        EntityBo entity = this.getEntityBoByEmployeeId(employeeId);
        if (entity == null) {
            return null;
        }
        return EntityBo.toDefault(entity);
    }

    public Principal getPrincipalByPrincipalNameAndPassword(String principalName, String password) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalName, "principalName");
        this.incomingParamCheck(password, "password");
        HashMap<String, Object> criteria = new HashMap<String, Object>(3);
        criteria.put("principalName", principalName);
        criteria.put("password", password);
        criteria.put("active", Boolean.TRUE);
        Collection principals = this.businessObjectService.findMatching(PrincipalBo.class, criteria);
        if (!principals.isEmpty()) {
            return PrincipalBo.to((PrincipalBo)((Object)principals.iterator().next()));
        }
        return null;
    }

    public Principal addPrincipalToEntity(Principal principal) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(principal, "principal");
        if (StringUtils.isEmpty((String)principal.getEntityId()) || StringUtils.isBlank((String)principal.getEntityId()) || StringUtils.isEmpty((String)principal.getPrincipalName()) || StringUtils.isBlank((String)principal.getPrincipalName())) {
            throw new RiceIllegalStateException("Principal's entityId and PrincipalName must be populated before creation");
        }
        if (this.getPrincipalByPrincipalName(principal.getPrincipalName()) != null) {
            throw new RiceIllegalStateException("the Principal to create already exists: " + principal);
        }
        PrincipalBo bo = PrincipalBo.from(principal);
        return PrincipalBo.to((PrincipalBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public Principal updatePrincipal(Principal principal) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(principal, "principal");
        PrincipalBo originalPrincipal = null;
        if (StringUtils.isEmpty((String)principal.getEntityId()) || StringUtils.isBlank((String)principal.getEntityId()) || StringUtils.isEmpty((String)principal.getPrincipalName()) || StringUtils.isBlank((String)principal.getPrincipalName())) {
            throw new RiceIllegalStateException("Principal's entityId and PrincipalName must be populated before update");
        }
        originalPrincipal = this.getPrincipalBoByPrincipalName(principal.getPrincipalName());
        if (StringUtils.isEmpty((String)principal.getPrincipalId()) || originalPrincipal == null) {
            throw new RiceIllegalStateException("the Principal to update does not exist: " + principal);
        }
        PrincipalBo bo = PrincipalBo.from(principal);
        bo.setPassword(originalPrincipal.getPassword());
        PrincipalBo updatedPrincipal = (PrincipalBo)this.businessObjectService.save((PersistableBusinessObject)bo);
        if (originalPrincipal.isActive() && !updatedPrincipal.isActive()) {
            KimImplServiceLocator.getRoleInternalService().principalInactivated(updatedPrincipal.getPrincipalId());
        }
        return PrincipalBo.to(updatedPrincipal);
    }

    public Principal inactivatePrincipal(String principalId) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(principalId, "principalId");
        Principal principal = this.getPrincipal(principalId);
        if (principal == null) {
            throw new RiceIllegalStateException("Principal with principalId: " + principalId + " does not exist");
        }
        PrincipalBo bo = PrincipalBo.from(principal);
        bo.setActive(false);
        return PrincipalBo.to((PrincipalBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public Principal inactivatePrincipalByName(String principalName) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(principalName, "principalName");
        Principal principal = this.getPrincipalByPrincipalName(principalName);
        if (principal == null) {
            throw new RiceIllegalStateException("Principal with principalName: " + principalName + " does not exist");
        }
        PrincipalBo bo = PrincipalBo.from(principal);
        bo.setActive(false);
        return PrincipalBo.to((PrincipalBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityTypeContactInfo addEntityTypeContactInfoToEntity(EntityTypeContactInfo entityTypeData) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(entityTypeData, "entityTypeData");
        if (StringUtils.isEmpty((String)entityTypeData.getEntityId()) || StringUtils.isBlank((String)entityTypeData.getEntityId()) || StringUtils.isEmpty((String)entityTypeData.getEntityTypeCode()) || StringUtils.isBlank((String)entityTypeData.getEntityTypeCode())) {
            throw new RiceIllegalStateException("EntityTypeData's entityId and entityTypeCode must be populated before creation");
        }
        if (this.getEntityTypeDataBo(entityTypeData.getEntityId(), entityTypeData.getEntityTypeCode()) != null) {
            throw new RiceIllegalStateException("the entityTypeData to create already exists: " + entityTypeData);
        }
        EntityTypeContactInfoBo bo = EntityTypeContactInfoBo.from(entityTypeData);
        return EntityTypeContactInfoBo.to((EntityTypeContactInfoBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    private EntityTypeContactInfoBo getEntityTypeDataBo(String entityId, String entityTypeCode) {
        HashMap<String, Object> criteria = new HashMap<String, Object>(3);
        criteria.put("entityId", entityId);
        criteria.put("entityTypeCode", entityTypeCode);
        criteria.put("active", Boolean.TRUE);
        return (EntityTypeContactInfoBo)this.businessObjectService.findByPrimaryKey(EntityTypeContactInfoBo.class, criteria);
    }

    public EntityTypeContactInfo updateEntityTypeContactInfo(EntityTypeContactInfo entityTypeContactInfo) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(entityTypeContactInfo, "entityTypeContactInfo");
        if (StringUtils.isBlank((String)entityTypeContactInfo.getEntityId()) || StringUtils.isEmpty((String)entityTypeContactInfo.getEntityId()) || StringUtils.isBlank((String)entityTypeContactInfo.getEntityTypeCode()) || StringUtils.isEmpty((String)entityTypeContactInfo.getEntityTypeCode())) {
            throw new RiceIllegalStateException("EntityTypeData's entityId and entityTypeCode must be populated before update");
        }
        if (this.getEntityTypeDataBo(entityTypeContactInfo.getEntityId(), entityTypeContactInfo.getEntityTypeCode()) == null) {
            throw new RiceIllegalStateException("the entityTypeData to update does not exist: " + entityTypeContactInfo);
        }
        EntityTypeContactInfoBo bo = EntityTypeContactInfoBo.from(entityTypeContactInfo);
        return EntityTypeContactInfoBo.to((EntityTypeContactInfoBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityTypeContactInfo inactivateEntityTypeContactInfo(String entityId, String entityTypeCode) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(entityId, "entityId");
        this.incomingParamCheck(entityTypeCode, "entityTypeCode");
        EntityTypeContactInfoBo bo = this.getEntityTypeDataBo(entityId, entityTypeCode);
        if (bo == null) {
            throw new RiceIllegalStateException("EntityTypeData with entityId: " + entityId + " entityTypeCode: " + entityTypeCode + " does not exist");
        }
        bo.setActive(false);
        return EntityTypeContactInfoBo.to((EntityTypeContactInfoBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    private EntityAddressBo getEntityAddressBo(String entityId, String entityTypeCode, String addressTypeCode) {
        HashMap<String, Object> criteria = new HashMap<String, Object>(4);
        criteria.put("entityId", entityId);
        criteria.put("entityTypeCode", entityTypeCode);
        criteria.put("addressTypeCode", addressTypeCode);
        criteria.put("active", Boolean.TRUE);
        return (EntityAddressBo)this.businessObjectService.findByPrimaryKey(EntityAddressBo.class, criteria);
    }

    private EntityAddressBo getEntityAddressBo(String addressId) {
        HashMap<String, String> criteria = new HashMap<String, String>(4);
        criteria.put("id", addressId);
        return (EntityAddressBo)this.businessObjectService.findByPrimaryKey(EntityAddressBo.class, criteria);
    }

    public EntityAddress addAddressToEntity(EntityAddress address) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(address, "address");
        if (StringUtils.isEmpty((String)address.getEntityId()) || StringUtils.isBlank((String)address.getEntityId()) || StringUtils.isEmpty((String)address.getEntityTypeCode()) || StringUtils.isBlank((String)address.getEntityTypeCode())) {
            throw new RiceIllegalStateException("Address's entityId and entityTypeCode must be populated before creation");
        }
        if (address.getAddressType() == null) {
            throw new RiceIllegalStateException("Address's type must be populated before creation");
        }
        if (this.getEntityAddressBo(address.getEntityId(), address.getEntityTypeCode(), address.getAddressType().getCode()) != null) {
            throw new RiceIllegalStateException("the address to create already exists: " + address);
        }
        EntityAddressBo bo = EntityAddressBo.from(address);
        return EntityAddressBo.to((EntityAddressBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityAddress updateAddress(EntityAddress address) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(address, "address");
        if (StringUtils.isEmpty((String)address.getEntityId()) || StringUtils.isBlank((String)address.getEntityId()) || StringUtils.isEmpty((String)address.getEntityTypeCode()) || StringUtils.isBlank((String)address.getEntityTypeCode())) {
            throw new RiceIllegalStateException("Address's entityId and entityTypeCode must be populated before creation");
        }
        if (address.getAddressType() == null) {
            throw new RiceIllegalStateException("Address's type must be populated before creation");
        }
        if (StringUtils.isEmpty((String)address.getId()) || this.getEntityAddressBo(address.getEntityId(), address.getEntityTypeCode(), address.getAddressType().getCode()) == null) {
            throw new RiceIllegalStateException("the address to update does not exists: " + address);
        }
        EntityAddressBo bo = EntityAddressBo.from(address);
        return EntityAddressBo.to((EntityAddressBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityAddress inactivateAddress(String addressId) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(addressId, "addressId");
        EntityAddressBo bo = this.getEntityAddressBo(addressId);
        if (bo == null) {
            throw new RiceIllegalStateException("Address with addressId: " + addressId + " does not exist");
        }
        bo.setActive(false);
        return EntityAddressBo.to((EntityAddressBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    private EntityEmailBo getEntityEmailBo(String entityId, String entityTypeCode, String emailTypeCode) {
        HashMap<String, Object> criteria = new HashMap<String, Object>(4);
        criteria.put("entityId", entityId);
        criteria.put("entityTypeCode", entityTypeCode);
        criteria.put("emailTypeCode", emailTypeCode);
        criteria.put("active", Boolean.TRUE);
        return (EntityEmailBo)this.businessObjectService.findByPrimaryKey(EntityEmailBo.class, criteria);
    }

    private EntityEmailBo getEntityEmailBo(String emailId) {
        HashMap<String, String> criteria = new HashMap<String, String>(4);
        criteria.put("id", emailId);
        return (EntityEmailBo)this.businessObjectService.findByPrimaryKey(EntityEmailBo.class, criteria);
    }

    public EntityEmail addEmailToEntity(EntityEmail email) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(email, "email");
        if (StringUtils.isEmpty((String)email.getEntityId()) || StringUtils.isBlank((String)email.getEntityId()) || StringUtils.isEmpty((String)email.getEntityTypeCode()) || StringUtils.isBlank((String)email.getEntityTypeCode())) {
            throw new RiceIllegalStateException("Email's entityId and entityTypeCode must be populated before creation");
        }
        if (email.getEmailType() == null) {
            throw new RiceIllegalStateException("Email's type must be populated before creation");
        }
        if (this.getEntityEmailBo(email.getEntityId(), email.getEntityTypeCode(), email.getEmailType().getCode()) != null) {
            throw new RiceIllegalStateException("the email to create already exists: " + email);
        }
        EntityEmailBo bo = EntityEmailBo.from(email);
        return EntityEmailBo.to((EntityEmailBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityEmail updateEmail(EntityEmail email) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(email, "email");
        if (StringUtils.isEmpty((String)email.getEntityId()) || StringUtils.isBlank((String)email.getEntityId()) || StringUtils.isEmpty((String)email.getEntityTypeCode()) || StringUtils.isBlank((String)email.getEntityTypeCode())) {
            throw new RiceIllegalStateException("Email's entityId and entityTypeCode must be populated before creation");
        }
        if (email.getEmailType() == null) {
            throw new RiceIllegalStateException("Email's type must be populated before creation");
        }
        if (StringUtils.isEmpty((String)email.getId()) || this.getEntityEmailBo(email.getEntityId(), email.getEntityTypeCode(), email.getEmailType().getCode()) == null) {
            throw new RiceIllegalStateException("the email to update does not exists: " + email);
        }
        EntityEmailBo bo = EntityEmailBo.from(email);
        return EntityEmailBo.to((EntityEmailBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityEmail inactivateEmail(String emailId) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(emailId, "emailId");
        EntityEmailBo bo = this.getEntityEmailBo(emailId);
        if (bo == null) {
            throw new RiceIllegalStateException("Email with emailId: " + emailId + " does not exist");
        }
        bo.setActive(false);
        return EntityEmailBo.to((EntityEmailBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    private EntityPhoneBo getEntityPhoneBo(String entityId, String entityTypeCode, String phoneTypeCode) {
        HashMap<String, Object> criteria = new HashMap<String, Object>(4);
        criteria.put("entityId", entityId);
        criteria.put("entityTypeCode", entityTypeCode);
        criteria.put("phoneTypeCode", phoneTypeCode);
        criteria.put("active", Boolean.TRUE);
        return (EntityPhoneBo)this.businessObjectService.findByPrimaryKey(EntityPhoneBo.class, criteria);
    }

    private EntityPhoneBo getEntityPhoneBo(String phoneId) {
        HashMap<String, String> criteria = new HashMap<String, String>(4);
        criteria.put("id", phoneId);
        return (EntityPhoneBo)this.businessObjectService.findByPrimaryKey(EntityPhoneBo.class, criteria);
    }

    public EntityPhone addPhoneToEntity(EntityPhone phone) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(phone, "phone");
        if (StringUtils.isEmpty((String)phone.getEntityId()) || StringUtils.isBlank((String)phone.getEntityId()) || StringUtils.isEmpty((String)phone.getEntityTypeCode()) || StringUtils.isBlank((String)phone.getEntityTypeCode())) {
            throw new RiceIllegalStateException("Phone's entityId and entityTypeCode must be populated before creation");
        }
        if (phone.getPhoneType() == null) {
            throw new RiceIllegalStateException("Phone's type must be populated before creation");
        }
        if (this.getEntityPhoneBo(phone.getEntityId(), phone.getEntityTypeCode(), phone.getPhoneType().getCode()) != null) {
            throw new RiceIllegalStateException("the phone to create already exists: " + phone);
        }
        EntityPhoneBo bo = EntityPhoneBo.from(phone);
        return EntityPhoneBo.to((EntityPhoneBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityPhone updatePhone(EntityPhone phone) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(phone, "phone");
        if (StringUtils.isEmpty((String)phone.getEntityId()) || StringUtils.isBlank((String)phone.getEntityId()) || StringUtils.isEmpty((String)phone.getEntityTypeCode()) || StringUtils.isBlank((String)phone.getEntityTypeCode())) {
            throw new RiceIllegalStateException("Phone's entityId and entityTypeCode must be populated before creation");
        }
        if (phone.getPhoneType() == null) {
            throw new RiceIllegalStateException("Phone's type must be populated before creation");
        }
        if (StringUtils.isEmpty((String)phone.getId()) || this.getEntityPhoneBo(phone.getEntityId(), phone.getEntityTypeCode(), phone.getPhoneType().getCode()) == null) {
            throw new RiceIllegalStateException("the phone to update does not exists: " + phone);
        }
        EntityPhoneBo bo = EntityPhoneBo.from(phone);
        return EntityPhoneBo.to((EntityPhoneBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityPhone inactivatePhone(String phoneId) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(phoneId, "phoneId");
        EntityPhoneBo bo = this.getEntityPhoneBo(phoneId);
        if (bo == null) {
            throw new RiceIllegalStateException("Phone with phoneId: " + phoneId + " does not exist");
        }
        bo.setActive(false);
        return EntityPhoneBo.to((EntityPhoneBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    private EntityExternalIdentifierBo getEntityExternalIdentifierBo(String entityId, String externalIdentifierTypeCode) {
        HashMap<String, String> criteria = new HashMap<String, String>(4);
        criteria.put("entityId", entityId);
        criteria.put("externalIdentifierTypeCode", externalIdentifierTypeCode);
        return (EntityExternalIdentifierBo)this.businessObjectService.findByPrimaryKey(EntityExternalIdentifierBo.class, criteria);
    }

    public EntityExternalIdentifier addExternalIdentifierToEntity(EntityExternalIdentifier externalId) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(externalId, "externalId");
        if (StringUtils.isEmpty((String)externalId.getEntityId()) || StringUtils.isBlank((String)externalId.getEntityId()) || StringUtils.isEmpty((String)externalId.getExternalIdentifierTypeCode()) || StringUtils.isBlank((String)externalId.getExternalIdentifierTypeCode())) {
            throw new RiceIllegalStateException("EntityExternalIdentifier's entityId and entityTypeCode must be populated before creation");
        }
        if (this.getEntityExternalIdentifierBo(externalId.getEntityId(), externalId.getExternalIdentifierTypeCode()) != null) {
            throw new RiceIllegalStateException("the EntityExternalIdentifier to create already exists: " + externalId);
        }
        EntityExternalIdentifierBo bo = EntityExternalIdentifierBo.from(externalId);
        return EntityExternalIdentifierBo.to((EntityExternalIdentifierBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityExternalIdentifier updateExternalIdentifier(EntityExternalIdentifier externalId) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(externalId, "externalId");
        if (StringUtils.isEmpty((String)externalId.getEntityId()) || StringUtils.isBlank((String)externalId.getEntityId()) || StringUtils.isEmpty((String)externalId.getExternalIdentifierTypeCode()) || StringUtils.isBlank((String)externalId.getExternalIdentifierTypeCode())) {
            throw new RiceIllegalStateException("EntityExternalIdentifier's entityId and externalIdentifierTypeCode must be populated before creation");
        }
        if (StringUtils.isEmpty((String)externalId.getId()) || this.getEntityExternalIdentifierBo(externalId.getEntityId(), externalId.getExternalIdentifierTypeCode()) == null) {
            throw new RiceIllegalStateException("the external identifier to update does not exist: " + externalId);
        }
        EntityExternalIdentifierBo bo = EntityExternalIdentifierBo.from(externalId);
        return EntityExternalIdentifierBo.to((EntityExternalIdentifierBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    private EntityAffiliationBo getEntityAffiliationBo(String id) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("id", id);
        return (EntityAffiliationBo)this.businessObjectService.findByPrimaryKey(EntityAffiliationBo.class, criteria);
    }

    public EntityAffiliation addAffiliationToEntity(EntityAffiliation affiliation) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(affiliation, "affiliation");
        if (StringUtils.isEmpty((String)affiliation.getEntityId()) || StringUtils.isBlank((String)affiliation.getEntityId())) {
            throw new RiceIllegalStateException("Affiliation's entityId must be populated before creation");
        }
        if (affiliation.getAffiliationType() == null) {
            throw new RiceIllegalStateException("EntityAffiliation's type must be populated before creation");
        }
        if (this.getEntityAffiliationBo(affiliation.getId()) != null) {
            throw new RiceIllegalStateException("the EntityAffiliation to create already exists: " + affiliation);
        }
        EntityAffiliationBo bo = EntityAffiliationBo.from(affiliation);
        return EntityAffiliationBo.to((EntityAffiliationBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityAffiliation updateAffiliation(EntityAffiliation affiliation) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(affiliation, "affiliation");
        if (StringUtils.isEmpty((String)affiliation.getEntityId()) || StringUtils.isBlank((String)affiliation.getEntityId())) {
            throw new RiceIllegalStateException("Affiliation's entityId must be populated before creation");
        }
        if (affiliation.getAffiliationType() == null) {
            throw new RiceIllegalStateException("EntityAffiliation's type must be populated before creation");
        }
        if (StringUtils.isEmpty((String)affiliation.getId()) || this.getEntityAffiliationBo(affiliation.getId()) == null) {
            throw new RiceIllegalStateException("the EntityAffiliation to update already exists: " + affiliation);
        }
        EntityAffiliationBo bo = EntityAffiliationBo.from(affiliation);
        return EntityAffiliationBo.to((EntityAffiliationBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityAffiliation inactivateAffiliation(String id) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(id, "id");
        EntityAffiliationBo bo = this.getEntityAffiliationBo(id);
        if (bo == null) {
            throw new RiceIllegalStateException("EntityAffiliation with id: " + id + " does not exist");
        }
        bo.setActive(false);
        return EntityAffiliationBo.to((EntityAffiliationBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityQueryResults findEntities(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        GenericQueryResults results = this.criteriaLookupService.lookup(EntityBo.class, queryByCriteria);
        EntityQueryResults.Builder builder = EntityQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<Entity.Builder> ims = new ArrayList<Entity.Builder>();
        for (EntityBo bo : results.getResults()) {
            ims.add(Entity.Builder.create((EntityContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public EntityDefaultQueryResults findEntityDefaults(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        GenericQueryResults results = this.criteriaLookupService.lookup(EntityBo.class, queryByCriteria);
        EntityDefaultQueryResults.Builder builder = EntityDefaultQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<EntityDefault.Builder> ims = new ArrayList<EntityDefault.Builder>();
        for (EntityBo bo : results.getResults()) {
            ims.add(EntityDefault.Builder.create((EntityContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    protected EntityNameQueryResults findNames(QueryByCriteria queryByCriteria) {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        GenericQueryResults results = this.criteriaLookupService.lookup(EntityNameBo.class, queryByCriteria);
        EntityNameQueryResults.Builder builder = EntityNameQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<EntityName.Builder> ims = new ArrayList<EntityName.Builder>();
        for (EntityNameBo bo : results.getResults()) {
            ims.add(EntityName.Builder.create((EntityNameContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public EntityPrivacyPreferences getEntityPrivacyPreferences(String entityId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(entityId, "entityId");
        HashMap<String, String> criteria = new HashMap<String, String>(1);
        criteria.put("entityId", entityId);
        return EntityPrivacyPreferencesBo.to((EntityPrivacyPreferencesBo)this.businessObjectService.findByPrimaryKey(EntityPrivacyPreferencesBo.class, criteria));
    }

    public Principal getPrincipal(String principalId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        PrincipalBo principal = this.getPrincipalBo(principalId);
        if (principal == null) {
            return null;
        }
        if (StringUtils.isBlank((String)principal.getPrincipalName())) {
            principal.setPrincipalName(UNAVAILABLE);
        }
        return PrincipalBo.to(principal);
    }

    public List<Principal> getPrincipals(List<String> principalIds) {
        ArrayList<Principal> ret = new ArrayList<Principal>();
        for (String p : principalIds) {
            Principal principalInfo = this.getPrincipal(p);
            if (principalInfo == null) continue;
            ret.add(principalInfo);
        }
        return ret;
    }

    private PrincipalBo getPrincipalBo(String principalId) {
        HashMap<String, String> criteria = new HashMap<String, String>(1);
        criteria.put("principalId", principalId);
        return (PrincipalBo)this.businessObjectService.findByPrimaryKey(PrincipalBo.class, criteria);
    }

    private EntityBo getEntityBo(String entityId) {
        return (EntityBo)this.businessObjectService.findByPrimaryKey(EntityBo.class, Collections.singletonMap("id", entityId));
    }

    public Principal getPrincipalByPrincipalName(String principalName) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalName, "principalName");
        return PrincipalBo.to(this.getPrincipalBoByPrincipalName(principalName));
    }

    private PrincipalBo getPrincipalBoByPrincipalName(String principalName) throws RiceIllegalArgumentException {
        HashMap<String, String> criteria = new HashMap<String, String>(1);
        criteria.put("principalName", principalName.toLowerCase());
        Collection principals = this.businessObjectService.findMatching(PrincipalBo.class, criteria);
        if (!principals.isEmpty() && principals.size() == 1) {
            return (PrincipalBo)((Object)principals.iterator().next());
        }
        return null;
    }

    public List<Principal> getPrincipalsByEntityId(String entityId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(entityId, "entityId");
        ArrayList<Principal> principals = new ArrayList<Principal>();
        HashMap<String, String> criteria = new HashMap<String, String>(2);
        criteria.put("entityId", entityId);
        Collection principalBos = this.businessObjectService.findMatching(PrincipalBo.class, criteria);
        if (principalBos != null && !principalBos.isEmpty()) {
            for (PrincipalBo principalBo : principalBos) {
                Principal principal = PrincipalBo.to(principalBo);
                principals.add(principal);
            }
            return principals;
        }
        return null;
    }

    public List<Principal> getPrincipalsByEmployeeId(String employeeId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(employeeId, "employeeId");
        ArrayList<Principal> principals = new ArrayList<Principal>();
        HashMap<String, String> criteria = new HashMap<String, String>(2);
        criteria.put("employeeId", employeeId);
        Collection entityEmploymentBos = this.businessObjectService.findMatching(EntityEmploymentBo.class, criteria);
        if (entityEmploymentBos != null && !entityEmploymentBos.isEmpty()) {
            ArrayList<String> entityIds = new ArrayList<String>();
            for (EntityEmploymentBo entityEmploymentBo : entityEmploymentBos) {
                String entityId = entityEmploymentBo.getEntityId();
                if (!StringUtils.isNotBlank((String)entityId) || entityIds.contains(entityId)) continue;
                entityIds.add(entityId);
            }
            for (String entityId : entityIds) {
                List<Principal> principalsForEntity = this.getPrincipalsByEntityId(entityId);
                if (principalsForEntity == null || principalsForEntity.isEmpty()) continue;
                principals.addAll(principalsForEntity);
            }
            if (!principals.isEmpty()) {
                return principals;
            }
        }
        return null;
    }

    protected EntityBo getEntityBoByPrincipalName(String principalName) {
        if (StringUtils.isBlank((String)principalName)) {
            return null;
        }
        return this.getEntityByKeyValue("principals.principalName", principalName.toLowerCase());
    }

    protected EntityBo getEntityBoByPrincipalId(String principalId) {
        if (StringUtils.isBlank((String)principalId)) {
            return null;
        }
        return this.getEntityByKeyValue("principals.principalId", principalId);
    }

    protected EntityBo getEntityBoByEmployeeId(String employeeId) {
        if (StringUtils.isBlank((String)employeeId)) {
            return null;
        }
        return this.getEntityByKeyValue("employmentInformation.employeeId", employeeId);
    }

    protected EntityBo getEntityByKeyValue(String key, String value) {
        HashMap<String, String> criteria = new HashMap<String, String>(1);
        criteria.put(key, value);
        Collection entities = this.businessObjectService.findMatching(EntityBo.class, criteria);
        if (entities != null && entities.size() >= 1) {
            return (EntityBo)((Object)entities.iterator().next());
        }
        return null;
    }

    public CodedAttribute getAddressType(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityAddressTypeBo impl = (EntityAddressTypeBo)this.businessObjectService.findBySinglePrimaryKey(EntityAddressTypeBo.class, (Object)code);
        if (impl == null) {
            return null;
        }
        return EntityAddressTypeBo.to(impl);
    }

    public List<CodedAttribute> findAllAddressTypes() {
        List bos = (List)this.businessObjectService.findMatching(EntityAddressTypeBo.class, Collections.singletonMap("active", Boolean.TRUE));
        ArrayList<CodedAttribute> codedAttributes = new ArrayList<CodedAttribute>();
        for (EntityAddressTypeBo bo : bos) {
            codedAttributes.add(EntityAddressTypeBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public EntityAffiliationType getAffiliationType(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityAffiliationTypeBo impl = (EntityAffiliationTypeBo)this.businessObjectService.findBySinglePrimaryKey(EntityAffiliationTypeBo.class, (Object)code);
        if (impl == null) {
            return null;
        }
        return EntityAffiliationTypeBo.to(impl);
    }

    public List<EntityAffiliationType> findAllAffiliationTypes() {
        List bos = (List)this.businessObjectService.findMatching(EntityAffiliationTypeBo.class, Collections.singletonMap("active", Boolean.TRUE));
        ArrayList<EntityAffiliationType> codedAttributes = new ArrayList<EntityAffiliationType>();
        for (EntityAffiliationTypeBo bo : bos) {
            codedAttributes.add(EntityAffiliationTypeBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public CodedAttribute getCitizenshipStatus(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityCitizenshipStatusBo impl = (EntityCitizenshipStatusBo)this.businessObjectService.findBySinglePrimaryKey(EntityCitizenshipStatusBo.class, (Object)code);
        if (impl == null) {
            return null;
        }
        return EntityCitizenshipStatusBo.to(impl);
    }

    public List<CodedAttribute> findAllCitizenshipStatuses() {
        List bos = (List)this.businessObjectService.findMatching(EntityCitizenshipStatusBo.class, Collections.singletonMap("active", Boolean.TRUE));
        ArrayList<CodedAttribute> codedAttributes = new ArrayList<CodedAttribute>();
        for (EntityCitizenshipStatusBo bo : bos) {
            codedAttributes.add(EntityCitizenshipStatusBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public CodedAttribute getEmailType(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityEmailTypeBo impl = (EntityEmailTypeBo)this.businessObjectService.findBySinglePrimaryKey(EntityEmailTypeBo.class, (Object)code);
        if (impl == null) {
            return null;
        }
        return EntityEmailTypeBo.to(impl);
    }

    public List<CodedAttribute> findAllEmailTypes() {
        List bos = (List)this.businessObjectService.findMatching(EntityEmailTypeBo.class, Collections.singletonMap("active", Boolean.TRUE));
        ArrayList<CodedAttribute> codedAttributes = new ArrayList<CodedAttribute>();
        for (EntityEmailTypeBo bo : bos) {
            codedAttributes.add(EntityEmailTypeBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public PrincipalQueryResults findPrincipals(@WebParam(name="query") QueryByCriteria query) throws RiceIllegalArgumentException {
        this.incomingParamCheck(query, "query");
        GenericQueryResults results = this.criteriaLookupService.lookup(PrincipalBo.class, query);
        PrincipalQueryResults.Builder builder = PrincipalQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<Principal.Builder> ims = new ArrayList<Principal.Builder>();
        for (PrincipalBo bo : results.getResults()) {
            ims.add(Principal.Builder.create((PrincipalContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public CodedAttribute getEmploymentStatus(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityEmploymentStatusBo impl = (EntityEmploymentStatusBo)this.businessObjectService.findBySinglePrimaryKey(EntityEmploymentStatusBo.class, (Object)code);
        if (impl == null) {
            return null;
        }
        return EntityEmploymentStatusBo.to(impl);
    }

    public List<CodedAttribute> findAllEmploymentStatuses() {
        List bos = (List)this.businessObjectService.findMatching(EntityEmploymentStatusBo.class, Collections.singletonMap("active", Boolean.TRUE));
        ArrayList<CodedAttribute> codedAttributes = new ArrayList<CodedAttribute>();
        for (EntityEmploymentStatusBo bo : bos) {
            codedAttributes.add(EntityEmploymentStatusBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public CodedAttribute getEmploymentType(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityEmploymentTypeBo impl = (EntityEmploymentTypeBo)this.businessObjectService.findBySinglePrimaryKey(EntityEmploymentTypeBo.class, (Object)code);
        if (impl == null) {
            return null;
        }
        return EntityEmploymentTypeBo.to(impl);
    }

    public List<CodedAttribute> findAllEmploymentTypes() {
        List bos = (List)this.businessObjectService.findMatching(EntityEmploymentTypeBo.class, Collections.singletonMap("active", Boolean.TRUE));
        ArrayList<CodedAttribute> codedAttributes = new ArrayList<CodedAttribute>();
        for (EntityEmploymentTypeBo bo : bos) {
            codedAttributes.add(EntityEmploymentTypeBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public CodedAttribute getNameType(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityNameTypeBo impl = (EntityNameTypeBo)this.businessObjectService.findBySinglePrimaryKey(EntityNameTypeBo.class, (Object)code);
        if (impl == null) {
            return null;
        }
        return EntityNameTypeBo.to(impl);
    }

    public List<CodedAttribute> findAllNameTypes() {
        List bos = (List)this.businessObjectService.findMatching(EntityNameTypeBo.class, Collections.singletonMap("active", Boolean.TRUE));
        ArrayList<CodedAttribute> codedAttributes = new ArrayList<CodedAttribute>();
        for (EntityNameTypeBo bo : bos) {
            codedAttributes.add(EntityNameTypeBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public CodedAttribute getEntityType(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityTypeBo impl = (EntityTypeBo)this.businessObjectService.findBySinglePrimaryKey(EntityTypeBo.class, (Object)code);
        if (impl == null) {
            return null;
        }
        return EntityTypeBo.to(impl);
    }

    public List<CodedAttribute> findAllEntityTypes() {
        List bos = (List)this.businessObjectService.findMatching(EntityTypeBo.class, Collections.singletonMap("active", Boolean.TRUE));
        ArrayList<CodedAttribute> codedAttributes = new ArrayList<CodedAttribute>();
        for (EntityTypeBo bo : bos) {
            codedAttributes.add(EntityTypeBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public EntityExternalIdentifierType getExternalIdentifierType(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityExternalIdentifierTypeBo impl = (EntityExternalIdentifierTypeBo)this.businessObjectService.findBySinglePrimaryKey(EntityExternalIdentifierTypeBo.class, (Object)code);
        if (impl == null) {
            return null;
        }
        return EntityExternalIdentifierTypeBo.to(impl);
    }

    public List<EntityExternalIdentifierType> findAllExternalIdendtifierTypes() {
        List bos = (List)this.businessObjectService.findMatching(EntityExternalIdentifierTypeBo.class, Collections.singletonMap("active", Boolean.TRUE));
        ArrayList<EntityExternalIdentifierType> codedAttributes = new ArrayList<EntityExternalIdentifierType>();
        for (EntityExternalIdentifierTypeBo bo : bos) {
            codedAttributes.add(EntityExternalIdentifierTypeBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public CodedAttribute getPhoneType(String code) throws RiceIllegalArgumentException {
        this.incomingParamCheck(code, "code");
        EntityPhoneTypeBo impl = (EntityPhoneTypeBo)this.businessObjectService.findBySinglePrimaryKey(EntityPhoneTypeBo.class, (Object)code);
        if (impl == null) {
            return null;
        }
        return EntityPhoneTypeBo.to(impl);
    }

    public List<CodedAttribute> findAllPhoneTypes() {
        List bos = (List)this.businessObjectService.findMatching(EntityPhoneTypeBo.class, Collections.singletonMap("active", Boolean.TRUE));
        ArrayList<CodedAttribute> codedAttributes = new ArrayList<CodedAttribute>();
        for (EntityPhoneTypeBo bo : bos) {
            codedAttributes.add(EntityPhoneTypeBo.to(bo));
        }
        return Collections.unmodifiableList(codedAttributes);
    }

    public Entity createEntity(Entity entity) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(entity, "entity");
        if (StringUtils.isNotBlank((String)entity.getId()) && this.getEntity(entity.getId()) != null) {
            throw new RiceIllegalStateException("the Entity to create already exists: " + entity);
        }
        EntityBo bo = EntityBo.from(entity);
        return EntityBo.to((EntityBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public Entity updateEntity(Entity entity) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(entity, "entity");
        EntityBo oldBo = null;
        HashMap<String, String> passwdMap = new HashMap<String, String>();
        if (StringUtils.isBlank((String)entity.getId())) {
            throw new RiceIllegalStateException("the Entity does not exist: " + entity);
        }
        oldBo = this.getEntityBo(entity.getId());
        if (oldBo == null) {
            throw new RiceIllegalStateException("the Entity does not exist: " + entity);
        }
        for (PrincipalBo principalBo : oldBo.getPrincipals()) {
            passwdMap.put(principalBo.getPrincipalId(), principalBo.getPassword());
        }
        EntityBo bo = EntityBo.from(entity);
        for (PrincipalBo principal : bo.getPrincipals()) {
            principal.setPassword((String)passwdMap.get(principal.getPrincipalId()));
        }
        return EntityBo.to((EntityBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public Entity inactivateEntity(String entityId) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(entityId, "entityId");
        EntityBo entity = this.getEntityBo(entityId);
        if (entity == null) {
            throw new RiceIllegalStateException("an Entity does not exist for entityId: " + entityId);
        }
        entity.setActive(false);
        return EntityBo.to((EntityBo)this.businessObjectService.save((PersistableBusinessObject)entity));
    }

    public EntityPrivacyPreferences addPrivacyPreferencesToEntity(EntityPrivacyPreferences privacyPreferences) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(privacyPreferences, "privacyPreferences");
        if (StringUtils.isEmpty((String)privacyPreferences.getEntityId()) || StringUtils.isBlank((String)privacyPreferences.getEntityId())) {
            throw new RiceIllegalStateException("PrivacyPreferences' entityId must be populated before creation");
        }
        if (this.getEntityPrivacyPreferences(privacyPreferences.getEntityId()) != null) {
            throw new RiceIllegalStateException("the PrivacyPreferences to create already exists: " + privacyPreferences);
        }
        EntityPrivacyPreferencesBo bo = EntityPrivacyPreferencesBo.from(privacyPreferences);
        return EntityPrivacyPreferencesBo.to((EntityPrivacyPreferencesBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityPrivacyPreferences updatePrivacyPreferences(EntityPrivacyPreferences privacyPreferences) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(privacyPreferences, "privacyPreferences");
        if (StringUtils.isEmpty((String)privacyPreferences.getEntityId()) || StringUtils.isBlank((String)privacyPreferences.getEntityId())) {
            throw new RiceIllegalStateException("PrivacyPreferences' entityId must be populated before update");
        }
        if (this.getEntityPrivacyPreferences(privacyPreferences.getEntityId()) == null) {
            throw new RiceIllegalStateException("the PrivacyPreferences to update does not exist: " + privacyPreferences);
        }
        EntityPrivacyPreferencesBo bo = EntityPrivacyPreferencesBo.from(privacyPreferences);
        return EntityPrivacyPreferencesBo.to((EntityPrivacyPreferencesBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    private EntityCitizenshipBo getEntityCitizenshipBo(String entityId, String citizenshipStatusCode) {
        if (StringUtils.isEmpty((String)entityId) || StringUtils.isEmpty((String)citizenshipStatusCode)) {
            return null;
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>(4);
        criteria.put("entityId", entityId);
        criteria.put("statusCode", citizenshipStatusCode);
        criteria.put("active", Boolean.TRUE);
        return (EntityCitizenshipBo)this.businessObjectService.findByPrimaryKey(EntityCitizenshipBo.class, criteria);
    }

    private EntityCitizenshipBo getEntityCitizenshipBo(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("id", id);
        criteria.put("active", Boolean.TRUE);
        return (EntityCitizenshipBo)this.businessObjectService.findByPrimaryKey(EntityCitizenshipBo.class, criteria);
    }

    public EntityCitizenship addCitizenshipToEntity(EntityCitizenship citizenship) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(citizenship, "citizenship");
        if (StringUtils.isEmpty((String)citizenship.getEntityId()) || StringUtils.isBlank((String)citizenship.getEntityId())) {
            throw new RiceIllegalStateException("Citizenship's entityId must be populated before creation");
        }
        if (citizenship.getStatus() == null) {
            throw new RiceIllegalStateException("Citizenship's status must be populated before creation");
        }
        if (this.getEntityCitizenshipBo(citizenship.getEntityId(), citizenship.getStatus().getCode()) != null) {
            throw new RiceIllegalStateException("the EntityCitizenship to create already exists: " + citizenship);
        }
        EntityCitizenshipBo bo = EntityCitizenshipBo.from(citizenship);
        return EntityCitizenshipBo.to((EntityCitizenshipBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityCitizenship updateCitizenship(EntityCitizenship citizenship) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(citizenship, "citizenship");
        if (StringUtils.isEmpty((String)citizenship.getEntityId()) || StringUtils.isBlank((String)citizenship.getEntityId())) {
            throw new RiceIllegalStateException("Email's entityId must be populated before creation");
        }
        if (citizenship.getStatus() == null) {
            throw new RiceIllegalStateException("Citizenship's status must be populated before creation");
        }
        if (this.getEntityCitizenshipBo(citizenship.getEntityId(), citizenship.getStatus().getCode()) == null) {
            throw new RiceIllegalStateException("the EntityCitizenship to update does not exist: " + citizenship);
        }
        EntityCitizenshipBo bo = EntityCitizenshipBo.from(citizenship);
        return EntityCitizenshipBo.to((EntityCitizenshipBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityCitizenship inactivateCitizenship(String id) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(id, "id");
        EntityCitizenshipBo bo = this.getEntityCitizenshipBo(id);
        if (bo == null) {
            throw new RiceIllegalStateException("the EntityCitizenship with id: " + id + " does not exist");
        }
        bo.setActive(false);
        return EntityCitizenshipBo.to((EntityCitizenshipBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    private EntityEthnicityBo getEntityEthnicityBo(String ethnicityId) {
        if (StringUtils.isEmpty((String)ethnicityId)) {
            return null;
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("id", ethnicityId);
        return (EntityEthnicityBo)this.businessObjectService.findByPrimaryKey(EntityEthnicityBo.class, criteria);
    }

    public EntityEthnicity addEthnicityToEntity(EntityEthnicity ethnicity) throws RiceIllegalArgumentException {
        this.incomingParamCheck(ethnicity, "ethnicity");
        if (StringUtils.isEmpty((String)ethnicity.getEntityId()) || StringUtils.isBlank((String)ethnicity.getEntityId())) {
            throw new RiceIllegalStateException("Ethnicity's entityId must be populated before creation");
        }
        if (StringUtils.isNotEmpty((String)ethnicity.getId()) && this.getEntityEthnicityBo(ethnicity.getId()) != null) {
            throw new RiceIllegalStateException("the EntityEthnicity to create already exists: " + ethnicity);
        }
        EntityEthnicityBo bo = EntityEthnicityBo.from(ethnicity);
        return EntityEthnicityBo.to((EntityEthnicityBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityEthnicity updateEthnicity(EntityEthnicity ethnicity) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(ethnicity, "ethnicity");
        if (StringUtils.isEmpty((String)ethnicity.getEntityId()) || StringUtils.isBlank((String)ethnicity.getEntityId())) {
            throw new RiceIllegalStateException("Ethnicity's entityId must be populated before creation");
        }
        if (StringUtils.isEmpty((String)ethnicity.getId()) || this.getEntityEthnicityBo(ethnicity.getId()) == null) {
            throw new RiceIllegalStateException("the EntityEthnicity to update does not exist: " + ethnicity);
        }
        EntityEthnicityBo bo = EntityEthnicityBo.from(ethnicity);
        return EntityEthnicityBo.to((EntityEthnicityBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    private EntityResidencyBo getEntityResidencyBo(String residencyId) {
        if (StringUtils.isEmpty((String)residencyId)) {
            return null;
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("id", residencyId);
        return (EntityResidencyBo)this.businessObjectService.findByPrimaryKey(EntityResidencyBo.class, criteria);
    }

    public EntityResidency addResidencyToEntity(EntityResidency residency) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(residency, "residency");
        if (StringUtils.isEmpty((String)residency.getEntityId()) || StringUtils.isBlank((String)residency.getEntityId())) {
            throw new RiceIllegalStateException("Residency's entityId must be populated before creation");
        }
        if (StringUtils.isNotEmpty((String)residency.getId()) && this.getEntityResidencyBo(residency.getId()) != null) {
            throw new RiceIllegalStateException("the EntityResidency to create already exists: " + residency);
        }
        EntityResidencyBo bo = EntityResidencyBo.from(residency);
        return EntityResidencyBo.to((EntityResidencyBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityResidency updateResidency(EntityResidency residency) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(residency, "residency");
        if (StringUtils.isEmpty((String)residency.getEntityId()) || StringUtils.isBlank((String)residency.getEntityId())) {
            throw new RiceIllegalStateException("Residency's entityId must be populated before creation");
        }
        if (StringUtils.isEmpty((String)residency.getId()) || this.getEntityResidencyBo(residency.getId()) == null) {
            throw new RiceIllegalStateException("the EntityResidency to update does not exist: " + residency);
        }
        EntityResidencyBo bo = EntityResidencyBo.from(residency);
        return EntityResidencyBo.to((EntityResidencyBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    private EntityVisaBo getEntityVisaBo(String visaId) {
        if (StringUtils.isEmpty((String)visaId)) {
            return null;
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("id", visaId);
        return (EntityVisaBo)this.businessObjectService.findByPrimaryKey(EntityVisaBo.class, criteria);
    }

    public EntityVisa addVisaToEntity(EntityVisa visa) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(visa, "visa");
        if (StringUtils.isEmpty((String)visa.getEntityId()) || StringUtils.isBlank((String)visa.getEntityId())) {
            throw new RiceIllegalStateException("Visa's entityId must be populated before creation");
        }
        if (StringUtils.isNotEmpty((String)visa.getId()) && this.getEntityVisaBo(visa.getId()) != null) {
            throw new RiceIllegalStateException("the EntityVisa to create already exists: " + visa);
        }
        EntityVisaBo bo = EntityVisaBo.from(visa);
        return EntityVisaBo.to((EntityVisaBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityVisa updateVisa(EntityVisa visa) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(visa, "visa");
        if (StringUtils.isEmpty((String)visa.getEntityId()) || StringUtils.isBlank((String)visa.getEntityId())) {
            throw new RiceIllegalStateException("Visa's entityId must be populated before creation");
        }
        if (StringUtils.isEmpty((String)visa.getId()) || this.getEntityVisaBo(visa.getId()) == null) {
            throw new RiceIllegalStateException("the EntityVisa to update does not exist: " + visa);
        }
        EntityVisaBo bo = EntityVisaBo.from(visa);
        return EntityVisaBo.to((EntityVisaBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    private EntityNameBo getEntityNameBo(String entityId, String nameTypeCode) {
        if (StringUtils.isEmpty((String)entityId) || StringUtils.isEmpty((String)nameTypeCode)) {
            return null;
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("entityId", entityId);
        criteria.put("nameCode", nameTypeCode);
        criteria.put("active", "Y");
        return (EntityNameBo)this.businessObjectService.findByPrimaryKey(EntityNameBo.class, criteria);
    }

    private EntityNameBo getEntityNameBo(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("id", id);
        criteria.put("active", "Y");
        return (EntityNameBo)this.businessObjectService.findByPrimaryKey(EntityNameBo.class, criteria);
    }

    public EntityNamePrincipalName getDefaultNamesForPrincipalId(String principalId) {
        EntityNamePrincipalName.Builder nameBuilder = EntityNamePrincipalName.Builder.create();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("principalId", principalId);
        PrincipalBo principal = (PrincipalBo)this.businessObjectService.findByPrimaryKey(PrincipalBo.class, criteria);
        if (null != principal) {
            nameBuilder.setPrincipalName(principal.getPrincipalName());
            criteria.clear();
            criteria.put("entityId", principal.getEntityId());
            criteria.put("DFLT_IND", "Y");
            criteria.put("ACTV_IND", "Y");
            EntityNameBo name = (EntityNameBo)this.businessObjectService.findByPrimaryKey(EntityNameBo.class, criteria);
            if (name == null) {
                EntityName.Builder defaultNameBuilder = EntityName.Builder.create();
                defaultNameBuilder.setLastName(principal.getPrincipalName().toUpperCase());
                nameBuilder.setDefaultName(defaultNameBuilder);
            } else {
                nameBuilder.setDefaultName(EntityName.Builder.create((EntityNameContract)name));
            }
            EntityNamePrincipalName entityNamePrincipalName = nameBuilder.build();
            return entityNamePrincipalName;
        }
        return null;
    }

    public EntityName addNameToEntity(EntityName name) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(name, "name");
        if (StringUtils.isEmpty((String)name.getEntityId()) || StringUtils.isBlank((String)name.getEntityId())) {
            throw new RiceIllegalStateException("Name's entityId must be populated before creation");
        }
        if (name.getNameType() == null) {
            throw new RiceIllegalStateException("EntityName's type must be populated before creation");
        }
        if (this.getEntityNameBo(name.getEntityId(), name.getNameType().getCode()) != null) {
            throw new RiceIllegalStateException("the EntityName to create already exists: " + name);
        }
        EntityNameBo bo = EntityNameBo.from(name);
        return EntityNameBo.to((EntityNameBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityName updateName(EntityName name) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(name, "name");
        if (StringUtils.isEmpty((String)name.getEntityId()) || StringUtils.isBlank((String)name.getEntityId())) {
            throw new RiceIllegalStateException("Name's entityId must be populated before update");
        }
        if (name.getNameType() == null) {
            throw new RiceIllegalStateException("EntityName's type must be populated before update");
        }
        if (StringUtils.isEmpty((String)name.getId()) || this.getEntityNameBo(name.getId()) == null) {
            throw new RiceIllegalStateException("the EntityName to update does not exist: " + name);
        }
        EntityNameBo bo = EntityNameBo.from(name);
        return EntityNameBo.to((EntityNameBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityName inactivateName(String id) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(id, "id");
        EntityNameBo bo = this.getEntityNameBo(id);
        if (bo == null) {
            throw new RiceIllegalStateException("the EntityName to inactivate does not exist");
        }
        bo.setActive(false);
        return EntityNameBo.to((EntityNameBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    private EntityEmploymentBo getEntityEmploymentBo(String entityId, String employmentTypeCode, String employmentStatusCode, String employmentAffiliationId) {
        if (StringUtils.isEmpty((String)entityId) || StringUtils.isEmpty((String)employmentTypeCode) || StringUtils.isEmpty((String)employmentStatusCode) || StringUtils.isEmpty((String)employmentAffiliationId)) {
            return null;
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("entityId", entityId);
        criteria.put("employeeTypeCode", employmentTypeCode);
        criteria.put("employeeStatusCode", employmentStatusCode);
        criteria.put("entityAffiliationId", employmentAffiliationId);
        criteria.put("active", "Y");
        return (EntityEmploymentBo)this.businessObjectService.findByPrimaryKey(EntityEmploymentBo.class, criteria);
    }

    private EntityEmploymentBo getEntityEmploymentBo(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("id", id);
        criteria.put("active", "Y");
        return (EntityEmploymentBo)this.businessObjectService.findByPrimaryKey(EntityEmploymentBo.class, criteria);
    }

    public EntityEmployment addEmploymentToEntity(EntityEmployment employment) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(employment, "employment");
        if (StringUtils.isEmpty((String)employment.getEntityId()) || StringUtils.isBlank((String)employment.getEntityId())) {
            throw new RiceIllegalStateException("EntityEmployment's entityId must be populated before creation");
        }
        if (employment.getEmployeeType() == null || employment.getEmployeeStatus() == null || employment.getEntityAffiliation() == null) {
            throw new RiceIllegalStateException("EntityEmployment's status, type, and entity affiliation must be populated before creation");
        }
        if (this.getEntityEmploymentBo(employment.getEntityId(), employment.getEmployeeType().getCode(), employment.getEmployeeStatus().getCode(), employment.getEntityAffiliation().getId()) != null) {
            throw new RiceIllegalStateException("the EntityEmployment to create already exists: " + employment);
        }
        EntityEmploymentBo bo = EntityEmploymentBo.from(employment);
        return EntityEmploymentBo.to((EntityEmploymentBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityEmployment updateEmployment(EntityEmployment employment) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(employment, "employment");
        if (StringUtils.isEmpty((String)employment.getEntityId()) || StringUtils.isBlank((String)employment.getEntityId())) {
            throw new RiceIllegalStateException("EntityEmployment's entityId must be populated before update");
        }
        if (employment.getEmployeeType() == null || employment.getEmployeeStatus() == null || employment.getEntityAffiliation() == null) {
            throw new RiceIllegalStateException("EntityEmployment's status, type, and entity affiliation must be populated before update");
        }
        if (this.getEntityEmploymentBo(employment.getEntityId(), employment.getEmployeeType().getCode(), employment.getEmployeeStatus().getCode(), employment.getEntityAffiliation().getId()) == null) {
            throw new RiceIllegalStateException("the EntityEmployment to udpate does not exist: " + employment);
        }
        EntityEmploymentBo bo = EntityEmploymentBo.from(employment);
        return EntityEmploymentBo.to((EntityEmploymentBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityEmployment inactivateEmployment(String id) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(id, "id");
        EntityEmploymentBo bo = this.getEntityEmploymentBo(id);
        if (bo == null) {
            throw new RiceIllegalStateException("the EntityEmployment to inactivate does not exist");
        }
        bo.setActive(false);
        return EntityEmploymentBo.to((EntityEmploymentBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    private EntityBioDemographicsBo getEntityBioDemographicsBo(String entityId) {
        if (StringUtils.isEmpty((String)entityId)) {
            return null;
        }
        HashMap<String, String> criteria = new HashMap<String, String>(1);
        criteria.put("entityId", entityId);
        return (EntityBioDemographicsBo)this.businessObjectService.findByPrimaryKey(EntityBioDemographicsBo.class, criteria);
    }

    public EntityBioDemographics addBioDemographicsToEntity(EntityBioDemographics bioDemographics) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(bioDemographics, "bioDemographics");
        if (StringUtils.isEmpty((String)bioDemographics.getEntityId()) || StringUtils.isBlank((String)bioDemographics.getEntityId())) {
            throw new RiceIllegalStateException("BioDemographics' entityId must be populated before creation");
        }
        if (this.getEntityBioDemographicsBo(bioDemographics.getEntityId()) != null) {
            throw new RiceIllegalStateException("the EntityBioDemographics to create already exists: " + bioDemographics);
        }
        EntityBioDemographicsBo bo = EntityBioDemographicsBo.from(bioDemographics);
        return EntityBioDemographicsBo.to((EntityBioDemographicsBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public EntityBioDemographics updateBioDemographics(EntityBioDemographics bioDemographics) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(bioDemographics, "bioDemographics");
        if (this.getEntityBioDemographicsBo(bioDemographics.getEntityId()) == null) {
            throw new RiceIllegalStateException("the EntityBioDemographics to update does not exist: " + bioDemographics);
        }
        EntityBioDemographicsBo bo = EntityBioDemographicsBo.from(bioDemographics);
        return EntityBioDemographicsBo.to((EntityBioDemographicsBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public void setCriteriaLookupService(CriteriaLookupService criteriaLookupService) {
        this.criteriaLookupService = criteriaLookupService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }
}

