/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity;

import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.privacy.EntityPrivacyPreferences;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

class KimInternalSuppressUtils {
    private static IdentityService identityService;
    private static PermissionService permissionService;

    private KimInternalSuppressUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static boolean isSuppressName(String entityId) {
        EntityPrivacyPreferences privacy = null;
        EntityDefault entityInfo = KimInternalSuppressUtils.getIdentityService().getEntityDefault(entityId);
        if (entityInfo == null) {
            return true;
        }
        privacy = entityInfo.getPrivacyPreferences();
        UserSession userSession = GlobalVariables.getUserSession();
        boolean suppressName = false;
        if (privacy != null) {
            suppressName = privacy.isSuppressName();
        }
        return suppressName && userSession != null && !StringUtils.equals((String)userSession.getPerson().getEntityId(), (String)entityId) && !KimInternalSuppressUtils.canOverrideEntityPrivacyPreferences(((Principal)entityInfo.getPrincipals().get(0)).getPrincipalId());
    }

    public static boolean isSuppressEmail(String entityId) {
        EntityPrivacyPreferences privacy = null;
        EntityDefault entityInfo = KimInternalSuppressUtils.getIdentityService().getEntityDefault(entityId);
        if (entityInfo == null) {
            return true;
        }
        privacy = entityInfo.getPrivacyPreferences();
        UserSession userSession = GlobalVariables.getUserSession();
        boolean suppressEmail = false;
        if (privacy != null) {
            suppressEmail = privacy.isSuppressEmail();
        }
        return suppressEmail && userSession != null && !StringUtils.equals((String)userSession.getPerson().getEntityId(), (String)entityId) && !KimInternalSuppressUtils.canOverrideEntityPrivacyPreferences(((Principal)entityInfo.getPrincipals().get(0)).getPrincipalId());
    }

    public static boolean isSuppressAddress(String entityId) {
        EntityPrivacyPreferences privacy = null;
        EntityDefault entityInfo = KimInternalSuppressUtils.getIdentityService().getEntityDefault(entityId);
        if (entityInfo == null) {
            return false;
        }
        privacy = entityInfo.getPrivacyPreferences();
        UserSession userSession = GlobalVariables.getUserSession();
        boolean suppressAddress = false;
        if (privacy != null) {
            suppressAddress = privacy.isSuppressAddress();
        }
        return suppressAddress && userSession != null && !StringUtils.equals((String)userSession.getPerson().getEntityId(), (String)entityId) && !KimInternalSuppressUtils.canOverrideEntityPrivacyPreferences(((Principal)entityInfo.getPrincipals().get(0)).getPrincipalId());
    }

    public static boolean isSuppressPhone(String entityId) {
        EntityPrivacyPreferences privacy = null;
        EntityDefault entityInfo = KimInternalSuppressUtils.getIdentityService().getEntityDefault(entityId);
        if (entityInfo == null) {
            return true;
        }
        privacy = entityInfo.getPrivacyPreferences();
        UserSession userSession = GlobalVariables.getUserSession();
        boolean suppressPhone = false;
        if (privacy != null) {
            suppressPhone = privacy.isSuppressPhone();
        }
        return suppressPhone && userSession != null && !StringUtils.equals((String)userSession.getPerson().getEntityId(), (String)entityId) && !KimInternalSuppressUtils.canOverrideEntityPrivacyPreferences(((Principal)entityInfo.getPrincipals().get(0)).getPrincipalId());
    }

    public static boolean isSuppressPersonal(String entityId) {
        EntityPrivacyPreferences privacy = null;
        EntityDefault entityInfo = KimInternalSuppressUtils.getIdentityService().getEntityDefault(entityId);
        if (entityInfo == null) {
            return true;
        }
        privacy = entityInfo.getPrivacyPreferences();
        UserSession userSession = GlobalVariables.getUserSession();
        boolean suppressPersonal = false;
        if (privacy != null) {
            suppressPersonal = privacy.isSuppressPersonal();
        }
        return suppressPersonal && userSession != null && !StringUtils.equals((String)userSession.getPerson().getEntityId(), (String)entityId) && !KimInternalSuppressUtils.canOverrideEntityPrivacyPreferences(((Principal)entityInfo.getPrincipals().get(0)).getPrincipalId());
    }

    protected static boolean canOverrideEntityPrivacyPreferences(String principalId) {
        return KimInternalSuppressUtils.getPermissionService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), "KR-IDM", "Override Entity Privacy Preferences", Collections.singletonMap("principalId", principalId));
    }

    private static IdentityService getIdentityService() {
        if (identityService == null) {
            identityService = KimApiServiceLocator.getIdentityService();
        }
        return identityService;
    }

    private static PermissionService getPermissionService() {
        if (permissionService == null) {
            permissionService = KimApiServiceLocator.getPermissionService();
        }
        return permissionService;
    }
}

