/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.responsibility;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.kim.api.common.template.Template;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeDataBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityAttributeBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityTemplateBo;
import org.kuali.rice.kim.impl.responsibility.ReviewResponsibilityBo;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.KualiMaintainableImpl;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class ReviewResponsibilityMaintainable
extends KualiMaintainableImpl {
    private static final Logger LOG = Logger.getLogger(ReviewResponsibilityMaintainable.class);
    private static final long serialVersionUID = -8102504656976243468L;
    private static Template REVIEW_TEMPLATE;

    public List getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        if (document.isEdit()) {
            for (Section section : sections) {
                for (Row row : section.getRows()) {
                    for (Field field : row.getFields()) {
                        if (!"actionDetailsAtRoleMemberLevel".equals(field.getPropertyName())) continue;
                        field.setReadOnly(true);
                    }
                }
            }
        }
        return sections;
    }

    public void saveDataObject() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Attempting to save ReviewResponsibilityBo BO via ResponsibilityService:" + this.getBusinessObject()));
        }
        ReviewResponsibilityMaintainable.populateReviewTemplateInfo();
        ReviewResponsibilityBo resp = (ReviewResponsibilityBo)((Object)this.getDataObject());
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("documentTypeName", resp.getDocumentTypeName());
        details.put("routeNodeName", resp.getRouteNodeName());
        details.put("required", resp.isRequired() ? "true" : "false");
        details.put("actionDetailsAtRoleMemberLevel", resp.isActionDetailsAtRoleMemberLevel() ? "true" : "false");
        if (StringUtils.isNotBlank((String)resp.getQualifierResolverProvidedIdentifier())) {
            details.put("qualifierResolverProvidedIdentifier", resp.getQualifierResolverProvidedIdentifier());
        }
        if (resp.getTemplateId() == null) {
            resp.setTemplateId(REVIEW_TEMPLATE.getId());
            resp.setTemplate(ResponsibilityTemplateBo.from(REVIEW_TEMPLATE));
        } else {
            resp.setTemplate(ResponsibilityTemplateBo.from(KimApiServiceLocator.getResponsibilityService().getResponsibilityTemplate(resp.getTemplateId())));
        }
        resp.setAttributes(details);
        resp.setAttributeDetails(KimAttributeDataBo.createFrom(ResponsibilityAttributeBo.class, details, resp.getTemplate().getKimTypeId()));
        boolean responsibilityExists = false;
        if (resp.getId() != null) {
            boolean bl = responsibilityExists = KimApiServiceLocator.getResponsibilityService().getResponsibility(resp.getId()) != null;
        }
        if (responsibilityExists) {
            KimApiServiceLocator.getResponsibilityService().updateResponsibility(ResponsibilityBo.to(resp));
        } else {
            if (this.getMaintenanceAction().equals("Copy")) {
                if (StringUtils.isNotBlank((String)resp.getObjectId())) {
                    resp.setObjectId("");
                }
                if (null != resp.getVersionNumber()) {
                    resp.setVersionNumber(null);
                }
            }
            KimApiServiceLocator.getResponsibilityService().createResponsibility(ResponsibilityBo.to(resp));
        }
    }

    private static synchronized void populateReviewTemplateInfo() {
        if (REVIEW_TEMPLATE == null) {
            REVIEW_TEMPLATE = KimApiServiceLocator.getResponsibilityService().findRespTemplateByNamespaceCodeAndName("KR-WKFLW", "Review");
        }
    }

    public Class<? extends BusinessObject> getBoClass() {
        return ReviewResponsibilityBo.class;
    }

    public void prepareBusinessObject(BusinessObject businessObject) {
        if (businessObject == null) {
            throw new RuntimeException("Configuration ERROR: ReviewResponsibilityBoMaintainable.prepareBusinessObject passed a null object.");
        }
        if (!(businessObject instanceof ResponsibilityBo)) {
            throw new RuntimeException("Configuration ERROR: ReviewResponsibilityBoMaintainable passed an unsupported object type: " + businessObject.getClass());
        }
        ResponsibilityBo resp = (ResponsibilityBo)this.getBusinessObjectService().findBySinglePrimaryKey(ResponsibilityBo.class, (Object)((ResponsibilityBo)((Object)businessObject)).getId());
        businessObject = new ReviewResponsibilityBo(resp);
        this.setBusinessObject((PersistableBusinessObject)businessObject);
        super.prepareBusinessObject(businessObject);
    }

    public boolean isExternalBusinessObject() {
        return true;
    }
}

