/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.krad.service.BusinessObjectService;

public class KimTypeInfoServiceImpl
implements KimTypeInfoService {
    private BusinessObjectService businessObjectService;

    public KimType getKimType(String id) throws RiceIllegalArgumentException {
        this.incomingParamCheck(id, "id");
        return KimTypeBo.to((KimTypeBo)this.businessObjectService.findBySinglePrimaryKey(KimTypeBo.class, (Object)id));
    }

    public KimType findKimTypeByNameAndNamespace(String namespaceCode, String name) throws RiceIllegalArgumentException {
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(name, "name");
        HashMap<String, String> crit = new HashMap<String, String>();
        crit.put("namespaceCode", namespaceCode);
        crit.put("name", name);
        crit.put("active", "true");
        Collection bos = this.businessObjectService.findMatching(KimTypeBo.class, crit);
        if (bos != null && bos.size() > 1) {
            throw new IllegalStateException("multiple active results were found for the namespace code: " + namespaceCode + " and name: " + name);
        }
        return bos != null && bos.iterator().hasNext() ? KimTypeBo.to((KimTypeBo)((Object)bos.iterator().next())) : null;
    }

    public Collection<KimType> findAllKimTypes() {
        Collection bos = this.businessObjectService.findMatching(KimTypeBo.class, Collections.singletonMap("active", "true"));
        ArrayList<KimType> ims = new ArrayList<KimType>();
        if (bos != null) {
            for (KimTypeBo bo : bos) {
                if (bo == null) continue;
                ims.add(KimTypeBo.to(bo));
            }
        }
        return Collections.unmodifiableCollection(ims);
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }
}

