/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.common.attribute;

import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kuali.rice.core.api.criteria.CriteriaValue;
import org.kuali.rice.core.api.criteria.LookupCustomizer;
import org.kuali.rice.core.api.criteria.MultiValuedPredicate;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.PropertyPathPredicate;
import org.kuali.rice.core.api.criteria.SingleValuedPredicate;

public final class AttributeTransform
implements LookupCustomizer.Transform<Predicate, Predicate> {
    private static final LookupCustomizer.Transform<Predicate, Predicate> INSTANCE = new AttributeTransform();
    private static final String ATTRIBUTE_DETAILS_ATTRIBUTE_VALUE = "attributeDetails.attributeValue";
    private static final String ATTRIBUTE_DETAILS_ATTRIBUTE_NAME = "attributeDetails.kimAttribute.attributeName";
    private static final String ATTRIBUTES_REGEX = "^attributes\\[\\w*\\]$";
    private static final Pattern ATTRIBUTES_PATTERN = Pattern.compile("^attributes\\[\\w*\\]$");

    private AttributeTransform() {
    }

    public Predicate apply(Predicate input) {
        String pp;
        if (input instanceof PropertyPathPredicate && this.isAttributesPredicate(pp = ((PropertyPathPredicate)input).getPropertyPath())) {
            Predicate attrValue;
            String attributeName = pp.substring(pp.indexOf(91) + 1, pp.indexOf(93));
            if (input instanceof SingleValuedPredicate) {
                CriteriaValue value = ((SingleValuedPredicate)input).getValue();
                attrValue = PredicateFactory.dynConstruct((String)input.getClass().getSimpleName(), (Object[])new Object[]{ATTRIBUTE_DETAILS_ATTRIBUTE_VALUE, value.getValue()});
            } else if (input instanceof MultiValuedPredicate) {
                Set values = ((MultiValuedPredicate)input).getValues();
                ArrayList<Object> l = new ArrayList<Object>();
                for (CriteriaValue v : values) {
                    l.add(v.getValue());
                }
                attrValue = PredicateFactory.dynConstruct((String)input.getClass().getSimpleName(), (Object[])new Object[]{ATTRIBUTE_DETAILS_ATTRIBUTE_VALUE, l.toArray()});
            } else {
                attrValue = PredicateFactory.dynConstruct((String)input.getClass().getSimpleName(), (Object[])new Object[]{ATTRIBUTE_DETAILS_ATTRIBUTE_VALUE});
            }
            return PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)ATTRIBUTE_DETAILS_ATTRIBUTE_NAME, (Object)attributeName), attrValue});
        }
        return input;
    }

    private boolean isAttributesPredicate(String pp) {
        Matcher matcher = ATTRIBUTES_PATTERN.matcher(pp);
        return matcher.matches();
    }

    public static LookupCustomizer.Transform<Predicate, Predicate> getInstance() {
        return INSTANCE;
    }
}

