/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity.name;

import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.joda.time.DateTime;
import org.kuali.rice.kim.api.identity.name.EntityNameContract;
import org.kuali.rice.kim.api.identity.privacy.EntityPrivacyPreferences;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@MappedSuperclass
public abstract class EntityNameBase
extends DataObjectBase
implements EntityNameContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 7102034794623577359L;
    @Column(name="ENTITY_ID")
    private String entityId;
    @Column(name="NM_TYP_CD")
    private String nameCode;
    @Column(name="FIRST_NM")
    private String firstName;
    @Column(name="MIDDLE_NM")
    private String middleName;
    @Column(name="LAST_NM")
    private String lastName;
    @Column(name="PREFIX_NM")
    private String namePrefix;
    @Column(name="TITLE_NM")
    private String nameTitle;
    @Column(name="SUFFIX_NM")
    private String nameSuffix;
    @Convert(converter=BooleanYNConverter.class)
    @Column(name="ACTV_IND")
    private boolean active;
    @Convert(converter=BooleanYNConverter.class)
    @Column(name="DFLT_IND")
    private boolean defaultValue;
    @Column(name="NOTE_MSG")
    private String noteMessage;
    @Column(name="NM_CHNG_DT")
    private Timestamp nameChangedDate;
    @Transient
    private boolean suppressName;

    public EntityNameBase() {
    }

    public String getFirstName() {
        if (this.isSuppressName()) {
            return "Xxxxxx";
        }
        return this._persistence_get_firstName();
    }

    public String getMiddleName() {
        if (this.isSuppressName()) {
            return "Xxxxxx";
        }
        return this._persistence_get_middleName();
    }

    public String getLastName() {
        if (this.isSuppressName()) {
            return "Xxxxxx";
        }
        return this._persistence_get_lastName();
    }

    public String getNamePrefix() {
        if (this.isSuppressName()) {
            return "Xxxxxx";
        }
        return this._persistence_get_namePrefix();
    }

    public String getNameTitle() {
        if (this.isSuppressName()) {
            return "Xxxxxx";
        }
        return this._persistence_get_nameTitle();
    }

    public String getFirstNameUnmasked() {
        return this._persistence_get_firstName();
    }

    public String getMiddleNameUnmasked() {
        return this._persistence_get_middleName();
    }

    public String getLastNameUnmasked() {
        return this._persistence_get_lastName();
    }

    public String getNamePrefixUnmasked() {
        return this._persistence_get_namePrefix();
    }

    public String getNameTitleUnmasked() {
        return this._persistence_get_nameTitle();
    }

    public String getNameSuffixUnmasked() {
        return this._persistence_get_nameSuffix();
    }

    public String getCompositeName() {
        if (this.isSuppressName()) {
            return "Xxxxxx";
        }
        return this.getCompositeNameUnmasked();
    }

    public String getCompositeNameUnmasked() {
        return this.getLastName() + ", " + this.getFirstName() + (StringUtils.isBlank((String)this.getMiddleName()) ? "" : " " + this.getMiddleName());
    }

    public DateTime getNameChangedDate() {
        return this._persistence_get_nameChangedDate() != null ? new DateTime(this._persistence_get_nameChangedDate().getTime()) : null;
    }

    public Timestamp getNameChangedTimestamp() {
        return this._persistence_get_nameChangedDate();
    }

    public boolean isSuppressName() {
        try {
            EntityPrivacyPreferences privacy = KimApiServiceLocator.getIdentityService().getEntityPrivacyPreferences(this.getEntityId());
            this.suppressName = privacy != null ? privacy.isSuppressName() : false;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException c) {
            return false;
        }
        return this.suppressName;
    }

    public String getEntityId() {
        return this._persistence_get_entityId();
    }

    public void setEntityId(String entityId) {
        this._persistence_set_entityId(entityId);
    }

    public String getNameCode() {
        return this._persistence_get_nameCode();
    }

    public void setNameCode(String nameCode) {
        this._persistence_set_nameCode(nameCode);
    }

    public void setFirstName(String firstName) {
        this._persistence_set_firstName(firstName);
    }

    public void setMiddleName(String middleName) {
        this._persistence_set_middleName(middleName);
    }

    public void setLastName(String lastName) {
        this._persistence_set_lastName(lastName);
    }

    public void setNamePrefix(String namePrefix) {
        this._persistence_set_namePrefix(namePrefix);
    }

    public void setNameTitle(String nameTitle) {
        this._persistence_set_nameTitle(nameTitle);
    }

    public String getNameSuffix() {
        return this._persistence_get_nameSuffix();
    }

    public void setNameSuffix(String nameSuffix) {
        this._persistence_set_nameSuffix(nameSuffix);
    }

    public boolean getActive() {
        return this._persistence_get_active();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public boolean getDefaultValue() {
        return this._persistence_get_defaultValue();
    }

    public boolean isDefaultValue() {
        return this._persistence_get_defaultValue();
    }

    public void setDefaultValue(boolean defaultValue) {
        this._persistence_set_defaultValue(defaultValue);
    }

    public String getNoteMessage() {
        return this._persistence_get_noteMessage();
    }

    public void setNoteMessage(String noteMessage) {
        this._persistence_set_noteMessage(noteMessage);
    }

    public void setNameChangedDate(DateTime nameChangedDate) {
        if (nameChangedDate != null) {
            this._persistence_set_nameChangedDate(new Timestamp(nameChangedDate.getMillis()));
        } else {
            this._persistence_set_nameChangedDate(null);
        }
    }

    public void setNameChangedTimestamp(Timestamp nameChangedDate) {
        this._persistence_set_nameChangedDate(nameChangedDate);
    }

    public boolean getSuppressName() {
        return this.suppressName;
    }

    public void setSuppressName(boolean suppressName) {
        this.suppressName = suppressName;
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new EntityNameBase(persistenceObject);
    }

    public EntityNameBase(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "lastName") {
            return this.lastName;
        }
        if (string == "nameTitle") {
            return this.nameTitle;
        }
        if (string == "defaultValue") {
            return this.defaultValue;
        }
        if (string == "nameSuffix") {
            return this.nameSuffix;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "entityId") {
            return this.entityId;
        }
        if (string == "noteMessage") {
            return this.noteMessage;
        }
        if (string == "firstName") {
            return this.firstName;
        }
        if (string == "nameCode") {
            return this.nameCode;
        }
        if (string == "namePrefix") {
            return this.namePrefix;
        }
        if (string == "nameChangedDate") {
            return this.nameChangedDate;
        }
        if (string == "middleName") {
            return this.middleName;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "lastName") {
            this.lastName = (String)object;
            return;
        }
        if (string == "nameTitle") {
            this.nameTitle = (String)object;
            return;
        }
        if (string == "defaultValue") {
            this.defaultValue = (Boolean)object;
            return;
        }
        if (string == "nameSuffix") {
            this.nameSuffix = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "entityId") {
            this.entityId = (String)object;
            return;
        }
        if (string == "noteMessage") {
            this.noteMessage = (String)object;
            return;
        }
        if (string == "firstName") {
            this.firstName = (String)object;
            return;
        }
        if (string == "nameCode") {
            this.nameCode = (String)object;
            return;
        }
        if (string == "namePrefix") {
            this.namePrefix = (String)object;
            return;
        }
        if (string == "nameChangedDate") {
            this.nameChangedDate = (Timestamp)object;
            return;
        }
        if (string == "middleName") {
            this.middleName = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_lastName() {
        this._persistence_checkFetched("lastName");
        return this.lastName;
    }

    public void _persistence_set_lastName(String string) {
        this._persistence_checkFetchedForSet("lastName");
        this._persistence_propertyChange("lastName", this.lastName, string);
        this.lastName = string;
    }

    public String _persistence_get_nameTitle() {
        this._persistence_checkFetched("nameTitle");
        return this.nameTitle;
    }

    public void _persistence_set_nameTitle(String string) {
        this._persistence_checkFetchedForSet("nameTitle");
        this._persistence_propertyChange("nameTitle", this.nameTitle, string);
        this.nameTitle = string;
    }

    public boolean _persistence_get_defaultValue() {
        this._persistence_checkFetched("defaultValue");
        return this.defaultValue;
    }

    public void _persistence_set_defaultValue(boolean bl) {
        this._persistence_checkFetchedForSet("defaultValue");
        this._persistence_propertyChange("defaultValue", new Boolean(this.defaultValue), new Boolean(bl));
        this.defaultValue = bl;
    }

    public String _persistence_get_nameSuffix() {
        this._persistence_checkFetched("nameSuffix");
        return this.nameSuffix;
    }

    public void _persistence_set_nameSuffix(String string) {
        this._persistence_checkFetchedForSet("nameSuffix");
        this._persistence_propertyChange("nameSuffix", this.nameSuffix, string);
        this.nameSuffix = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public String _persistence_get_entityId() {
        this._persistence_checkFetched("entityId");
        return this.entityId;
    }

    public void _persistence_set_entityId(String string) {
        this._persistence_checkFetchedForSet("entityId");
        this._persistence_propertyChange("entityId", this.entityId, string);
        this.entityId = string;
    }

    public String _persistence_get_noteMessage() {
        this._persistence_checkFetched("noteMessage");
        return this.noteMessage;
    }

    public void _persistence_set_noteMessage(String string) {
        this._persistence_checkFetchedForSet("noteMessage");
        this._persistence_propertyChange("noteMessage", this.noteMessage, string);
        this.noteMessage = string;
    }

    public String _persistence_get_firstName() {
        this._persistence_checkFetched("firstName");
        return this.firstName;
    }

    public void _persistence_set_firstName(String string) {
        this._persistence_checkFetchedForSet("firstName");
        this._persistence_propertyChange("firstName", this.firstName, string);
        this.firstName = string;
    }

    public String _persistence_get_nameCode() {
        this._persistence_checkFetched("nameCode");
        return this.nameCode;
    }

    public void _persistence_set_nameCode(String string) {
        this._persistence_checkFetchedForSet("nameCode");
        this._persistence_propertyChange("nameCode", this.nameCode, string);
        this.nameCode = string;
    }

    public String _persistence_get_namePrefix() {
        this._persistence_checkFetched("namePrefix");
        return this.namePrefix;
    }

    public void _persistence_set_namePrefix(String string) {
        this._persistence_checkFetchedForSet("namePrefix");
        this._persistence_propertyChange("namePrefix", this.namePrefix, string);
        this.namePrefix = string;
    }

    public Timestamp _persistence_get_nameChangedDate() {
        this._persistence_checkFetched("nameChangedDate");
        return this.nameChangedDate;
    }

    public void _persistence_set_nameChangedDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("nameChangedDate");
        this._persistence_propertyChange("nameChangedDate", this.nameChangedDate, timestamp);
        this.nameChangedDate = timestamp;
    }

    public String _persistence_get_middleName() {
        this._persistence_checkFetched("middleName");
        return this.middleName;
    }

    public void _persistence_set_middleName(String string) {
        this._persistence_checkFetchedForSet("middleName");
        this._persistence_propertyChange("middleName", this.middleName, string);
        this.middleName = string;
    }
}

