/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.ldap;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.util.BufferedLogger;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.phone.EntityPhone;
import org.kuali.rice.kim.ldap.BaseMapper;
import org.springframework.ldap.core.DirContextOperations;

public class EntityPhoneMapper
extends BaseMapper<EntityPhone> {
    @Override
    EntityPhone mapDtoFromContext(DirContextOperations context) {
        return this.mapDtoFromContext(context, true);
    }

    EntityPhone mapDtoFromContext(DirContextOperations context, boolean isdefault) {
        EntityPhone.Builder builder = this.mapBuilderFromContext(context, isdefault);
        return builder != null ? builder.build() : null;
    }

    EntityPhone.Builder mapBuilderFromContext(DirContextOperations context) {
        return this.mapBuilderFromContext(context, true);
    }

    EntityPhone.Builder mapBuilderFromContext(DirContextOperations context, boolean isdefault) {
        EntityPhone.Builder builder = EntityPhone.Builder.create();
        BufferedLogger.debug("Looking up attribute from context ", this.getConstants().getEmployeePhoneLdapProperty());
        String pn = context.getStringAttribute(this.getConstants().getEmployeePhoneLdapProperty());
        if (StringUtils.isBlank((String)pn) || StringUtils.equalsIgnoreCase((String)"NA", (String)pn)) {
            BufferedLogger.debug("Got nothing. Giving nothing back.");
            return null;
        }
        String phoneNumber = pn;
        if (pn.length() >= 10) {
            phoneNumber = pn.substring(0, 3) + "-" + pn.substring(3, 6) + "-" + pn.substring(6);
        } else if (pn.length() >= 6) {
            phoneNumber = pn.substring(0, 3) + "-" + pn.substring(3);
        }
        String countryCode = this.getConstants().getDefaultCountryCode();
        builder.setCountryCode(countryCode);
        builder.setPhoneNumber(phoneNumber);
        builder.setPhoneType(CodedAttribute.Builder.create((String)"WORK"));
        builder.setActive(true);
        builder.setDefaultValue(isdefault);
        return builder;
    }
}

