/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebParam;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.criteria.CriteriaValue;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.privacy.EntityPrivacyPreferences;
import org.kuali.rice.kim.dao.LdapPrincipalDao;
import org.kuali.rice.kim.impl.identity.IdentityServiceImpl;

public class LdapIdentityDelegateServiceImpl
extends IdentityServiceImpl {
    private LdapPrincipalDao principalDao;

    public Entity getEntity(String entityId) {
        if (StringUtils.isBlank((String)entityId)) {
            throw new RiceIllegalArgumentException("entityId is blank");
        }
        Entity edsInfo = this.getPrincipalDao().getEntity(entityId);
        if (edsInfo != null) {
            return edsInfo;
        }
        return super.getEntity(entityId);
    }

    public Entity getEntityByPrincipalId(String principalId) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new RiceIllegalArgumentException("principalId is blank");
        }
        Entity edsInfo = this.getPrincipalDao().getEntityByPrincipalId(principalId);
        if (edsInfo != null) {
            return edsInfo;
        }
        return super.getEntityByPrincipalId(principalId);
    }

    public Entity getEntityByPrincipalName(String principalName) {
        if (StringUtils.isBlank((String)principalName)) {
            throw new RiceIllegalArgumentException("principalName is blank");
        }
        Entity edsInfo = this.getPrincipalDao().getEntityByPrincipalName(principalName);
        if (edsInfo != null) {
            return edsInfo;
        }
        return super.getEntityByPrincipalName(principalName);
    }

    public EntityDefault getEntityDefault(String entityId) {
        if (StringUtils.isBlank((String)entityId)) {
            throw new RiceIllegalArgumentException("entityId is blank");
        }
        EntityDefault edsInfo = this.getPrincipalDao().getEntityDefault(entityId);
        if (edsInfo != null) {
            return edsInfo;
        }
        return super.getEntityDefault(entityId);
    }

    public EntityDefault getEntityDefaultByPrincipalId(String principalId) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new RiceIllegalArgumentException("principalId is blank");
        }
        EntityDefault retval = this.getPrincipalDao().getEntityDefaultByPrincipalId(principalId);
        if (retval != null) {
            return retval;
        }
        return super.getEntityDefaultByPrincipalId(principalId);
    }

    public EntityDefault getEntityDefaultByPrincipalName(String principalName) {
        if (StringUtils.isBlank((String)principalName)) {
            throw new RiceIllegalArgumentException("principalName is blank");
        }
        EntityDefault retval = this.getPrincipalDao().getEntityDefaultByPrincipalName(principalName);
        if (retval != null) {
            return retval;
        }
        return super.getEntityDefaultByPrincipalName(principalName);
    }

    private static <U extends CriteriaValue<?>> Object getVal(U toConv) {
        Object o = toConv.getValue();
        if (o instanceof DateTime) {
            return new Timestamp(((DateTime)o).getMillis());
        }
        return o;
    }

    @Deprecated
    public Principal getPrincipalByPrincipalNameAndPassword(String principalName, String password) {
        if (StringUtils.isBlank((String)principalName)) {
            throw new RiceIllegalArgumentException("principalName is blank");
        }
        return this.getPrincipalByPrincipalName(principalName);
    }

    public EntityPrivacyPreferences getEntityPrivacyPreferences(String entityId) {
        if (StringUtils.isBlank((String)entityId)) {
            throw new RiceIllegalArgumentException("entityId is blank");
        }
        return this.getPrincipalDao().getEntityPrivacyPreferences(entityId);
    }

    public Principal getPrincipal(String principalId) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new RiceIllegalArgumentException("principalId is blank");
        }
        Principal edsInfo = this.getPrincipalDao().getPrincipal(principalId);
        if (edsInfo != null) {
            return edsInfo;
        }
        return super.getPrincipal(principalId);
    }

    public List<Principal> getPrincipals(@WebParam(name="principalIds") List<String> principalIds) {
        ArrayList<Principal> ret = new ArrayList<Principal>();
        for (String p : principalIds) {
            Principal principalInfo = this.getPrincipal(p);
            if (principalInfo == null) continue;
            ret.add(principalInfo);
        }
        return ret;
    }

    public Principal getPrincipalByPrincipalName(String principalName) {
        if (StringUtils.isBlank((String)principalName)) {
            throw new RiceIllegalArgumentException("principalName is blank");
        }
        Principal edsInfo = this.getPrincipalDao().getPrincipalByName(principalName);
        if (edsInfo != null) {
            return edsInfo;
        }
        return super.getPrincipalByPrincipalName(principalName);
    }

    public void setPrincipalDao(LdapPrincipalDao principalDao) {
        this.principalDao = principalDao;
    }

    public LdapPrincipalDao getPrincipalDao() {
        return this.principalDao;
    }
}

