/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.ldap;

import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.address.EntityAddress;
import org.kuali.rice.kim.ldap.BaseMapper;
import org.springframework.ldap.core.DirContextOperations;

public class EntityAddressMapper
extends BaseMapper<EntityAddress> {
    @Override
    EntityAddress mapDtoFromContext(DirContextOperations context) {
        return this.mapDtoFromContext(context, false);
    }

    EntityAddress mapDtoFromContext(DirContextOperations context, boolean isdefault) {
        EntityAddress.Builder builder = this.mapBuilderFromContext(context, isdefault);
        return builder != null ? builder.build() : null;
    }

    EntityAddress.Builder mapBuilderFromContext(DirContextOperations context) {
        return this.mapBuilderFromContext(context, false);
    }

    EntityAddress.Builder mapBuilderFromContext(DirContextOperations context, boolean isdefault) {
        EntityAddress.Builder builder = EntityAddress.Builder.create();
        String line1 = context.getStringAttribute("employeePrimaryDeptName");
        String line2 = context.getStringAttribute("employeePoBox");
        String city = context.getStringAttribute("employeeCity");
        String stateProvinceCode = context.getStringAttribute("employeeState");
        String postalCode = context.getStringAttribute("employeeZip");
        builder.setAddressType(CodedAttribute.Builder.create((String)"WORK"));
        builder.setLine1(line1);
        builder.setLine2(line2);
        builder.setCity(city);
        builder.setStateProvinceCode(stateProvinceCode);
        builder.setPostalCode(postalCode);
        builder.setDefaultValue(isdefault);
        builder.setActive(true);
        return builder;
    }
}

