/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.ldap;

import java.util.ArrayList;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifier;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.ldap.BaseMapper;
import org.kuali.rice.kim.ldap.EntityAffiliationMapper;
import org.kuali.rice.kim.ldap.EntityEmploymentMapper;
import org.kuali.rice.kim.ldap.EntityNameMapper;
import org.kuali.rice.kim.ldap.EntityTypeContactInfoDefaultMapper;
import org.kuali.rice.kim.ldap.InvalidLdapEntityException;
import org.springframework.ldap.core.DirContextOperations;

public class EntityDefaultMapper
extends BaseMapper<EntityDefault> {
    private EntityAffiliationMapper affiliationMapper;
    private EntityTypeContactInfoDefaultMapper entityTypeContactInfoDefaultMapper;
    private EntityNameMapper defaultNameMapper;
    private EntityEmploymentMapper employmentMapper;

    @Override
    EntityDefault mapDtoFromContext(DirContextOperations context) {
        EntityDefault.Builder builder = this.mapBuilderFromContext(context);
        return builder != null ? builder.build() : null;
    }

    EntityDefault.Builder mapBuilderFromContext(DirContextOperations context) {
        String entityId = context.getStringAttribute(this.getConstants().getKimLdapIdProperty());
        String principalName = context.getStringAttribute(this.getConstants().getKimLdapNameProperty());
        EntityDefault.Builder person = EntityDefault.Builder.create((String)entityId);
        if (entityId == null) {
            throw new InvalidLdapEntityException("LDAP Search Results yielded an invalid result with attributes " + context.getAttributes());
        }
        person.setAffiliations(new ArrayList());
        person.setExternalIdentifiers(new ArrayList());
        EntityExternalIdentifier.Builder externalId = EntityExternalIdentifier.Builder.create();
        externalId.setExternalIdentifierTypeCode(this.getConstants().getTaxExternalIdTypeCode());
        externalId.setExternalId(entityId);
        person.getExternalIdentifiers().add(externalId);
        person.setAffiliations(this.getAffiliationMapper().mapBuilderFromContext(context));
        person.setEntityTypeContactInfos(new ArrayList());
        person.getEntityTypeContactInfos().add(this.getEntityTypeContactInfoDefaultMapper().mapBuilderFromContext(context));
        person.setName(this.getDefaultNameMapper().mapBuilderFromContext(context));
        person.setEntityId(entityId);
        person.setEmployment(this.getEmploymentMapper().mapBuilderFromContext(context));
        person.setEntityId(entityId);
        person.setPrincipals(new ArrayList());
        person.setActive(true);
        Principal.Builder defaultPrincipal = Principal.Builder.create((String)principalName);
        defaultPrincipal.setPrincipalId(entityId);
        defaultPrincipal.setEntityId(entityId);
        person.getPrincipals().add(defaultPrincipal);
        return person;
    }

    public final EntityAffiliationMapper getAffiliationMapper() {
        return this.affiliationMapper;
    }

    public final void setAffiliationMapper(EntityAffiliationMapper argAffiliationMapper) {
        this.affiliationMapper = argAffiliationMapper;
    }

    public final EntityTypeContactInfoDefaultMapper getEntityTypeContactInfoDefaultMapper() {
        return this.entityTypeContactInfoDefaultMapper;
    }

    public final void setEntityTypeContactInfoDefaultMapper(EntityTypeContactInfoDefaultMapper argEntityTypeMapper) {
        this.entityTypeContactInfoDefaultMapper = argEntityTypeMapper;
    }

    public final EntityNameMapper getDefaultNameMapper() {
        return this.defaultNameMapper;
    }

    public final void setDefaultNameMapper(EntityNameMapper argDefaultNameMapper) {
        this.defaultNameMapper = argDefaultNameMapper;
    }

    public final EntityEmploymentMapper getEmploymentMapper() {
        return this.employmentMapper;
    }

    public final void setEmploymentMapper(EntityEmploymentMapper argEmploymentMapper) {
        this.employmentMapper = argEmploymentMapper;
    }
}

