/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.kim.api.identity.email.EntityEmail;
import org.kuali.rice.kim.api.identity.employment.EntityEmployment;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.api.identity.phone.EntityPhone;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfo;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfoContract;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.bo.ui.PersonDocumentAffiliation;
import org.kuali.rice.kim.bo.ui.PersonDocumentEmail;
import org.kuali.rice.kim.bo.ui.PersonDocumentEmploymentInfo;
import org.kuali.rice.kim.bo.ui.PersonDocumentName;
import org.kuali.rice.kim.bo.ui.PersonDocumentPhone;
import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.kim.impl.identity.entity.EntityBo;
import org.kuali.rice.kim.impl.identity.principal.PrincipalBo;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RoleMemberAttributeDataBo;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.kim.service.impl.UiDocumentServiceImpl;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.KRADUtils;

public class LdapUiDocumentServiceImpl
extends UiDocumentServiceImpl {
    public void loadEntityToPersonDoc(IdentityManagementPersonDocument identityManagementPersonDocument, String principalId) {
        Principal principal = this.getIdentityService().getPrincipal(principalId);
        if (principal == null) {
            throw new RuntimeException("Principal does not exist for principal id:" + principalId);
        }
        identityManagementPersonDocument.setPrincipalId(principal.getPrincipalId());
        identityManagementPersonDocument.setPrincipalName(principal.getPrincipalName());
        identityManagementPersonDocument.setActive(principal.isActive());
        Entity kimEntity = this.getIdentityService().getEntity(principal.getEntityId());
        identityManagementPersonDocument.setEntityId(kimEntity.getId());
        if (KRADUtils.isNotNull((Object)kimEntity.getPrivacyPreferences())) {
            identityManagementPersonDocument.setPrivacy(this.loadPrivacyReferences(kimEntity.getPrivacyPreferences()));
        }
        identityManagementPersonDocument.setAffiliations(this.loadAffiliations(kimEntity.getAffiliations(), kimEntity.getEmploymentInformation()));
        identityManagementPersonDocument.setNames(this.loadNames(identityManagementPersonDocument, principalId, kimEntity.getNames(), identityManagementPersonDocument.getPrivacy().isSuppressName()));
        EntityTypeContactInfo entityType = null;
        for (EntityTypeContactInfo type : kimEntity.getEntityTypeContactInfos()) {
            if (!"PERSON".equals(type.getEntityTypeCode())) continue;
            entityType = EntityTypeContactInfo.Builder.create((EntityTypeContactInfoContract)type).build();
        }
        if (entityType != null) {
            identityManagementPersonDocument.setEmails(this.loadEmails(identityManagementPersonDocument, principalId, entityType.getEmailAddresses(), identityManagementPersonDocument.getPrivacy().isSuppressEmail()));
            identityManagementPersonDocument.setPhones(this.loadPhones(identityManagementPersonDocument, principalId, entityType.getPhoneNumbers(), identityManagementPersonDocument.getPrivacy().isSuppressPhone()));
            identityManagementPersonDocument.setAddrs(this.loadAddresses(identityManagementPersonDocument, principalId, entityType.getAddresses(), identityManagementPersonDocument.getPrivacy().isSuppressAddress()));
        }
        List groups = this.getGroupService().getGroups((Collection)this.getGroupService().getDirectGroupIdsByPrincipalId(identityManagementPersonDocument.getPrincipalId()));
        this.loadGroupToPersonDoc(identityManagementPersonDocument, groups);
        this.loadRoleToPersonDoc(identityManagementPersonDocument);
        this.loadDelegationsToPersonDoc(identityManagementPersonDocument);
    }

    protected String getInitiatorPrincipalId(Document document) {
        try {
            return document.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void saveEntityPerson(IdentityManagementPersonDocument identityManagementPersonDocument) {
        boolean inactivatingPrincipal = false;
        List groupPrincipals = this.populateGroupMembers(identityManagementPersonDocument);
        List rolePrincipals = this.populateRoleMembers(identityManagementPersonDocument);
        List personDelegations = this.populateDelegations(identityManagementPersonDocument);
        ArrayList bos = new ArrayList();
        List roleRspActions = this.populateRoleRspActions(identityManagementPersonDocument);
        List blankRoleMemberAttrs = this.getBlankRoleMemberAttrs(rolePrincipals);
        bos.addAll(groupPrincipals);
        bos.addAll(rolePrincipals);
        bos.addAll(roleRspActions);
        bos.addAll(personDelegations);
        for (Object bo : bos) {
            this.getDataObjectService().save(bo, new PersistenceOption[0]);
        }
        for (RoleMemberAttributeDataBo blankRoleMemberAttr : blankRoleMemberAttrs) {
            this.getDataObjectService().delete((Object)blankRoleMemberAttr);
        }
        if (inactivatingPrincipal) {
            KimImplServiceLocator.getRoleInternalService().principalInactivated(identityManagementPersonDocument.getPrincipalId());
        }
    }

    protected boolean setupPrincipal(IdentityManagementPersonDocument identityManagementPersonDocument, EntityBo kimEntity, List<PrincipalBo> origPrincipals) {
        boolean inactivatingPrincipal = false;
        ArrayList<PrincipalBo> principals = new ArrayList<PrincipalBo>();
        Principal.Builder principal = Principal.Builder.create((String)identityManagementPersonDocument.getPrincipalName());
        principal.setPrincipalId(identityManagementPersonDocument.getPrincipalId());
        principal.setActive(identityManagementPersonDocument.isActive());
        principal.setEntityId(identityManagementPersonDocument.getEntityId());
        if (KRADUtils.isNotNull(origPrincipals)) {
            for (PrincipalBo prncpl : origPrincipals) {
                if (prncpl.getPrincipalId() == null || !StringUtils.equals((String)prncpl.getPrincipalId(), (String)principal.getPrincipalId())) continue;
                principal.setVersionNumber(prncpl.getVersionNumber());
                principal.setObjectId(prncpl.getObjectId());
                if (!prncpl.isActive() || principal.isActive()) continue;
                inactivatingPrincipal = true;
            }
        }
        principals.add(PrincipalBo.from((Principal)principal.build()));
        kimEntity.setPrincipals(principals);
        return inactivatingPrincipal;
    }

    protected List<PersonDocumentAffiliation> loadAffiliations(List<EntityAffiliation> affiliations, List<EntityEmployment> empInfos) {
        ArrayList<PersonDocumentAffiliation> docAffiliations = new ArrayList<PersonDocumentAffiliation>();
        if (KRADUtils.isNotNull(affiliations)) {
            for (EntityAffiliation affiliation : affiliations) {
                if (!affiliation.isActive()) continue;
                PersonDocumentAffiliation docAffiliation = new PersonDocumentAffiliation();
                docAffiliation.setAffiliationTypeCode(affiliation.getAffiliationType().getCode());
                docAffiliation.setCampusCode(affiliation.getCampusCode());
                docAffiliation.setActive(affiliation.isActive());
                docAffiliation.setDflt(affiliation.isDefaultValue());
                docAffiliation.setEntityAffiliationId(affiliation.getId());
                docAffiliation.refreshReferenceObject("affiliationType");
                docAffiliations.add(docAffiliation);
                docAffiliation.setEdit(true);
                ArrayList<PersonDocumentEmploymentInfo> docEmploymentInformations = new ArrayList<PersonDocumentEmploymentInfo>();
                if (KRADUtils.isNotNull(empInfos)) {
                    for (EntityEmployment empInfo : empInfos) {
                        if (!empInfo.isActive() || !StringUtils.equals((String)docAffiliation.getEntityAffiliationId(), empInfo.getEntityAffiliation() != null ? empInfo.getEntityAffiliation().getId() : null)) continue;
                        PersonDocumentEmploymentInfo docEmpInfo = new PersonDocumentEmploymentInfo();
                        docEmpInfo.setEntityEmploymentId(empInfo.getEmployeeId());
                        docEmpInfo.setEmployeeId(empInfo.getEmployeeId());
                        docEmpInfo.setEmploymentRecordId(empInfo.getEmploymentRecordId());
                        docEmpInfo.setBaseSalaryAmount(empInfo.getBaseSalaryAmount());
                        docEmpInfo.setPrimaryDepartmentCode(empInfo.getPrimaryDepartmentCode());
                        docEmpInfo.setEmploymentStatusCode(empInfo.getEmployeeStatus() != null ? empInfo.getEmployeeStatus().getCode() : null);
                        docEmpInfo.setEmploymentTypeCode(empInfo.getEmployeeType() != null ? empInfo.getEmployeeType().getCode() : null);
                        docEmpInfo.setActive(empInfo.isActive());
                        docEmpInfo.setPrimary(empInfo.isPrimary());
                        docEmpInfo.setEntityAffiliationId(empInfo.getEntityAffiliation() != null ? empInfo.getEntityAffiliation().getId() : null);
                        docEmpInfo.setEdit(true);
                        docEmpInfo.refreshReferenceObject("employmentType");
                        docEmploymentInformations.add(docEmpInfo);
                    }
                }
                docAffiliation.setEmpInfos(docEmploymentInformations);
            }
        }
        return docAffiliations;
    }

    protected List<PersonDocumentName> loadNames(IdentityManagementPersonDocument personDoc, String principalId, List<EntityName> names, boolean suppressDisplay) {
        ArrayList<PersonDocumentName> docNames = new ArrayList<PersonDocumentName>();
        if (KRADUtils.isNotNull(names)) {
            for (EntityName name : names) {
                if (!name.isActive()) continue;
                PersonDocumentName docName = new PersonDocumentName();
                if (name.getNameType() != null) {
                    docName.setNameCode(name.getNameType().getCode());
                }
                docName.setFirstName(name.getFirstNameUnmasked());
                docName.setLastName(name.getLastNameUnmasked());
                docName.setMiddleName(name.getMiddleNameUnmasked());
                docName.setNamePrefix(name.getNamePrefixUnmasked());
                docName.setNameSuffix(name.getNameSuffixUnmasked());
                docName.setActive(name.isActive());
                docName.setDflt(name.isDefaultValue());
                docName.setEdit(true);
                docName.setEntityNameId(name.getId());
                docNames.add(docName);
            }
        }
        return docNames;
    }

    protected List<PersonDocumentEmail> loadEmails(IdentityManagementPersonDocument identityManagementPersonDocument, String principalId, List<EntityEmail> entityEmails, boolean suppressDisplay) {
        ArrayList<PersonDocumentEmail> emails = new ArrayList<PersonDocumentEmail>();
        if (KRADUtils.isNotNull(entityEmails)) {
            for (EntityEmail email : entityEmails) {
                if (!email.isActive()) continue;
                PersonDocumentEmail docEmail = new PersonDocumentEmail();
                docEmail.setEntityTypeCode(email.getEntityTypeCode());
                if (email.getEmailType() != null) {
                    docEmail.setEmailTypeCode(email.getEmailType().getCode());
                }
                docEmail.setEmailAddress(email.getEmailAddressUnmasked());
                docEmail.setActive(email.isActive());
                docEmail.setDflt(email.isDefaultValue());
                docEmail.setEntityEmailId(email.getId());
                docEmail.setEdit(true);
                emails.add(docEmail);
            }
        }
        return emails;
    }

    protected List<PersonDocumentPhone> loadPhones(IdentityManagementPersonDocument identityManagementPersonDocument, String principalId, List<EntityPhone> entityPhones, boolean suppressDisplay) {
        ArrayList<PersonDocumentPhone> docPhones = new ArrayList<PersonDocumentPhone>();
        if (KRADUtils.isNotNull(entityPhones)) {
            for (EntityPhone phone : entityPhones) {
                if (!phone.isActive()) continue;
                PersonDocumentPhone docPhone = new PersonDocumentPhone();
                if (phone.getPhoneType() != null) {
                    docPhone.setPhoneTypeCode(phone.getPhoneType().getCode());
                }
                docPhone.setEntityTypeCode(phone.getEntityTypeCode());
                docPhone.setPhoneNumber(phone.getPhoneNumberUnmasked());
                docPhone.setCountryCode(phone.getCountryCodeUnmasked());
                docPhone.setExtensionNumber(phone.getExtensionNumberUnmasked());
                docPhone.setActive(phone.isActive());
                docPhone.setDflt(phone.isDefaultValue());
                docPhone.setEntityPhoneId(phone.getId());
                docPhone.setEdit(true);
                docPhones.add(docPhone);
            }
        }
        return docPhones;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getMember(String memberTypeCode, String memberId) {
        Class<PrincipalBo> roleMemberTypeClass = null;
        if (MemberType.PRINCIPAL.getCode().equals(memberTypeCode)) {
            roleMemberTypeClass = PrincipalBo.class;
            Principal principalInfo = this.getIdentityService().getPrincipal(memberId);
            if (principalInfo == null) return this.getDataObjectService().find(roleMemberTypeClass, (Object)memberId);
        }
        if (MemberType.GROUP.getCode().equals(memberTypeCode)) {
            roleMemberTypeClass = GroupBo.class;
            Group groupInfo = null;
            groupInfo = this.getGroupService().getGroup(memberId);
            if (groupInfo == null) return this.getDataObjectService().find(roleMemberTypeClass, (Object)memberId);
        }
        if (!MemberType.ROLE.getCode().equals(memberTypeCode)) return this.getDataObjectService().find(roleMemberTypeClass, (Object)memberId);
        roleMemberTypeClass = RoleBo.class;
        Role role = this.getRoleService().getRole(memberId);
        if (role == null) return this.getDataObjectService().find(roleMemberTypeClass, (Object)memberId);
        return this.getDataObjectService().find(roleMemberTypeClass, (Object)memberId);
    }

    public boolean canModifyEntity(String currentUserPrincipalId, String toModifyPrincipalId) {
        return StringUtils.isNotBlank((String)currentUserPrincipalId) && StringUtils.isNotBlank((String)toModifyPrincipalId) && currentUserPrincipalId.equals(toModifyPrincipalId) || this.getPermissionService().isAuthorized(currentUserPrincipalId, "KR-IDM", "Modify Entity", Collections.singletonMap("principalId", currentUserPrincipalId));
    }
}

