/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.inquiry;

import java.security.GeneralSecurityException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kns.datadictionary.InquirySectionDefinition;
import org.kuali.rice.kns.inquiry.Inquirable;
import org.kuali.rice.kns.inquiry.InquiryRestrictions;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.service.BusinessObjectAuthorizationService;
import org.kuali.rice.kns.service.BusinessObjectDictionaryService;
import org.kuali.rice.kns.service.BusinessObjectMetaDataService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.util.InactiveRecordsHidingUtils;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.kns.web.ui.SectionBridge;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DataObjectRelationship;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.datadictionary.AttributeSecurity;
import org.kuali.rice.krad.inquiry.InquirableImpl;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LookupService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.util.ExternalizableBusinessObjectUtils;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.util.UrlFactory;

public class KualiInquirableImpl
extends InquirableImpl
implements Inquirable {
    private static final Logger LOG = Logger.getLogger(KualiInquirableImpl.class);
    protected LookupService lookupService;
    protected BusinessObjectAuthorizationService businessObjectAuthorizationService;
    protected BusinessObjectDictionaryService businessObjectDictionaryService;
    protected BusinessObjectMetaDataService businessObjectMetaDataService;
    protected PersistenceStructureService persistenceStructureService;
    protected EncryptionService encryptionService;
    protected static BusinessObjectService businessObjectService;
    protected Map<String, Boolean> inactiveRecordDisplay = new HashMap<String, Boolean>();
    public static final String INQUIRY_TITLE_PREFIX = "title.inquiry.url.value.prependtext";

    public Object retrieveDataObject(Map fieldValues) {
        if (this.getDataObjectClass() == null) {
            LOG.error((Object)"Data object class not set in inquirable.");
            throw new RuntimeException("Data object class not set in inquirable.");
        }
        CollectionIncomplete searchResults = null;
        ModuleService moduleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(this.getDataObjectClass());
        if (moduleService != null && moduleService.isExternalizable(this.getDataObjectClass())) {
            ExternalizableBusinessObject bo = moduleService.getExternalizableBusinessObject(this.getBusinessObjectClass(), fieldValues);
            if (bo != null) {
                ArrayList<ExternalizableBusinessObject> list = new ArrayList<ExternalizableBusinessObject>(1);
                list.add(bo);
                searchResults = new CollectionIncomplete(list, Long.valueOf(1L));
            }
        } else {
            searchResults = (CollectionIncomplete)this.getLookupService().findCollectionBySearch(this.getBusinessObjectClass(), fieldValues);
        }
        BusinessObject foundObject = null;
        if (searchResults != null && searchResults.size() > 0) {
            foundObject = (BusinessObject)searchResults.get(0);
        }
        return foundObject;
    }

    @Override
    @Deprecated
    public BusinessObject getBusinessObject(Map fieldValues) {
        return (BusinessObject)this.retrieveDataObject(fieldValues);
    }

    @Override
    @Deprecated
    public List<Section> getSections(BusinessObject bo) {
        ArrayList<Section> sections = new ArrayList<Section>();
        if (this.getBusinessObjectClass() == null) {
            LOG.error((Object)"Business object class not set in inquirable.");
            throw new RuntimeException("Business object class not set in inquirable.");
        }
        InquiryRestrictions inquiryRestrictions = KNSServiceLocator.getBusinessObjectAuthorizationService().getInquiryRestrictions(bo, GlobalVariables.getUserSession().getPerson());
        List inquirySections = this.getBusinessObjectDictionaryService().getInquirySections(this.getBusinessObjectClass());
        for (InquirySectionDefinition inquirySection : inquirySections) {
            if (inquiryRestrictions.isHiddenSectionId(inquirySection.getId())) continue;
            Section section = SectionBridge.toSection(this, inquirySection, bo, inquiryRestrictions);
            sections.add(section);
        }
        return sections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public HtmlData getInquiryUrl(BusinessObject businessObject, String attributeName, boolean forceInquiry) {
        Object documentNumber;
        Properties parameters = new Properties();
        HtmlData.AnchorHtmlData hRef = new HtmlData.AnchorHtmlData("", "");
        parameters.put("methodToCall", "start");
        Class inquiryBusinessObjectClass = null;
        String attributeRefName = "";
        boolean isPkReference = false;
        boolean doesNestedReferenceHaveOwnPrimitiveReference = false;
        BusinessObject nestedBusinessObject = null;
        Class businessObjectClass = ObjectUtils.materializeClassForProxiedObject((Object)businessObject);
        if (attributeName.equals(this.getBusinessObjectDictionaryService().getTitleAttribute(businessObjectClass))) {
            inquiryBusinessObjectClass = businessObjectClass;
            isPkReference = true;
        } else if (ObjectUtils.isNestedAttribute((String)attributeName)) {
            String nestedReferenceName = ObjectUtils.getNestedAttributePrefix((String)attributeName);
            Object nestedReferenceObject = ObjectUtils.getNestedValue((Object)businessObject, (String)nestedReferenceName);
            if (ObjectUtils.isNotNull((Object)nestedReferenceObject) && nestedReferenceObject instanceof BusinessObject) {
                nestedBusinessObject = (BusinessObject)nestedReferenceObject;
                String nestedAttributePrimitive = ObjectUtils.getNestedAttributePrimitive((String)attributeName);
                Class nestedBusinessObjectClass = ObjectUtils.materializeClassForProxiedObject((Object)nestedBusinessObject);
                if (nestedAttributePrimitive.equals(this.getBusinessObjectDictionaryService().getTitleAttribute(nestedBusinessObjectClass))) {
                    inquiryBusinessObjectClass = nestedBusinessObjectClass;
                    doesNestedReferenceHaveOwnPrimitiveReference = false;
                } else {
                    Map primitiveReference = LookupUtils.getPrimitiveReference(nestedBusinessObject, nestedAttributePrimitive);
                    if (primitiveReference != null && !primitiveReference.isEmpty()) {
                        attributeRefName = (String)primitiveReference.keySet().iterator().next();
                        inquiryBusinessObjectClass = (Class)primitiveReference.get(attributeRefName);
                        doesNestedReferenceHaveOwnPrimitiveReference = true;
                    } else {
                        inquiryBusinessObjectClass = ObjectUtils.materializeClassForProxiedObject((Object)nestedBusinessObject);
                        doesNestedReferenceHaveOwnPrimitiveReference = false;
                    }
                }
            }
        } else {
            Map primitiveReference = LookupUtils.getPrimitiveReference(businessObject, attributeName);
            if (primitiveReference != null && !primitiveReference.isEmpty()) {
                attributeRefName = (String)primitiveReference.keySet().iterator().next();
                inquiryBusinessObjectClass = (Class)primitiveReference.get(attributeRefName);
            }
        }
        if (inquiryBusinessObjectClass != null && DocumentHeader.class.isAssignableFrom(inquiryBusinessObjectClass)) {
            documentNumber = (String)ObjectUtils.getPropertyValue((Object)businessObject, (String)attributeName);
            if (!StringUtils.isBlank((String)documentNumber)) {
                hRef.setHref(this.getKualiConfigurationService().getPropertyValueAsString("workflow.url") + "/DocHandler.do?docId=" + (String)documentNumber + "&command=displayDocSearchView");
            }
            return hRef;
        }
        if (inquiryBusinessObjectClass == null || this.getBusinessObjectDictionaryService().isInquirable(inquiryBusinessObjectClass) == null || !this.getBusinessObjectDictionaryService().isInquirable(inquiryBusinessObjectClass).booleanValue()) {
            return hRef;
        }
        documentNumber = SUPER_CLASS_TRANSLATOR_LIST;
        synchronized (documentNumber) {
            for (Class clazz : SUPER_CLASS_TRANSLATOR_LIST) {
                if (!clazz.isAssignableFrom(inquiryBusinessObjectClass)) continue;
                inquiryBusinessObjectClass = clazz;
                break;
            }
        }
        if (!inquiryBusinessObjectClass.isInterface() && ExternalizableBusinessObject.class.isAssignableFrom(inquiryBusinessObjectClass)) {
            inquiryBusinessObjectClass = ExternalizableBusinessObjectUtils.determineExternalizableBusinessObjectSubInterface((Class)inquiryBusinessObjectClass);
        }
        parameters.put("businessObjectClassName", inquiryBusinessObjectClass.getName());
        List<Object> keys = new ArrayList(this.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(inquiryBusinessObjectClass));
        if (keys == null) {
            keys = Collections.emptyList();
        }
        DataObjectRelationship dataObjectRelationship = null;
        if (attributeRefName != null && !"".equals(attributeRefName) && (dataObjectRelationship = this.getBusinessObjectMetaDataService().getBusinessObjectRelationship(businessObject, attributeRefName)) != null && dataObjectRelationship.getParentToChildReferences() != null) {
            for (String targetNamePrimaryKey : dataObjectRelationship.getParentToChildReferences().values()) {
                keys.add(targetNamePrimaryKey);
            }
        }
        String keyName = null;
        String keyConversion = null;
        HashMap<String, String> fieldList = new HashMap<String, String>();
        Iterator<Object> iter = keys.iterator();
        while (iter.hasNext()) {
            keyConversion = keyName = (String)iter.next();
            if (ObjectUtils.isNestedAttribute((String)attributeName)) {
                if (doesNestedReferenceHaveOwnPrimitiveReference) {
                    String nestedAttributePrefix = ObjectUtils.getNestedAttributePrefix((String)attributeName);
                    String foreignKeyFieldName = this.getBusinessObjectMetaDataService().getForeignKeyFieldName(nestedBusinessObject.getClass(), attributeRefName, keyName);
                    keyConversion = nestedAttributePrefix + "." + foreignKeyFieldName;
                } else {
                    keyConversion = ObjectUtils.getNestedAttributePrefix((String)attributeName) + "." + keyName;
                }
            } else if (isPkReference) {
                keyConversion = keyName;
            } else if (dataObjectRelationship != null) {
                DualHashBidiMap bidiMap = new DualHashBidiMap(dataObjectRelationship.getParentToChildReferences());
                keyConversion = (String)bidiMap.getKey((Object)keyName);
            }
            Object keyValue = null;
            if (keyConversion != null) {
                keyValue = ObjectUtils.getPropertyValue((Object)businessObject, (String)keyConversion);
            }
            if (keyValue == null) {
                keyValue = "";
            } else if (keyValue instanceof Date) {
                if (Formatter.findFormatter(keyValue.getClass()) != null) {
                    Formatter formatter = Formatter.getFormatter(keyValue.getClass());
                    keyValue = (String)formatter.format(keyValue);
                }
            } else {
                keyValue = keyValue.toString();
            }
            AttributeSecurity attributeSecurity = KRADServiceLocatorWeb.getDataDictionaryService().getAttributeSecurity(businessObject.getClass().getName(), keyName);
            if (attributeSecurity != null && attributeSecurity.hasRestrictionThatRemovesValueFromUI()) {
                try {
                    if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                        keyValue = this.getEncryptionService().encrypt(keyValue);
                    }
                }
                catch (GeneralSecurityException e) {
                    LOG.error((Object)"Exception while trying to encrypted value for inquiry framework.", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            parameters.put(keyName, keyValue);
            fieldList.put(keyName, keyValue.toString());
        }
        return this.getHyperLink(inquiryBusinessObjectClass, fieldList, UrlFactory.parameterizeUrl((String)"inquiry.do", (Properties)parameters));
    }

    @Deprecated
    protected HtmlData.AnchorHtmlData getHyperLink(Class inquiryClass, Map<String, String> fieldList, String inquiryUrl) {
        HtmlData.AnchorHtmlData a = new HtmlData.AnchorHtmlData(inquiryUrl, "");
        a.setTitle(HtmlData.getTitleText(this.createTitleText(inquiryClass), inquiryClass, fieldList));
        return a;
    }

    @Deprecated
    protected String createTitleText(Class<?> dataObjectClass) {
        String objectLabel;
        String titleText = "";
        String titlePrefixProp = this.getKualiConfigurationService().getPropertyValueAsString(INQUIRY_TITLE_PREFIX);
        if (StringUtils.isNotBlank((String)titlePrefixProp)) {
            titleText = titleText + titlePrefixProp + " ";
        }
        if (StringUtils.isNotBlank((String)(objectLabel = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(dataObjectClass.getName()).getObjectLabel()))) {
            titleText = titleText + objectLabel + " ";
        }
        return titleText;
    }

    @Override
    @Deprecated
    public void addAdditionalSections(List columns, BusinessObject bo) {
    }

    @Override
    @Deprecated
    public String getHtmlMenuBar() {
        return this.getBusinessObjectDictionaryService().getLookupMenuBar(this.getBusinessObjectClass());
    }

    @Override
    @Deprecated
    public String getTitle() {
        return this.getBusinessObjectDictionaryService().getInquiryTitle(this.getBusinessObjectClass());
    }

    @Override
    @Deprecated
    public void setBusinessObjectClass(Class businessObjectClass) {
        this.dataObjectClass = businessObjectClass;
    }

    @Deprecated
    public Class getBusinessObjectClass() {
        return this.dataObjectClass;
    }

    @Override
    @Deprecated
    public Map<String, Boolean> getInactiveRecordDisplay() {
        return this.inactiveRecordDisplay;
    }

    @Override
    @Deprecated
    public boolean getShowInactiveRecords(String collectionName) {
        return InactiveRecordsHidingUtils.getShowInactiveRecords(this.inactiveRecordDisplay, collectionName);
    }

    @Override
    @Deprecated
    public void setShowInactiveRecords(String collectionName, boolean showInactive) {
        InactiveRecordsHidingUtils.setShowInactiveRecords(this.inactiveRecordDisplay, collectionName, showInactive);
    }

    protected LookupService getLookupService() {
        if (this.lookupService == null) {
            this.lookupService = KRADServiceLocatorWeb.getLookupService();
        }
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    protected BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        if (this.businessObjectDictionaryService == null) {
            this.businessObjectDictionaryService = KNSServiceLocator.getBusinessObjectDictionaryService();
        }
        return this.businessObjectDictionaryService;
    }

    public void setBusinessObjectDictionaryService(BusinessObjectDictionaryService businessObjectDictionaryService) {
        this.businessObjectDictionaryService = businessObjectDictionaryService;
    }

    protected PersistenceStructureService getPersistenceStructureService() {
        if (this.persistenceStructureService == null) {
            this.persistenceStructureService = KRADServiceLocator.getPersistenceStructureService();
        }
        return this.persistenceStructureService;
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    protected EncryptionService getEncryptionService() {
        if (this.encryptionService == null) {
            this.encryptionService = CoreApiServiceLocator.getEncryptionService();
        }
        return this.encryptionService;
    }

    public void setEncryptionService(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    protected ConfigurationService getKualiConfigurationService() {
        return this.getConfigurationService();
    }

    protected BusinessObjectMetaDataService getBusinessObjectMetaDataService() {
        if (this.businessObjectMetaDataService == null) {
            this.businessObjectMetaDataService = KNSServiceLocator.getBusinessObjectMetaDataService();
        }
        return this.businessObjectMetaDataService;
    }

    public void setBusinessObjectMetaDataService(BusinessObjectMetaDataService businessObjectMetaDataService) {
        this.businessObjectMetaDataService = businessObjectMetaDataService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (businessObjectService == null) {
            businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return businessObjectService;
    }

    protected BusinessObjectAuthorizationService getBusinessObjectAuthorizationService() {
        if (this.businessObjectAuthorizationService == null) {
            this.businessObjectAuthorizationService = KNSServiceLocator.getBusinessObjectAuthorizationService();
        }
        return this.businessObjectAuthorizationService;
    }

    public void setBusinessObjectAuthorizationService(BusinessObjectAuthorizationService businessObjectAuthorizationService) {
        this.businessObjectAuthorizationService = businessObjectAuthorizationService;
    }

    @Deprecated
    protected HtmlData.AnchorHtmlData getInquiryUrlForPrimaryKeys(Class clazz, Object businessObject, List<String> primaryKeys, String displayText) {
        if (businessObject == null) {
            return new HtmlData.AnchorHtmlData("", "");
        }
        Properties parameters = new Properties();
        parameters.put("methodToCall", "start");
        parameters.put("businessObjectClassName", clazz.getName());
        HashMap<String, String> fieldList = new HashMap<String, String>();
        for (String primaryKey : primaryKeys) {
            String titleAttributeValue = (String)ObjectUtils.getPropertyValue((Object)businessObject, (String)primaryKey);
            parameters.put(primaryKey, titleAttributeValue);
            fieldList.put(primaryKey, titleAttributeValue);
        }
        if (StringUtils.isEmpty((String)displayText)) {
            return this.getHyperLink(clazz, fieldList, UrlFactory.parameterizeUrl((String)"inquiry.do", (Properties)parameters));
        }
        return this.getHyperLink(clazz, fieldList, UrlFactory.parameterizeUrl((String)"inquiry.do", (Properties)parameters), displayText);
    }

    @Deprecated
    protected HtmlData.AnchorHtmlData getHyperLink(Class inquiryClass, Map<String, String> fieldList, String inquiryUrl, String displayText) {
        HtmlData.AnchorHtmlData a = new HtmlData.AnchorHtmlData(inquiryUrl, "", displayText);
        a.setTitle(HtmlData.AnchorHtmlData.getTitleText(this.getKualiConfigurationService().getPropertyValueAsString(INQUIRY_TITLE_PREFIX) + " " + this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(inquiryClass.getName()).getObjectLabel() + " ", inquiryClass, fieldList));
        return a;
    }
}

